/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.SharedFloatReductionBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedFloat;
import java.nio.ByteBuffer;

public class SharedFloatBuf
extends FloatBuf {
    SharedFloat myItem;

    public SharedFloatBuf(SharedFloat item) {
        super(1);
        this.myItem = item;
    }

    @Override
    public float get(int i) {
        return this.myItem.get();
    }

    @Override
    public void put(int i, float item) {
        this.myItem.set(item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedFloatReductionBuf(this.myItem, (FloatOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 4) {
            buffer.putFloat(this.myItem.get());
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 4) {
            this.myItem.set(buffer.getFloat());
            return 1;
        }
        return 0;
    }
}

