/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedFloatArrayBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedFloatArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class SharedFloatArrayReductionBuf
extends SharedFloatArrayBuf {
    FloatOp myOp;

    public SharedFloatArrayReductionBuf(SharedFloatArray theArray, Range theRange, FloatOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("SharedFloatArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, float item) {
        this.myArray.reduce(this.myArrayOffset + i * this.myStride, item, this.myOp);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 4) {
            this.myArray.reduce(off, buffer.getFloat(), this.myOp);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

