/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedDoubleArrayBuf;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedDoubleArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class SharedDoubleArrayReductionBuf
extends SharedDoubleArrayBuf {
    DoubleOp myOp;

    public SharedDoubleArrayReductionBuf(SharedDoubleArray theArray, Range theRange, DoubleOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("SharedDoubleArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, double item) {
        this.myArray.reduce(this.myArrayOffset + i * this.myStride, item, this.myOp);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 8) {
            this.myArray.reduce(off, buffer.getDouble(), this.myOp);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

