/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectMatrixBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;

class ObjectMatrixReductionBuf<T>
extends ObjectMatrixBuf<T> {
    ObjectOp<T> myOp;
    ObjectMatrixBuf<T> myBuf;

    public ObjectMatrixReductionBuf(T[][] theMatrix, Range theRowRange, Range theColRange, ObjectOp<T> op, ObjectMatrixBuf<T> theBuf) {
        super(theMatrix, theRowRange, theColRange);
        if (op == null) {
            throw new NullPointerException("ObjectMatrixReductionBuf(): op is null");
        }
        this.myOp = op;
        this.myBuf = theBuf;
    }

    @Override
    public void put(int i, T item) {
        int row = this.i2r(i) * this.myRowStride + this.myLowerRow;
        int col = this.i2c(i) * this.myColStride + this.myLowerCol;
        this.myMatrix[row][col] = this.myOp.op(this.myMatrix[row][col], item);
        this.reset();
        this.myBuf.reset();
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ObjectMatrixBuf) {
                ObjectMatrixBuf src = (ObjectMatrixBuf)theSrc;
                ReduceArrays.reduce(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
                this.reset();
                this.myBuf.reset();
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)theSrc, this);
                this.reset();
                this.myBuf.reset();
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }
}

