/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectArrayBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;

class ObjectArrayReductionBuf<T>
extends ObjectArrayBuf<T> {
    ObjectOp<T> myOp;
    ObjectArrayBuf<T> myBuf;

    public ObjectArrayReductionBuf(T[] theArray, Range theRange, ObjectOp<T> op, ObjectArrayBuf<T> theBuf) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("ObjectArrayReductionBuf(): op is null");
        }
        this.myOp = op;
        this.myBuf = theBuf;
    }

    @Override
    public void put(int i, T item) {
        int off = this.myArrayOffset + i * this.myStride;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
        this.reset();
        this.myBuf.reset();
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ObjectArrayBuf) {
                ObjectArrayBuf src = (ObjectArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
                this.reset();
                this.myBuf.reset();
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)theSrc, this);
                this.reset();
                this.myBuf.reset();
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }
}

