/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class LongItemReductionBuf
extends LongBuf {
    LongItemBuf myBuf;
    LongOp myOp;

    public LongItemReductionBuf(LongItemBuf buf, LongOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("LongItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public long get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, long item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            buffer.putLong(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 8) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.getLong());
            return 1;
        }
        return 0;
    }
}

