/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerMatrixReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class IntegerMatrixBuf
extends IntegerBuf {
    int[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public IntegerMatrixBuf(int[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theRowRange.length() * theColRange.length());
        this.myMatrix = theMatrix;
        this.myRowRange = theRowRange;
        this.myColRange = theColRange;
        this.myLowerRow = theRowRange.lb();
        this.myRowCount = theRowRange.length();
        this.myRowStride = theRowRange.stride();
        this.myLowerCol = theColRange.lb();
        this.myColCount = theColRange.length();
        this.myColStride = theColRange.stride();
    }

    @Override
    public int get(int i) {
        return this.myMatrix[this.i2r(i) * this.myRowStride + this.myLowerRow][this.i2c(i) * this.myColStride + this.myLowerCol];
    }

    @Override
    public void put(int i, int item) {
        this.myMatrix[this.i2r((int)i) * this.myRowStride + this.myLowerRow][this.i2c((int)i) * this.myColStride + this.myLowerCol] = item;
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof IntegerMatrixBuf) {
                IntegerMatrixBuf src = (IntegerMatrixBuf)theSrc;
                Arrays.copy(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
            } else {
                IntegerBuf.defaultCopy((IntegerBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new IntegerMatrixReductionBuf(this.myMatrix, this.myRowRange, this.myColRange, (IntegerOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        IntBuffer intbuffer = buffer.asIntBuffer();
        int n = 0;
        int r = this.i2r(i);
        int row = r * this.myRowStride + this.myLowerRow;
        int c = this.i2c(i);
        int col = c * this.myColStride + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, intbuffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            int[] myMatrix_row = this.myMatrix[row];
            while (c < ncols) {
                intbuffer.put(myMatrix_row[col]);
                ++c;
                col += this.myColStride;
            }
            n += ncols;
            ++r;
            row += this.myRowStride;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, intbuffer.remaining());
        }
        buffer.position(buffer.position() + 4 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        IntBuffer intbuffer = buffer.asIntBuffer();
        num = Math.min(num, intbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r * this.myRowStride + this.myLowerRow;
        int c = this.i2c(i);
        int col = c * this.myColStride + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            int[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = intbuffer.get();
                col += this.myColStride;
            }
            n += ncols;
            ++r;
            row += this.myRowStride;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 4 * n);
        return n;
    }

    int i2r(int i) {
        return this.myColCount == 0 ? i : i / this.myColCount;
    }

    int i2c(int i) {
        return this.myColCount == 0 ? 0 : i % this.myColCount;
    }
}

