/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatMatrixBuf;
import edu.rit.mp.buf.FloatMatrixBuf_1;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

class FloatMatrixReductionBuf_1
extends FloatMatrixBuf_1 {
    FloatOp myOp;

    public FloatMatrixReductionBuf_1(float[][] theMatrix, Range theRowRange, Range theColRange, FloatOp op) {
        super(theMatrix, theRowRange, theColRange);
        if (op == null) {
            throw new NullPointerException("FloatMatrixReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, float item) {
        int row = i / this.myColCount + this.myLowerRow;
        int col = i % this.myColCount + this.myLowerCol;
        this.myMatrix[row][col] = this.myOp.op(this.myMatrix[row][col], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof FloatMatrixBuf) {
                FloatMatrixBuf src = (FloatMatrixBuf)theSrc;
                ReduceArrays.reduce(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                FloatBuf.defaultCopy((FloatBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        FloatBuffer floatbuffer = buffer.asFloatBuffer();
        num = Math.min(num, floatbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            float[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = this.myOp.op(myMatrix_row[col], floatbuffer.get());
                ++col;
            }
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 4 * n);
        return n;
    }
}

