/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.FloatMatrixBuf;
import edu.rit.mp.buf.FloatMatrixReductionBuf_1;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class FloatMatrixBuf_1
extends FloatMatrixBuf {
    public FloatMatrixBuf_1(float[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theMatrix, theRowRange, theColRange);
    }

    @Override
    public float get(int i) {
        return this.myMatrix[this.i2r(i) + this.myLowerRow][this.i2c(i) + this.myLowerCol];
    }

    @Override
    public void put(int i, float item) {
        this.myMatrix[this.i2r((int)i) + this.myLowerRow][this.i2c((int)i) + this.myLowerCol] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new FloatMatrixReductionBuf_1(this.myMatrix, this.myRowRange, this.myColRange, (FloatOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        FloatBuffer floatbuffer = buffer.asFloatBuffer();
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, floatbuffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            floatbuffer.put(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, floatbuffer.remaining());
        }
        buffer.position(buffer.position() + 4 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        FloatBuffer floatbuffer = buffer.asFloatBuffer();
        num = Math.min(num, floatbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            floatbuffer.get(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 4 * n);
        return n;
    }
}

