/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.FloatArrayBuf;
import edu.rit.mp.buf.FloatArrayReductionBuf_1;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class FloatArrayBuf_1
extends FloatArrayBuf {
    public FloatArrayBuf_1(float[] theArray, Range theRange) {
        super(theArray, theRange);
    }

    @Override
    public float get(int i) {
        return this.myArray[this.myArrayOffset + i];
    }

    @Override
    public void put(int i, float item) {
        this.myArray[this.myArrayOffset + i] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new FloatArrayReductionBuf_1(this.myArray, this.myRange, (FloatOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        FloatBuffer floatbuffer = buffer.asFloatBuffer();
        int n = Math.min(this.myLength - i, floatbuffer.remaining());
        floatbuffer.put(this.myArray, this.myArrayOffset + i, n);
        buffer.position(buffer.position() + 4 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        FloatBuffer floatbuffer = buffer.asFloatBuffer();
        int n = Math.min(num, Math.min(this.myLength - i, floatbuffer.remaining()));
        floatbuffer.get(this.myArray, this.myArrayOffset + i, n);
        buffer.position(buffer.position() + 4 * n);
        return n;
    }
}

