/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleArrayBuf;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class DoubleArrayReductionBuf
extends DoubleArrayBuf {
    DoubleOp myOp;

    public DoubleArrayReductionBuf(double[] theArray, Range theRange, DoubleOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("DoubleArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, double item) {
        int off = this.myArrayOffset + i * this.myStride;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof DoubleArrayBuf) {
                DoubleArrayBuf src = (DoubleArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                DoubleBuf.defaultCopy((DoubleBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 8) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.getDouble());
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

