/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.CharacterMatrixBuf;
import edu.rit.mp.buf.CharacterMatrixReductionBuf_1;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class CharacterMatrixBuf_1
extends CharacterMatrixBuf {
    public CharacterMatrixBuf_1(char[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theMatrix, theRowRange, theColRange);
    }

    @Override
    public char get(int i) {
        return this.myMatrix[this.i2r(i) + this.myLowerRow][this.i2c(i) + this.myLowerCol];
    }

    @Override
    public void put(int i, char item) {
        this.myMatrix[this.i2r((int)i) + this.myLowerRow][this.i2c((int)i) + this.myLowerCol] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new CharacterMatrixReductionBuf_1(this.myMatrix, this.myRowRange, this.myColRange, (CharacterOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        CharBuffer charbuffer = buffer.asCharBuffer();
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, charbuffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            charbuffer.put(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, charbuffer.remaining());
        }
        buffer.position(buffer.position() + 2 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        CharBuffer charbuffer = buffer.asCharBuffer();
        num = Math.min(num, charbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            charbuffer.get(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 2 * n);
        return n;
    }
}

