/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterItemBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class CharacterItemReductionBuf
extends CharacterBuf {
    CharacterItemBuf myBuf;
    CharacterOp myOp;

    public CharacterItemReductionBuf(CharacterItemBuf buf, CharacterOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("CharacterItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public char get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, char item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 2) {
            buffer.putChar(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 2) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.getChar());
            return 1;
        }
        return 0;
    }
}

