/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterArrayReductionBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class CharacterArrayBuf
extends CharacterBuf {
    char[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public CharacterArrayBuf(char[] theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public char get(int i) {
        return this.myArray[this.myArrayOffset + i * this.myStride];
    }

    @Override
    public void put(int i, char item) {
        this.myArray[this.myArrayOffset + i * this.myStride] = item;
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof CharacterArrayBuf) {
                CharacterArrayBuf src = (CharacterArrayBuf)theSrc;
                Arrays.copy(src.myArray, src.myRange, this.myArray, this.myRange);
            } else {
                CharacterBuf.defaultCopy((CharacterBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new CharacterArrayReductionBuf(this.myArray, this.myRange, (CharacterOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 2) {
            buffer.putChar(this.myArray[off]);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 2) {
            this.myArray[off] = buffer.getChar();
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

