/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.ByteItemBuf;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class ByteItemReductionBuf
extends ByteBuf {
    ByteItemBuf myBuf;
    ByteOp myOp;

    public ByteItemReductionBuf(ByteItemBuf buf, ByteOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("ByteItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public byte get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, byte item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 1) {
            buffer.put(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 1) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.get());
            return 1;
        }
        return 0;
    }
}

