/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.MPObjectInputStream;
import edu.rit.mp.Status;
import edu.rit.mp.buf.EmptyObjectBuf;
import edu.rit.mp.buf.ObjectArrayBuf;
import edu.rit.mp.buf.ObjectArrayBuf_1;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.mp.buf.ObjectMatrixBuf;
import edu.rit.mp.buf.ObjectMatrixBuf_1;
import edu.rit.mp.buf.SharedObjectArrayBuf;
import edu.rit.mp.buf.SharedObjectArrayBuf_1;
import edu.rit.mp.buf.SharedObjectBuf;
import edu.rit.pj.reduction.SharedObject;
import edu.rit.pj.reduction.SharedObjectArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public abstract class ObjectBuf<T>
extends Buf {
    protected byte[] mySerializedItems;

    protected ObjectBuf(int theLength) {
        super((byte)9, theLength);
    }

    public static ObjectBuf<Object> emptyBuffer() {
        return new EmptyObjectBuf();
    }

    public static <T> ObjectItemBuf<T> buffer() {
        return new ObjectItemBuf();
    }

    public static <T> ObjectItemBuf<T> buffer(T item) {
        return new ObjectItemBuf<T>(item);
    }

    public static <T> ObjectBuf<T> buffer(T[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("ObjectBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new ObjectArrayBuf_1<T>(theArray, new Range(0, nr - 1));
    }

    public static <T> ObjectBuf<T> sliceBuffer(T[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("ObjectBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ObjectBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new ObjectArrayBuf_1<T>(theArray, theRange);
        }
        return new ObjectArrayBuf<T>(theArray, theRange);
    }

    public static <T> ObjectBuf<T>[] sliceBuffers(T[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        ObjectBuf[] result = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ObjectBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static <T> ObjectItemBuf<T[]> objectBuffer(T[] theArray) {
        return new ObjectItemBuf<T[]>(theArray);
    }

    public static <T> ObjectBuf<T> buffer(T[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("ObjectBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new ObjectMatrixBuf_1<T>(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static <T> ObjectBuf<T> rowSliceBuffer(T[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ObjectBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ObjectBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new ObjectMatrixBuf_1<T>(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new ObjectMatrixBuf<T>(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static <T> ObjectBuf<T>[] rowSliceBuffers(T[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        ObjectBuf[] result = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ObjectBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static <T> ObjectBuf<T> colSliceBuffer(T[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ObjectBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("ObjectBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new ObjectMatrixBuf_1<T>(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new ObjectMatrixBuf<T>(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static <T> ObjectBuf<T>[] colSliceBuffers(T[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        ObjectBuf[] result = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ObjectBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static <T> ObjectBuf<T> patchBuffer(T[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ObjectBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ObjectBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("ObjectBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new ObjectMatrixBuf_1<T>(theMatrix, theRowRange, theColRange);
        }
        return new ObjectMatrixBuf<T>(theMatrix, theRowRange, theColRange);
    }

    public static <T> ObjectBuf<T>[] patchBuffers(T[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        ObjectBuf[] result = new ObjectBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = ObjectBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static <T> ObjectItemBuf<T[][]> objectBuffer(T[][] theMatrix) {
        return new ObjectItemBuf<T[][]>(theMatrix);
    }

    public static <T> ObjectBuf<T> buffer(SharedObject<T> item) {
        if (item == null) {
            throw new NullPointerException("ObjectBuf.buffer(): item is null");
        }
        return new SharedObjectBuf<T>(item);
    }

    public static <T> ObjectBuf<T> buffer(SharedObjectArray<T> theArray) {
        if (theArray == null) {
            throw new NullPointerException("ObjectBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedObjectArrayBuf_1<T>(theArray, new Range(0, nr - 1));
    }

    public static <T> ObjectBuf<T> sliceBuffer(SharedObjectArray<T> theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("ObjectBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ObjectBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedObjectArrayBuf_1<T>(theArray, theRange);
        }
        return new SharedObjectArrayBuf<T>(theArray, theRange);
    }

    public static <T> ObjectBuf<T>[] sliceBuffers(SharedObjectArray<T> theArray, Range[] theRanges) {
        int n = theRanges.length;
        ObjectBuf[] result = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ObjectBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract T get(int var1);

    public abstract void put(int var1, T var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            ObjectBuf.defaultCopy((ObjectBuf)theSrc, this);
            this.reset();
        }
    }

    @Override
    public void fill(Object item) {
        Object value = item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
        this.reset();
    }

    @Override
    public Buf getTemporaryBuf() {
        return ObjectBuf.buffer(new Object[this.myLength]);
    }

    public void reset() {
        this.mySerializedItems = null;
    }

    @Override
    void preSend() throws IOException {
        if (this.mySerializedItems == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeInt(this.myLength);
            for (int i = 0; i < this.myLength; ++i) {
                oos.writeObject(this.get(i));
            }
            oos.close();
            this.mySerializedItems = baos.toByteArray();
            this.myMessageLength = this.mySerializedItems.length;
        }
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int len = Math.min(this.myMessageLength - i, buffer.remaining());
        buffer.put(this.mySerializedItems, i, len);
        return len;
    }

    @Override
    void preReceive(int theReadLength) {
        this.mySerializedItems = new byte[theReadLength];
        this.myMessageLength = theReadLength;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int len = num;
        len = Math.min(len, this.myMessageLength - i);
        len = Math.min(len, buffer.remaining());
        buffer.get(this.mySerializedItems, i, len);
        return len;
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining());
        buffer.position(buffer.position() + n);
        return n;
    }

    @Override
    void postReceive(Status theStatus, ClassLoader theClassLoader) throws IOException {
        try {
            byte[] savedSerializedItems = this.mySerializedItems;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mySerializedItems);
            MPObjectInputStream ois = new MPObjectInputStream(bais, theClassLoader);
            int nmsg = ois.readInt();
            int n = Math.min(this.myLength, nmsg);
            for (int i = 0; i < n; ++i) {
                this.put(i, ois.readObject());
            }
            ois.close();
            theStatus.length = nmsg;
            this.mySerializedItems = savedSerializedItems;
        }
        catch (ClassNotFoundException exc) {
            throw new IOException("ObjectBuf.postReceive(): Class not found", exc);
        }
        catch (ClassCastException exc) {
            throw new IOException("ObjectBuf.postReceive(): Wrong type", exc);
        }
    }

    protected static <T> void defaultCopy(ObjectBuf<T> theSrc, ObjectBuf<T> theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

