/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import edu.rit.mp.NetworkChannel;
import edu.rit.mp.Status;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

class NetworkChannelReceiveThread
extends Thread {
    private NetworkChannel myNetworkChannel;
    private ChannelGroup myChannelGroup;
    private SocketChannel mySocketChannel;
    private IORequestList myIORequestList;
    private ByteBuffer myByteBuffer;

    NetworkChannelReceiveThread(NetworkChannel theNetworkChannel, SocketChannel theSocketChannel) {
        this.myNetworkChannel = theNetworkChannel;
        this.myChannelGroup = theNetworkChannel.myChannelGroup;
        this.mySocketChannel = theSocketChannel;
        this.myIORequestList = theNetworkChannel.myIORequestList;
        this.myByteBuffer = ByteBuffer.allocateDirect(29200);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        block17: {
            IORequest iorequest = null;
            Buf buf = null;
            this.myByteBuffer.position(0);
            this.myByteBuffer.limit(0);
            try {
                while (true) {
                    if (this.myByteBuffer.remaining() < 13) {
                        this.myByteBuffer.compact();
                        if (this.mySocketChannel.read(this.myByteBuffer) != -1) {
                            this.myByteBuffer.flip();
                            continue;
                        }
                        break;
                    }
                    int magic = this.myByteBuffer.getInt();
                    int messagetag = this.myByteBuffer.getInt();
                    byte messagetype = this.myByteBuffer.get();
                    int messagelength = this.myByteBuffer.getInt();
                    if (magic != 30144596) {
                        this.myChannelGroup.myLogger.log("edu.rit.mp.NetworkChannelReceiveThread: Invalid magic number received");
                        this.myNetworkChannel.close();
                        break;
                    }
                    iorequest = this.myIORequestList.waitForMatch(this.myNetworkChannel, messagetag, messagetype);
                    buf = iorequest.myBuf;
                    buf.preReceive(messagelength);
                    int buflength = buf.myMessageLength;
                    int i = 0;
                    int num = Math.min(messagelength, buflength);
                    int n = buf.receiveItems(i, num, this.myByteBuffer);
                    i += n;
                    num -= n;
                    while (num > 0) {
                        this.myByteBuffer.compact();
                        if (this.mySocketChannel.read(this.myByteBuffer) == -1) {
                            throw new EOFException("Unexpected end-of-stream while receiving message");
                        }
                        this.myByteBuffer.flip();
                        n = buf.receiveItems(i, num, this.myByteBuffer);
                        i += n;
                        num -= n;
                    }
                    num = messagelength - buflength;
                    if (num > 0) {
                        num -= buf.skipItems(num, this.myByteBuffer);
                        while (num > 0) {
                            this.myByteBuffer.compact();
                            if (this.mySocketChannel.read(this.myByteBuffer) == -1) {
                                throw new EOFException("Unexpected end-of-stream while receiving message");
                            }
                            this.myByteBuffer.flip();
                            num -= buf.skipItems(num, this.myByteBuffer);
                        }
                    }
                    Status status = new Status(this.myNetworkChannel, messagetag, messagelength);
                    buf.postReceive(status, this.myChannelGroup.myClassLoader);
                    iorequest.myStatus = status;
                    iorequest.reportSuccess();
                    iorequest = null;
                    buf = null;
                }
            }
            catch (IOException exc) {
                if (iorequest != null) {
                    iorequest.reportFailure(exc);
                }
            }
            catch (InterruptedException exc) {
                if (iorequest != null) {
                    InterruptedIOException exc2 = new InterruptedIOException();
                    exc2.initCause(exc);
                    iorequest.reportFailure(exc2);
                }
            }
            catch (RuntimeException exc) {
                if (iorequest != null) {
                    iorequest.reportFailure(exc);
                }
            }
            catch (Error exc) {
                if (iorequest == null) break block17;
                iorequest.reportFailure(exc);
            }
        }
        this.myNetworkChannel.shutdownInput();
        this.myNetworkChannel = null;
        this.myChannelGroup = null;
        this.mySocketChannel = null;
        this.myIORequestList = null;
        this.myByteBuffer = null;
    }
}

