/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.Status;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;

class LoopbackChannel
extends Channel {
    LoopbackChannel(ChannelGroup theChannelGroup) {
        super(theChannelGroup);
    }

    @Override
    public int nearEndChannelGroupId() {
        return this.myChannelGroup.myChannelGroupId;
    }

    @Override
    public int farEndChannelGroupId() {
        return this.myChannelGroup.myChannelGroupId;
    }

    @Override
    public InetSocketAddress nearEndAddress() {
        return new InetSocketAddress(0);
    }

    @Override
    public InetSocketAddress farEndAddress() {
        return new InetSocketAddress(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void send(IORequest theIORequest) throws IOException {
        IORequest recvRequest;
        LoopbackChannel loopbackChannel = this;
        synchronized (loopbackChannel) {
            if (this.myWriteState == 1) {
                throw new IOException("edu.rit.mp.LoopbackChannel: Channel closed");
            }
        }
        try {
            recvRequest = this.myIORequestList.waitForMatch(theIORequest);
        }
        catch (InterruptedException exc) {
            InterruptedIOException exc2 = new InterruptedIOException("edu.rit.mp.LoopbackChannel: Send interrupted");
            exc2.initCause(exc);
            throw exc2;
        }
        recvRequest.myBuf.copy(theIORequest.myBuf);
        recvRequest.myStatus = new Status(this, theIORequest.myTagLb, theIORequest.myBuf.myLength);
        theIORequest.reportSuccess();
        recvRequest.reportSuccess();
    }
}

