/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.EmptyFloatBuf;
import edu.rit.mp.buf.FloatArrayBuf;
import edu.rit.mp.buf.FloatArrayBuf_1;
import edu.rit.mp.buf.FloatItemBuf;
import edu.rit.mp.buf.FloatMatrixBuf;
import edu.rit.mp.buf.FloatMatrixBuf_1;
import edu.rit.mp.buf.SharedFloatArrayBuf;
import edu.rit.mp.buf.SharedFloatArrayBuf_1;
import edu.rit.mp.buf.SharedFloatBuf;
import edu.rit.pj.reduction.SharedFloat;
import edu.rit.pj.reduction.SharedFloatArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class FloatBuf
extends Buf {
    protected FloatBuf(int theLength) {
        super((byte)7, theLength);
    }

    public static FloatBuf emptyBuffer() {
        return new EmptyFloatBuf();
    }

    public static FloatItemBuf buffer() {
        return new FloatItemBuf();
    }

    public static FloatItemBuf buffer(float item) {
        return new FloatItemBuf(item);
    }

    public static FloatBuf buffer(float[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("FloatBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new FloatArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static FloatBuf sliceBuffer(float[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("FloatBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("FloatBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new FloatArrayBuf_1(theArray, theRange);
        }
        return new FloatArrayBuf(theArray, theRange);
    }

    public static FloatBuf[] sliceBuffers(float[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        FloatBuf[] result = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = FloatBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static FloatBuf buffer(float[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("FloatBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new FloatMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static FloatBuf rowSliceBuffer(float[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("FloatBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("FloatBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new FloatMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new FloatMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static FloatBuf[] rowSliceBuffers(float[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        FloatBuf[] result = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = FloatBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static FloatBuf colSliceBuffer(float[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("FloatBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("FloatBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new FloatMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new FloatMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static FloatBuf[] colSliceBuffers(float[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        FloatBuf[] result = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = FloatBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static FloatBuf patchBuffer(float[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("FloatBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("FloatBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("FloatBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new FloatMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new FloatMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static FloatBuf[] patchBuffers(float[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        FloatBuf[] result = new FloatBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = FloatBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static FloatBuf buffer(SharedFloat item) {
        if (item == null) {
            throw new NullPointerException("FloatBuf.buffer(): item is null");
        }
        return new SharedFloatBuf(item);
    }

    public static FloatBuf buffer(SharedFloatArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("FloatBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedFloatArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static FloatBuf sliceBuffer(SharedFloatArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("FloatBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("FloatBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedFloatArrayBuf_1(theArray, theRange);
        }
        return new SharedFloatArrayBuf(theArray, theRange);
    }

    public static FloatBuf[] sliceBuffers(SharedFloatArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        FloatBuf[] result = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = FloatBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract float get(int var1);

    public abstract void put(int var1, float var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            FloatBuf.defaultCopy((FloatBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        float value = item == null ? 0.0f : ((Float)item).floatValue();
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return FloatBuf.buffer(new float[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining() / 4);
        buffer.position(buffer.position() + 4 * n);
        return n;
    }

    protected static void defaultCopy(FloatBuf theSrc, FloatBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

