/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.DoubleArrayBuf;
import edu.rit.mp.buf.DoubleArrayBuf_1;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.mp.buf.DoubleMatrixBuf;
import edu.rit.mp.buf.DoubleMatrixBuf_1;
import edu.rit.mp.buf.EmptyDoubleBuf;
import edu.rit.mp.buf.SharedDoubleArrayBuf;
import edu.rit.mp.buf.SharedDoubleArrayBuf_1;
import edu.rit.mp.buf.SharedDoubleBuf;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedDoubleArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class DoubleBuf
extends Buf {
    protected DoubleBuf(int theLength) {
        super((byte)8, theLength);
    }

    public static DoubleBuf emptyBuffer() {
        return new EmptyDoubleBuf();
    }

    public static DoubleItemBuf buffer() {
        return new DoubleItemBuf();
    }

    public static DoubleItemBuf buffer(double item) {
        return new DoubleItemBuf(item);
    }

    public static DoubleBuf buffer(double[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("DoubleBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new DoubleArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static DoubleBuf sliceBuffer(double[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("DoubleBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("DoubleBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new DoubleArrayBuf_1(theArray, theRange);
        }
        return new DoubleArrayBuf(theArray, theRange);
    }

    public static DoubleBuf[] sliceBuffers(double[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        DoubleBuf[] result = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = DoubleBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static DoubleBuf buffer(double[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("DoubleBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new DoubleMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static DoubleBuf rowSliceBuffer(double[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("DoubleBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("DoubleBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new DoubleMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new DoubleMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static DoubleBuf[] rowSliceBuffers(double[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        DoubleBuf[] result = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = DoubleBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static DoubleBuf colSliceBuffer(double[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("DoubleBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("DoubleBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new DoubleMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new DoubleMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static DoubleBuf[] colSliceBuffers(double[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        DoubleBuf[] result = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = DoubleBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static DoubleBuf patchBuffer(double[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("DoubleBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("DoubleBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("DoubleBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new DoubleMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new DoubleMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static DoubleBuf[] patchBuffers(double[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        DoubleBuf[] result = new DoubleBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = DoubleBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static DoubleBuf buffer(SharedDouble item) {
        if (item == null) {
            throw new NullPointerException("DoubleBuf.buffer(): item is null");
        }
        return new SharedDoubleBuf(item);
    }

    public static DoubleBuf buffer(SharedDoubleArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("DoubleBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedDoubleArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static DoubleBuf sliceBuffer(SharedDoubleArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("DoubleBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("DoubleBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedDoubleArrayBuf_1(theArray, theRange);
        }
        return new SharedDoubleArrayBuf(theArray, theRange);
    }

    public static DoubleBuf[] sliceBuffers(SharedDoubleArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        DoubleBuf[] result = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = DoubleBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract double get(int var1);

    public abstract void put(int var1, double var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            DoubleBuf.defaultCopy((DoubleBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        double value = item == null ? 0.0 : (Double)item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return DoubleBuf.buffer(new double[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining() / 8);
        buffer.position(buffer.position() + 8 * n);
        return n;
    }

    protected static void defaultCopy(DoubleBuf theSrc, DoubleBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

