/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.CharacterArrayBuf;
import edu.rit.mp.buf.CharacterArrayBuf_1;
import edu.rit.mp.buf.CharacterItemBuf;
import edu.rit.mp.buf.CharacterMatrixBuf;
import edu.rit.mp.buf.CharacterMatrixBuf_1;
import edu.rit.mp.buf.EmptyCharacterBuf;
import edu.rit.mp.buf.SharedCharacterArrayBuf;
import edu.rit.mp.buf.SharedCharacterArrayBuf_1;
import edu.rit.mp.buf.SharedCharacterBuf;
import edu.rit.pj.reduction.SharedCharacter;
import edu.rit.pj.reduction.SharedCharacterArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class CharacterBuf
extends Buf {
    protected CharacterBuf(int theLength) {
        super((byte)6, theLength);
    }

    public static CharacterBuf emptyBuffer() {
        return new EmptyCharacterBuf();
    }

    public static CharacterItemBuf buffer() {
        return new CharacterItemBuf();
    }

    public static CharacterItemBuf buffer(char item) {
        return new CharacterItemBuf(item);
    }

    public static CharacterBuf buffer(char[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("CharacterBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new CharacterArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static CharacterBuf sliceBuffer(char[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("CharacterBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("CharacterBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new CharacterArrayBuf_1(theArray, theRange);
        }
        return new CharacterArrayBuf(theArray, theRange);
    }

    public static CharacterBuf[] sliceBuffers(char[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        CharacterBuf[] result = new CharacterBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = CharacterBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static CharacterBuf buffer(char[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("CharacterBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new CharacterMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static CharacterBuf rowSliceBuffer(char[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("CharacterBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("CharacterBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new CharacterMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new CharacterMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static CharacterBuf[] rowSliceBuffers(char[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        CharacterBuf[] result = new CharacterBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = CharacterBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static CharacterBuf colSliceBuffer(char[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("CharacterBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("CharacterBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new CharacterMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new CharacterMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static CharacterBuf[] colSliceBuffers(char[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        CharacterBuf[] result = new CharacterBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = CharacterBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static CharacterBuf patchBuffer(char[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("CharacterBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("CharacterBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("CharacterBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new CharacterMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new CharacterMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static CharacterBuf[] patchBuffers(char[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        CharacterBuf[] result = new CharacterBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = CharacterBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static CharacterBuf buffer(SharedCharacter item) {
        if (item == null) {
            throw new NullPointerException("CharacterBuf.buffer(): item is null");
        }
        return new SharedCharacterBuf(item);
    }

    public static CharacterBuf buffer(SharedCharacterArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("CharacterBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedCharacterArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static CharacterBuf sliceBuffer(SharedCharacterArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("CharacterBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("CharacterBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedCharacterArrayBuf_1(theArray, theRange);
        }
        return new SharedCharacterArrayBuf(theArray, theRange);
    }

    public static CharacterBuf[] sliceBuffers(SharedCharacterArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        CharacterBuf[] result = new CharacterBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = CharacterBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract char get(int var1);

    public abstract void put(int var1, char var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            CharacterBuf.defaultCopy((CharacterBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        char value = item == null ? (char)'\u0000' : ((Character)item).charValue();
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return CharacterBuf.buffer(new char[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining() / 2);
        buffer.position(buffer.position() + 2 * n);
        return n;
    }

    protected static void defaultCopy(CharacterBuf theSrc, CharacterBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

