/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.ByteArrayBuf;
import edu.rit.mp.buf.ByteArrayBuf_1;
import edu.rit.mp.buf.ByteItemBuf;
import edu.rit.mp.buf.ByteMatrixBuf;
import edu.rit.mp.buf.ByteMatrixBuf_1;
import edu.rit.mp.buf.EmptyByteBuf;
import edu.rit.mp.buf.SharedByteArrayBuf;
import edu.rit.mp.buf.SharedByteArrayBuf_1;
import edu.rit.mp.buf.SharedByteBuf;
import edu.rit.pj.reduction.SharedByte;
import edu.rit.pj.reduction.SharedByteArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class ByteBuf
extends Buf {
    protected ByteBuf(int theLength) {
        super((byte)1, theLength);
    }

    public static ByteBuf emptyBuffer() {
        return new EmptyByteBuf();
    }

    public static ByteItemBuf buffer() {
        return new ByteItemBuf();
    }

    public static ByteItemBuf buffer(byte item) {
        return new ByteItemBuf(item);
    }

    public static ByteBuf buffer(byte[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("ByteBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new ByteArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static ByteBuf sliceBuffer(byte[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("ByteBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ByteBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new ByteArrayBuf_1(theArray, theRange);
        }
        return new ByteArrayBuf(theArray, theRange);
    }

    public static ByteBuf[] sliceBuffers(byte[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        ByteBuf[] result = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ByteBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static ByteBuf buffer(byte[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("ByteBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new ByteMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static ByteBuf rowSliceBuffer(byte[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ByteBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ByteBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new ByteMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new ByteMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static ByteBuf[] rowSliceBuffers(byte[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        ByteBuf[] result = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ByteBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static ByteBuf colSliceBuffer(byte[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ByteBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("ByteBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new ByteMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new ByteMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static ByteBuf[] colSliceBuffers(byte[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        ByteBuf[] result = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ByteBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static ByteBuf patchBuffer(byte[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ByteBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ByteBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("ByteBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new ByteMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new ByteMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static ByteBuf[] patchBuffers(byte[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        ByteBuf[] result = new ByteBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = ByteBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static ByteBuf buffer(SharedByte item) {
        if (item == null) {
            throw new NullPointerException("ByteBuf.buffer(): item is null");
        }
        return new SharedByteBuf(item);
    }

    public static ByteBuf buffer(SharedByteArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("ByteBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedByteArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static ByteBuf sliceBuffer(SharedByteArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("ByteBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ByteBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedByteArrayBuf_1(theArray, theRange);
        }
        return new SharedByteArrayBuf(theArray, theRange);
    }

    public static ByteBuf[] sliceBuffers(SharedByteArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        ByteBuf[] result = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ByteBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract byte get(int var1);

    public abstract void put(int var1, byte var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            ByteBuf.defaultCopy((ByteBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        byte value = item == null ? (byte)0 : (Byte)item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return ByteBuf.buffer(new byte[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining());
        buffer.position(buffer.position() + n);
        return n;
    }

    protected static void defaultCopy(ByteBuf theSrc, ByteBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

