/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import edu.rit.io.InvalidMatrixFileException;
import edu.rit.util.Range;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class DoubleMatrixFile {
    private static final long BYTES_PER_ELEMENT = 8L;
    private int R = -1;
    private int C = -1;
    private double[][] myMatrix;

    public DoubleMatrixFile() {
    }

    public DoubleMatrixFile(int R, int C, double[][] theMatrix) {
        this.setMatrix(R, C, theMatrix);
    }

    public int getRowCount() {
        return this.R;
    }

    public int getColCount() {
        return this.C;
    }

    public double[][] getMatrix() {
        return this.myMatrix;
    }

    public void setMatrix(int R, int C, double[][] theMatrix) {
        this.setRC(R, C);
        if (theMatrix.length != R) {
            throw new IllegalArgumentException("DoubleMatrixFile.setMatrix(): theMatrix.length (= " + theMatrix.length + ") does not equal R (= " + R + ")");
        }
        this.myMatrix = theMatrix;
    }

    public Writer prepareToWrite(OutputStream theStream) throws IOException {
        if (this.myMatrix == null) {
            throw new IllegalStateException("DoubleMatrixFile.prepareToWrite(): Not initialized");
        }
        return new Writer(this, theStream);
    }

    public Reader prepareToRead(InputStream theStream) throws IOException {
        return new Reader(this, theStream);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java edu.rit.io.DoubleMatrixFile <outfile> <infile1> [<infile2> ...]");
            System.exit(1);
        }
        DoubleMatrixFile dmf = new DoubleMatrixFile();
        for (int i = 1; i < args.length; ++i) {
            Reader reader = dmf.prepareToRead(new BufferedInputStream(new FileInputStream(args[i])));
            reader.read();
            reader.close();
        }
        Writer writer = dmf.prepareToWrite(new BufferedOutputStream(new FileOutputStream(args[0])));
        writer.write();
        writer.close();
    }

    void setRC(int R, int C) {
        if (R < 0) {
            throw new IllegalArgumentException("DoubleMatrixFile.setHeightAndWidth(): R = " + R + " illegal");
        }
        if (C < 0) {
            throw new IllegalArgumentException("DoubleMatrixFile.setHeightAndWidth(): C = " + C + " illegal");
        }
        this.R = R;
        this.C = C;
    }

    public class Writer {
        private OutputStream myOs;
        private DataOutputStream myDos;
        final /* synthetic */ DoubleMatrixFile this$0;

        private Writer(DoubleMatrixFile this$0, OutputStream theStream) throws IOException {
            DoubleMatrixFile doubleMatrixFile = this$0;
            Objects.requireNonNull(doubleMatrixFile);
            this.this$0 = doubleMatrixFile;
            if (theStream == null) {
                throw new NullPointerException("DoubleMatrixFile.Writer(): theStream is null");
            }
            this.myOs = theStream;
            this.myDos = new DataOutputStream(theStream);
            this.myDos.writeInt(this$0.R);
            this.myDos.writeInt(this$0.C);
        }

        public void write() throws IOException {
            this.write(0, this.this$0.R - 1, 0, this.this$0.C - 1);
        }

        public void writeRowSlice(Range theRowRange) throws IOException {
            if (theRowRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writeRowSlice(): theRowRange stride > 1");
            }
            int RL = theRowRange.lb();
            int RU = theRowRange.ub();
            if (0 > RL || RL + theRowRange.length() > this.this$0.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writeRowSlice(): theRowRange = " + String.valueOf(theRowRange) + " out of bounds");
            }
            this.write(RL, RU, 0, this.this$0.C - 1);
        }

        public void writeColSlice(Range theColRange) throws IOException {
            if (theColRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writeColSlice(): theColRange stride > 1");
            }
            int CL = theColRange.lb();
            int CU = theColRange.ub();
            if (0 > CL || CL + theColRange.length() > this.this$0.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writeColSlice(): theColRange = " + String.valueOf(theColRange) + " out of bounds");
            }
            this.write(0, this.this$0.R - 1, CL, CU);
        }

        public void writePatch(Range theRowRange, Range theColRange) throws IOException {
            if (theRowRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writePatch(): theRowRange stride > 1");
            }
            if (theColRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writePatch(): theColRange stride > 1");
            }
            int RL = theRowRange.lb();
            int RU = theRowRange.ub();
            if (0 > RL || RL + theRowRange.length() > this.this$0.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writePatch(): theRowRange = " + String.valueOf(theRowRange) + " out of bounds");
            }
            int CL = theColRange.lb();
            int CU = theColRange.ub();
            if (0 > CL || CL + theColRange.length() > this.this$0.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writePatch(): theColRange = " + String.valueOf(theColRange) + " out of bounds");
            }
            this.write(RL, RU, CL, CU);
        }

        public void close() throws IOException {
            this.myDos.close();
        }

        private void write(int RL, int RU, int CL, int CU) throws IOException {
            this.myDos.writeInt(RL);
            this.myDos.writeInt(CL);
            this.myDos.writeInt(RU - RL + 1);
            this.myDos.writeInt(CU - CL + 1);
            for (int r = RL; r <= RU; ++r) {
                double[] myMatrix_r = this.this$0.myMatrix[r];
                for (int c = CL; c <= CU; ++c) {
                    this.myDos.writeDouble(myMatrix_r[c]);
                }
            }
        }
    }

    public class Reader {
        private InputStream myIs;
        private DataInputStream myDis;
        private Range myRowRange;
        private Range myColRange;
        final /* synthetic */ DoubleMatrixFile this$0;

        private Reader(DoubleMatrixFile this$0, InputStream theStream) throws IOException {
            DoubleMatrixFile doubleMatrixFile = this$0;
            Objects.requireNonNull(doubleMatrixFile);
            this.this$0 = doubleMatrixFile;
            if (theStream == null) {
                throw new NullPointerException("DoubleMatrixFile.Reader(): theStream is null");
            }
            this.myIs = theStream;
            this.myDis = new DataInputStream(theStream);
            int R = this.myDis.readInt();
            int C = this.myDis.readInt();
            if (this$0.myMatrix == null) {
                this$0.setRC(R, C);
                this$0.myMatrix = new double[R][];
            } else {
                if (this$0.R != R) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader(): Number of rows from stream (" + R + ") != number of rows in this matrix file (" + this$0.R + ")");
                }
                if (this$0.C != C) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader(): Number of columns from stream (" + C + ") != number of columns in this matrix file (" + this$0.C + ")");
                }
            }
            this.getNextSegment();
        }

        public void read() throws IOException {
            while (this.myRowRange != null) {
                this.readSegment();
            }
        }

        public void readRowSlice(Range theRowRange) throws IOException {
            while (this.myRowRange != null) {
                this.readSegmentRowSlice(theRowRange);
            }
        }

        public void readColSlice(Range theColRange) throws IOException {
            while (this.myRowRange != null) {
                this.readSegmentColSlice(theColRange);
            }
        }

        public void readPatch(Range theRowRange, Range theColRange) throws IOException {
            while (this.myRowRange != null) {
                this.readSegmentPatch(theRowRange, theColRange);
            }
        }

        public Range getRowRange() {
            return this.myRowRange;
        }

        public Range getColRange() {
            return this.myColRange;
        }

        public void readSegment() throws IOException {
            this.readSegment(0, this.this$0.R - 1, 0, this.this$0.C - 1);
        }

        public void readSegmentRowSlice(Range theRowRange) throws IOException {
            if (theRowRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentRowSlice(): theRowRange stride > 1");
            }
            int RL = theRowRange.lb();
            int RU = theRowRange.ub();
            if (0 > RL || RL + theRowRange.length() > this.this$0.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentRowSlice(): theRowRange = " + String.valueOf(theRowRange) + " out of bounds");
            }
            this.readSegment(RL, RU, 0, this.this$0.C - 1);
        }

        public void readSegmentColSlice(Range theColRange) throws IOException {
            if (theColRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentColSlice(): theColRange stride > 1");
            }
            int CL = theColRange.lb();
            int CU = theColRange.ub();
            if (0 > CL || CL + theColRange.length() > this.this$0.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentColSlice(): theColRange = " + String.valueOf(theColRange) + " out of bounds");
            }
            this.readSegment(0, this.this$0.R - 1, CL, CU);
        }

        public void readSegmentPatch(Range theRowRange, Range theColRange) throws IOException {
            if (theRowRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentPatch(): theRowRange stride > 1");
            }
            int RL = theRowRange.lb();
            int RU = theRowRange.ub();
            if (0 > RL || RL + theRowRange.length() > this.this$0.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentPatch(): theRowRange = " + String.valueOf(theRowRange) + " out of bounds");
            }
            if (theColRange.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentPatch(): theColRange stride > 1");
            }
            int CL = theColRange.lb();
            int CU = theColRange.ub();
            if (0 > CL || CL + theColRange.length() > this.this$0.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentPatch(): theColRange = " + String.valueOf(theColRange) + " out of bounds");
            }
            this.readSegment(RL, RU, CL, CU);
        }

        public void close() throws IOException {
            this.myDis.close();
        }

        private void getNextSegment() throws IOException {
            try {
                int RL = this.myDis.readInt();
                int CL = this.myDis.readInt();
                int M = this.myDis.readInt();
                int N = this.myDis.readInt();
                if (RL < 0) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid segment lower row index (" + RL + ")");
                }
                if (CL < 0) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid segment lower column index (" + CL + ")");
                }
                if (M < 0 || RL + M > this.this$0.R) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid numer of rows in segment (" + M + ")");
                }
                if (N < 0 || CL + N > this.this$0.C) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid numer of columns in segment (" + N + ")");
                }
                this.myRowRange = new Range(RL, RL + M - 1);
                this.myColRange = new Range(CL, CL + N - 1);
            }
            catch (EOFException exc) {
                this.myRowRange = null;
                this.myColRange = null;
            }
        }

        private void readSegment(int RL, int RU, int CL, int CU) throws IOException {
            if (this.myRowRange == null) {
                return;
            }
            int SRL = this.myRowRange.lb();
            int SRU = this.myRowRange.ub();
            int SCL = this.myColRange.lb();
            int SCU = this.myColRange.ub();
            long rowBytes = 8L * (long)this.myColRange.length();
            int firstRow = Math.max(RL, SRL);
            int lastRow = Math.min(RU, SRU);
            int preSkipRows = firstRow - SRL;
            long preSkipRowBytes = (long)preSkipRows * rowBytes;
            int postSkipRows = SRU - lastRow;
            long postSkipRowBytes = (long)postSkipRows * rowBytes;
            int firstCol = Math.max(CL, SCL);
            int lastCol = Math.min(CU, SCU);
            int preSkipCols = firstCol - SCL;
            long preSkipColBytes = (long)preSkipCols * 8L;
            int postSkipCols = SCU - lastCol;
            long postSkipColBytes = (long)postSkipCols * 8L;
            this.skipFully(preSkipRowBytes);
            for (int r = firstRow; r <= lastRow; ++r) {
                double[] myMatrix_r = this.this$0.myMatrix[r];
                if (myMatrix_r == null) {
                    myMatrix_r = new double[this.this$0.C];
                    this.this$0.myMatrix[r] = myMatrix_r;
                }
                this.skipFully(preSkipColBytes);
                for (int c = firstCol; c <= lastCol; ++c) {
                    myMatrix_r[c] = this.myDis.readDouble();
                }
                this.skipFully(postSkipColBytes);
            }
            this.skipFully(postSkipRowBytes);
            this.getNextSegment();
        }

        private void skipFully(long n) throws IOException {
            while (n > 0L) {
                n -= this.myDis.skip(n);
            }
        }
    }
}

