/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.http;

import edu.rit.http.HttpRequest;
import edu.rit.http.HttpResponse;
import edu.rit.util.Logger;
import edu.rit.util.PrintStreamLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Objects;

public abstract class HttpServer {
    private ServerSocket myServerSocket;
    private AcceptorThread myAcceptorThread;
    private Logger myLogger;

    public HttpServer(InetSocketAddress address) throws IOException {
        this(address, null);
    }

    public HttpServer(InetSocketAddress address, Logger logger) throws IOException {
        this.myLogger = logger == null ? new PrintStreamLogger() : logger;
        this.myServerSocket = new ServerSocket();
        this.myServerSocket.bind(address);
        this.myAcceptorThread = new AcceptorThread(this);
        this.myAcceptorThread.setDaemon(true);
        this.myAcceptorThread.start();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.myServerSocket.getLocalSocketAddress();
    }

    public void close() throws IOException {
        this.myServerSocket.close();
    }

    protected abstract void process(HttpRequest var1, HttpResponse var2) throws IOException;

    private class AcceptorThread
    extends Thread {
        final /* synthetic */ HttpServer this$0;

        private AcceptorThread(HttpServer httpServer) {
            HttpServer httpServer2 = httpServer;
            Objects.requireNonNull(httpServer2);
            this.this$0 = httpServer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Socket socket = this.this$0.myServerSocket.accept();
                        socket.setSoTimeout(2000);
                        HttpRequest request = new HttpRequest(socket);
                        HttpResponse response = new HttpResponse(socket);
                        try {
                            this.this$0.process(request, response);
                        }
                        catch (Throwable exc) {
                            this.this$0.myLogger.log("Exception while processing HTTP request", exc);
                        }
                        finally {
                            try {
                                if (!socket.isClosed()) {
                                    socket.close();
                                }
                            }
                            catch (Throwable exc) {
                                this.this$0.myLogger.log("Exception while closing HTTP socket", exc);
                            }
                        }
                        socket = null;
                        request = null;
                        Object var3_4 = null;
                    }
                }
                catch (Throwable exc) {
                    if (!this.this$0.myServerSocket.isClosed()) {
                        this.this$0.myLogger.log("Exception while accepting HTTP connection", exc);
                    }
                    this.this$0.myLogger.log("HTTP server terminating");
                }
            }
            catch (Throwable throwable) {
                this.this$0.myLogger.log("HTTP server terminating");
                throw throwable;
            }
        }
    }
}

