/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.http;

import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class HttpRequest {
    public static final String GET_METHOD = "GET";
    public static final String HEAD_METHOD = "HEAD";
    public static final String POST_METHOD = "POST";
    public static final String HTTP_1_0_VERSION = "HTTP/1.0";
    public static final String HTTP_1_1_VERSION = "HTTP/1.1";
    private Socket mySocket;
    private String myMethod;
    private String myUri;
    private String myHttpVersion;
    private Map<String, String> myHeaderMap = new HashMap<String, String>();
    private Map<String, String> myUnmodifiableHeaderMap = Collections.unmodifiableMap(this.myHeaderMap);
    private boolean iamValid;

    public HttpRequest(Socket theSocket) {
        if (theSocket == null) {
            throw new NullPointerException("HttpRequest(): theSocket is null");
        }
        this.mySocket = theSocket;
    }

    public boolean isValid() {
        this.parse();
        return this.iamValid;
    }

    public String getMethod() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myMethod;
    }

    public String getUri() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myUri;
    }

    public String getHttpVersion() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myHttpVersion;
    }

    public String getHeader(String theHeaderName) {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myHeaderMap.get(theHeaderName);
    }

    public Collection<Map.Entry<String, String>> getHeaders() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myUnmodifiableHeaderMap.entrySet();
    }

    private void parse() {
        if (this.myMethod != null) {
            return;
        }
        this.iamValid = false;
        this.myMethod = "";
        this.myUri = "";
        this.myHttpVersion = "";
        try {
            Scanner scanner = new Scanner(this.mySocket.getInputStream());
            if (!scanner.hasNextLine()) {
                return;
            }
            String line = scanner.nextLine();
            Scanner linescanner = new Scanner(line);
            if (!linescanner.hasNext()) {
                return;
            }
            String method = linescanner.next();
            if (!linescanner.hasNext()) {
                return;
            }
            String uri = linescanner.next();
            if (!linescanner.hasNext()) {
                return;
            }
            String httpVersion = linescanner.next();
            if (linescanner.hasNext()) {
                return;
            }
            String headerName = null;
            StringBuilder headerValue = new StringBuilder();
            while (true) {
                int i;
                if (!scanner.hasNextLine()) {
                    return;
                }
                line = scanner.nextLine();
                if (line.isEmpty()) break;
                if (Character.isWhitespace(line.charAt(0))) {
                    if (headerName == null) {
                        return;
                    }
                    headerValue.append(line);
                    continue;
                }
                if (headerName != null) {
                    this.myHeaderMap.put(headerName, headerValue.toString());
                    headerName = null;
                    headerValue = new StringBuilder();
                }
                if ((i = line.indexOf(58)) <= 0) {
                    return;
                }
                if (i >= line.length() - 1) {
                    return;
                }
                if (!Character.isWhitespace(line.charAt(i + 1))) {
                    return;
                }
                headerName = line.substring(0, i);
                headerValue.append(line.substring(i + 2));
            }
            if (headerName != null) {
                this.myHeaderMap.put(headerName, headerValue.toString());
            }
            this.myMethod = method;
            this.myUri = uri;
            this.myHttpVersion = httpVersion;
            this.iamValid = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

