/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.atomtypes;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.config.atomtypes.OWLAtomTypeHandler;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OWLAtomTypeReader {
    private XMLReader parser;
    private final Reader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLAtomTypeReader.class);

    public OWLAtomTypeReader(Reader input) {
        this.init();
        this.input = input;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info((Object)"Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (FactoryConfigurationError | ParserConfigurationException | SAXException exception) {
                logger.warn((Object)"Could not instantiate JAXP/SAX XML reader!");
                logger.debug((Object)exception);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info((Object)"Using Xerces XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                logger.warn((Object)"Could not instantiate Xerces XML reader!");
                logger.debug((Object)exception);
            }
        }
        if (!success) {
            logger.error((Object)"Could not instantiate any XML parser!");
        }
    }

    public List<IAtomType> readAtomTypes(IChemObjectBuilder builder) {
        ArrayList<IAtomType> isotopes = new ArrayList();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info((Object)"Deactivated validation");
        }
        catch (SAXException exception) {
            logger.warn((Object)"Cannot deactivate validation: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        OWLAtomTypeHandler handler = new OWLAtomTypeHandler(builder);
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            isotopes = handler.getAtomTypes();
        }
        catch (IOException exception) {
            logger.error((Object)"IOException: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        catch (SAXException saxe) {
            logger.error((Object)"SAXException: ", new Object[]{saxe.getMessage()});
            logger.debug((Object)saxe);
        }
        return isotopes;
    }
}

