/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.Threading;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import jogamp.opengl.Debug;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ToolkitThreadingPlugin;

public class ThreadingImpl {
    protected static final boolean DEBUG = Debug.debug("Threading");
    private static boolean singleThreaded;
    private static Threading.Mode mode;
    private static boolean hasAWT;
    private static boolean _isX11;
    private static final ToolkitThreadingPlugin threadingPlugin;

    private ThreadingImpl() {
    }

    public static boolean isX11() {
        return _isX11;
    }

    public static Threading.Mode getMode() {
        return mode;
    }

    public static final void disableSingleThreading() {
        if (Threading.Mode.MT != mode) {
            singleThreaded = false;
            if (Debug.verbose()) {
                System.err.println("Application forced disabling of single-threading of com.jogamp.opengl implementation");
            }
        }
    }

    public static final boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static final boolean isOpenGLThread() throws GLException {
        if (Threading.Mode.MT == mode || !singleThreaded) {
            return true;
        }
        if (null != threadingPlugin) {
            return threadingPlugin.isOpenGLThread();
        }
        switch (mode) {
            case ST_AWT: {
                throw new InternalError();
            }
            case ST_WORKER: {
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + (Object)((Object)mode));
    }

    public static final boolean isToolkitThread() throws GLException {
        if (null != threadingPlugin) {
            return threadingPlugin.isToolkitThread();
        }
        return false;
    }

    public static final void invokeOnOpenGLThread(boolean bl, Runnable runnable) throws GLException {
        if (null != threadingPlugin) {
            threadingPlugin.invokeOnOpenGLThread(bl, runnable);
            return;
        }
        switch (mode) {
            case ST_WORKER: {
                ThreadingImpl.invokeOnWorkerThread(bl, runnable);
                break;
            }
            case MT: {
                runnable.run();
                break;
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + (Object)((Object)mode));
            }
        }
    }

    public static final void invokeOnWorkerThread(boolean bl, Runnable runnable) throws GLException {
        GLWorkerThread.start();
        try {
            GLWorkerThread.invoke(bl, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            throw new GLException(interruptedException);
        }
    }

    static {
        threadingPlugin = SecurityUtil.doPrivileged(new PrivilegedAction<ToolkitThreadingPlugin>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public ToolkitThreadingPlugin run() {
                Object object = PropertyAccess.getProperty("jogl.1thread", true);
                String string = null != object ? ((String)object).toLowerCase() : null;
                object = ThreadingImpl.class.getClassLoader();
                hasAWT = GLProfile.isAWTAvailable();
                _isX11 = ".x11" == NativeWindowFactory.getNativeWindowType(false);
                if (string != null) {
                    if (string.equals("true") || string.equals("auto")) {
                        ThreadingImpl.mode = hasAWT ? Threading.Mode.ST_AWT : Threading.Mode.MT;
                    } else if (string.equals("worker")) {
                        ThreadingImpl.mode = Threading.Mode.ST_WORKER;
                    } else if (hasAWT && string.equals("awt")) {
                        ThreadingImpl.mode = Threading.Mode.ST_AWT;
                    } else {
                        if (!string.equals("false")) throw new RuntimeException("Unsupported value for property jogl.1thread: " + string + ", should be [true/auto, worker, awt or false]");
                        ThreadingImpl.mode = Threading.Mode.MT;
                    }
                } else {
                    ThreadingImpl.mode = hasAWT ? Threading.Mode.ST_AWT : Threading.Mode.MT;
                }
                singleThreaded = Threading.Mode.MT != mode;
                ToolkitThreadingPlugin toolkitThreadingPlugin = null;
                if (hasAWT) {
                    JogampRuntimeException jogampRuntimeException = null;
                    try {
                        toolkitThreadingPlugin = (ToolkitThreadingPlugin)ReflectionUtil.createInstance("jogamp.opengl.awt.AWTThreadingPlugin", (ClassLoader)object);
                    }
                    catch (JogampRuntimeException jogampRuntimeException2) {
                        jogampRuntimeException = jogampRuntimeException2;
                    }
                    if (Threading.Mode.ST_AWT == mode && null == toolkitThreadingPlugin) {
                        throw new GLException("Mode is AWT, but class 'jogamp.opengl.awt.AWTThreadingPlugin' is not available", jogampRuntimeException);
                    }
                }
                if (!DEBUG) return toolkitThreadingPlugin;
                System.err.println("Threading: jogl.1thread " + string + ", singleThreaded " + singleThreaded + ", hasAWT " + hasAWT + ", mode " + (Object)((Object)mode) + ", plugin " + toolkitThreadingPlugin);
                return toolkitThreadingPlugin;
            }
        });
    }
}

