/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class DWM_BLURBEHIND {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] DWM_BLURBEHIND_size = new int[]{16, 16, 16, 16, 16, 16, 16, 24, 24, 24};
    private static final int[] dwFlags_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] fEnable_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] hRgnBlur_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] fTransitionOnMaximized_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 16, 16, 16};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return DWM_BLURBEHIND_size[mdIdx];
    }

    public static DWM_BLURBEHIND create() {
        return DWM_BLURBEHIND.create(Buffers.newDirectByteBuffer(DWM_BLURBEHIND.size()));
    }

    public static DWM_BLURBEHIND create(ByteBuffer byteBuffer) {
        return new DWM_BLURBEHIND(byteBuffer);
    }

    public static DWM_BLURBEHIND derefPointer(long l) {
        return DWM_BLURBEHIND.create(ElementBuffer.derefPointer(DWM_BLURBEHIND.size(), l, 1).getByteBuffer());
    }

    DWM_BLURBEHIND(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[DWM_BLURBEHIND.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final DWM_BLURBEHIND setDwFlags(int n) {
        this.accessor.setIntAt(dwFlags_offset[mdIdx], n);
        return this;
    }

    public final int getDwFlags() {
        return this.accessor.getIntAt(dwFlags_offset[mdIdx]);
    }

    public final DWM_BLURBEHIND setFEnable(int n) {
        this.accessor.setIntAt(fEnable_offset[mdIdx], n);
        return this;
    }

    public final int getFEnable() {
        return this.accessor.getIntAt(fEnable_offset[mdIdx]);
    }

    public final DWM_BLURBEHIND setHRgnBlur(long l) {
        PointerBuffer.wrap(this.getBuffer(), hRgnBlur_offset[mdIdx], 1).put(0, l);
        return this;
    }

    public final long getHRgnBlur() {
        return PointerBuffer.wrap(this.getBuffer(), hRgnBlur_offset[mdIdx], 1).get(0);
    }

    public final DWM_BLURBEHIND setFTransitionOnMaximized(int n) {
        this.accessor.setIntAt(fTransitionOnMaximized_offset[mdIdx], n);
        return this;
    }

    public final int getFTransitionOnMaximized() {
        return this.accessor.getIntAt(fTransitionOnMaximized_offset[mdIdx]);
    }
}

