/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import jogamp.graph.font.typecast.TypecastGlyph;
import jogamp.graph.font.typecast.TypecastHMetrics;
import jogamp.graph.font.typecast.TypecastRenderer;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.TTFont;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.HmtxTable;
import jogamp.graph.font.typecast.ot.table.KernSubtable;
import jogamp.graph.font.typecast.ot.table.KernTable;
import jogamp.graph.font.typecast.ot.table.PostTable;
import jogamp.opengl.Debug;

class TypecastFont
implements Font {
    private static final boolean DEBUG = Debug.debug("graph.font.Font");
    private static final char UNDEF_SYMBOL = '\uffff';
    private static final SymAndID UNDEF_VALUE = new SymAndID('\uffff', 0, ".notdef");
    final TTFont font;
    private final CmapFormat cmapFormat;
    private final int cmapentries;
    private final IntObjectHashMap idToGlyph;
    private final IntObjectHashMap cpToGlyph;
    private final Map<String, SymAndID> nameToGlyph;
    private final TypecastHMetrics metrics;
    private static final boolean forceAscii = false;

    public TypecastFont(OTFontCollection oTFontCollection) {
        int n;
        this.font = oTFontCollection.getFont(0);
        CmapTable cmapTable = this.font.getCmapTable();
        int n2 = -1;
        int n3 = -1;
        n2 = 3;
        n3 = 1;
        CmapFormat cmapFormat = cmapTable.getCmapFormat((short)3, (short)1);
        if (cmapFormat == null) {
            n3 = 0;
            cmapFormat = cmapTable.getCmapFormat((short)3, (short)0);
        }
        if (cmapFormat == null) {
            throw new RuntimeException("Cannot find a suitable cmap table");
        }
        this.cmapFormat = cmapFormat;
        int n4 = 0;
        for (int i = 0; i < this.cmapFormat.getRangeCount(); ++i) {
            CmapFormat.Range range = this.cmapFormat.getRange(i);
            n4 += range.getEndCode() - range.getStartCode() + 1;
        }
        this.cmapentries = n4;
        this.idToGlyph = new IntObjectHashMap(this.cmapentries + this.cmapentries / 4);
        this.idToGlyph.setKeyNotFoundValue(UNDEF_VALUE);
        this.cpToGlyph = new IntObjectHashMap(this.cmapentries + this.cmapentries / 4);
        this.cpToGlyph.setKeyNotFoundValue(UNDEF_VALUE);
        this.nameToGlyph = new HashMap<String, SymAndID>(this.cmapentries + this.cmapentries / 4);
        Object object = this.font.getPostTable();
        for (n = 0; n < this.cmapFormat.getRangeCount(); ++n) {
            CmapFormat.Range range = this.cmapFormat.getRange(n);
            for (int i = range.getStartCode(); i <= range.getEndCode(); ++i) {
                Object object2;
                int n5 = this.cmapFormat.mapCharCode(i);
                if (0 >= n5) continue;
                boolean bl = false;
                if (null != object && null != (object2 = ((PostTable)object).getGlyphName(n5)) && ((String)object2).length() > 0) {
                    SymAndID symAndID = new SymAndID((char)i, n5, (String)object2);
                    this.nameToGlyph.put((String)object2, symAndID);
                    this.idToGlyph.put(n5, symAndID);
                    this.cpToGlyph.put(i, symAndID);
                    bl = true;
                }
                if (bl) continue;
                object2 = new SymAndID((char)i, n5, "");
                this.idToGlyph.put(n5, object2);
                this.cpToGlyph.put(i, object2);
            }
        }
        if (DEBUG) {
            System.err.println("Selected CmapFormat: platform " + n2 + ", encoding " + n3 + ": " + this.cmapFormat.getClass().getSimpleName());
            System.err.println("Map Result");
            System.err.println("Map: idToGlyph: " + this.idToGlyph.size());
            System.err.println("Map: nameToGlyph: " + this.nameToGlyph.size());
            System.err.println("CMap entries: " + this.cmapentries);
            System.err.println("Font glyph-count " + this.getGlyphCount() + ", num-glyphs " + this.font.getNumGlyphs());
        }
        this.metrics = new TypecastHMetrics(this);
        this.getGlyphImpl(UNDEF_VALUE);
        if (DEBUG) {
            System.err.println("font direction hint: " + this.font.getHeadTable().getFontDirectionHint());
            for (n4 = 0; n4 < this.cmapFormat.getRangeCount(); ++n4) {
                object = this.cmapFormat.getRange(n4);
                for (n = ((CmapFormat.Range)object).getStartCode(); n <= ((CmapFormat.Range)object).getEndCode(); ++n) {
                    int n6 = this.cmapFormat.mapCharCode(n);
                    if (n6 > 36) continue;
                    System.err.println(" char: " + n + " ( " + (char)n + " ) -> " + n6);
                }
            }
            HmtxTable hmtxTable = this.font.getHmtxTable();
            object = this.font.getHheaTable();
            GlyfTable glyfTable = this.font.getGlyfTable();
            for (int i = 0; i <= 36; ++i) {
                Glyph glyph = this.font.getGlyph(i);
                Font.Glyph glyph2 = this.getGlyph(i);
                GlyfDescript glyfDescript = glyfTable.getDescription(i);
                System.err.println("Index " + i);
                System.err.println("  hmtx aw " + hmtxTable.getAdvanceWidth(i) + ", lsb " + hmtxTable.getLeftSideBearing(i));
                System.err.println("  hhea aw-max " + ((HheaTable)object).getAdvanceWidthMax() + ", x-max " + ((HheaTable)object).getXMaxExtent());
                if (null != glyfDescript) {
                    System.err.println("  gdesc idx " + glyfDescript.getGlyphIndex() + ", isComp " + glyfDescript.isComposite() + ", contours " + glyfDescript.getContourCount() + ", points " + glyfDescript.getPointCount());
                } else {
                    System.err.println("  gdesc null");
                }
                if (null != glyph) {
                    System.err.println("  tc_glyph " + glyph);
                } else {
                    System.err.println("  tc_glyph null");
                }
                System.err.println("  glyph " + glyph2);
            }
            System.err.println(this.fullString());
        }
    }

    @Override
    public String getName(int n) {
        return this.font.getName(n);
    }

    @Override
    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        return this.font.getAllNames(stringBuilder, string);
    }

    @Override
    public String getFullFamilyName() {
        return this.getName(1) + "-" + this.getName(2);
    }

    @Override
    public float getAdvanceWidth(int n) {
        return this.metrics.getScale(this.font.getHmtxTable().getAdvanceWidth(n));
    }

    @Override
    public int getAdvanceWidthFU(int n) {
        return this.font.getHmtxTable().getAdvanceWidth(n);
    }

    @Override
    public final Font.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public int getGlyphCount() {
        return this.font.getGlyphCount();
    }

    @Override
    public int getDefinedCount(CharSequence charSequence) {
        int n = 0;
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (this.getGlyph(charSequence.charAt(i)).isUndefined()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public char getGlyphCodepoint(String string) {
        SymAndID symAndID = this.nameToGlyph.get(string);
        if (null != symAndID) {
            return symAndID.codepoint;
        }
        return TypecastFont.UNDEF_VALUE.codepoint;
    }

    @Override
    public String getUTF16String(String string) {
        return Font.getUTF16String(this.getGlyphCodepoint(string));
    }

    @Override
    public int getGlyphID(char c) {
        SymAndID symAndID = (SymAndID)this.cpToGlyph.get(c);
        if (null != symAndID) {
            return symAndID.id;
        }
        return TypecastFont.UNDEF_VALUE.id;
    }

    PostTable getPostTable() {
        return this.font.getPostTable();
    }

    @Override
    public synchronized Font.Glyph getGlyph(String string) {
        SymAndID symAndID = this.nameToGlyph.get(string);
        if (null != symAndID) {
            return this.getGlyphImpl(symAndID);
        }
        return TypecastFont.UNDEF_VALUE.glyph;
    }

    @Override
    public synchronized Font.Glyph getGlyph(char c) {
        SymAndID symAndID = (SymAndID)this.cpToGlyph.get(c);
        if (null != symAndID) {
            return this.getGlyphImpl(symAndID);
        }
        return TypecastFont.UNDEF_VALUE.glyph;
    }

    @Override
    public synchronized Font.Glyph getGlyph(int n) {
        SymAndID symAndID = (SymAndID)this.idToGlyph.get(n);
        if (null != symAndID) {
            return this.getGlyphImpl(symAndID);
        }
        return TypecastFont.UNDEF_VALUE.glyph;
    }

    @Override
    public void forAllCodepoints(Font.CodepointIDVisitor codepointIDVisitor) {
        for (int i = 0; i < this.cmapFormat.getRangeCount(); ++i) {
            CmapFormat.Range range = this.cmapFormat.getRange(i);
            for (int j = range.getStartCode(); j <= range.getEndCode(); ++j) {
                codepointIDVisitor.visit((char)j, this.getGlyphID((char)j));
            }
        }
    }

    @Override
    public void forAllGlyphs(Font.GlyphVisitor2 glyphVisitor2) {
        for (int i = 0; i < this.cmapFormat.getRangeCount(); ++i) {
            CmapFormat.Range range = this.cmapFormat.getRange(i);
            for (int j = range.getStartCode(); j <= range.getEndCode(); ++j) {
                glyphVisitor2.visit(this.getGlyph((char)j));
            }
        }
    }

    private Font.Glyph getGlyphImpl(SymAndID symAndID) {
        int n;
        OutlineShape outlineShape;
        AABBox aABBox;
        boolean bl;
        Object object;
        Object object2;
        short s;
        int n2;
        boolean bl2;
        if (null != symAndID.glyph) {
            return symAndID.glyph;
        }
        Glyph glyph = this.font.getGlyph(symAndID.id);
        boolean bl3 = bl2 = 0 == symAndID.id || TypecastGlyph.isUndefName(symAndID.name);
        if (null != glyph) {
            n2 = glyph.getAdvanceWidth();
            s = glyph.getLeftSideBearing();
            object2 = glyph.getBBox();
            object = TypecastRenderer.buildShape(this.metrics.getUnitsPerEM(), glyph);
            if (0 < ((OutlineShape)object).getVertexCount()) {
                bl = bl2 ? false : ((OutlineShape)object).getBounds().hasZero2DArea();
                aABBox = object2;
                outlineShape = !bl && !bl2 || 0 == symAndID.id ? object : null;
                n = 1;
            } else {
                bl = !bl2;
                aABBox = new AABBox(0.0f, 0.0f, 0.0f, n2, 0.0f, 0.0f);
                outlineShape = 0 == symAndID.id ? TypecastRenderer.buildEmptyShape(this.metrics.getUnitsPerEM(), aABBox) : null;
                n = 2;
            }
        } else {
            n2 = this.getAdvanceWidthFU(symAndID.id);
            s = 0;
            bl = !bl2;
            aABBox = new AABBox(0.0f, 0.0f, 0.0f, n2, 0.0f, 0.0f);
            outlineShape = 0 == symAndID.id ? TypecastRenderer.buildEmptyShape(this.metrics.getUnitsPerEM(), aABBox) : null;
            n = 3;
        }
        object2 = null;
        object = this.font.getKernTable();
        if (object != null) {
            object2 = ((KernTable)object).getSubtable0();
        }
        object = new TypecastGlyph(this, symAndID.codepoint, symAndID.id, symAndID.name, aABBox, n2, s, (KernSubtable)object2, outlineShape, bl2, bl);
        if (DEBUG || TypecastRenderer.DEBUG) {
            System.err.println("New glyph: id 0x" + Integer.toHexString(symAndID.id) + "/'" + symAndID.name + "', sym 0x" + Integer.toHexString(symAndID.codepoint) + ", shape " + (null != outlineShape) + ", mode " + n);
            System.err.println("  tc_glyph " + glyph);
            System.err.println("     glyph " + object);
        }
        if (null != glyph) {
            glyph.clearPointData();
        }
        symAndID.glyph = object;
        return object;
    }

    @Override
    public float getLineHeight() {
        return this.metrics.getScale(this.getLineHeightFU());
    }

    @Override
    public int getLineHeightFU() {
        Font.Metrics metrics = this.getMetrics();
        return metrics.getAscentFU() - metrics.getDescentFU() + metrics.getLineGapFU();
    }

    @Override
    public AABBox getMetricBounds(CharSequence charSequence) {
        return this.getMetricBoundsFU(charSequence).scale2(1.0f / (float)this.metrics.getUnitsPerEM());
    }

    @Override
    public AABBox getMetricBoundsFU(CharSequence charSequence) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        AABBox aABBox = new AABBox();
        int n = charSequence.length();
        int n2 = this.getLineHeightFU();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                n4 = 0;
                n3 -= n2;
            } else {
                n4 += this.getAdvanceWidthFU(this.getGlyphID(c));
            }
            aABBox.resize(n4, n3, 0.0f);
        }
        if (0 < n4) {
            aABBox.resize(n4, n3 -= n2, 0.0f);
        }
        return aABBox;
    }

    @Override
    public AABBox getGlyphBounds(CharSequence charSequence) {
        return this.getGlyphBounds(charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox getGlyphBounds(CharSequence charSequence, AffineTransform affineTransform, AffineTransform affineTransform2) {
        return this.getGlyphBoundsFU(charSequence, affineTransform, affineTransform2).scale2(1.0f / (float)this.metrics.getUnitsPerEM());
    }

    @Override
    public AABBox getGlyphBoundsFU(CharSequence charSequence) {
        return this.getGlyphBoundsFU(charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox getGlyphBoundsFU(CharSequence charSequence, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        AABBox aABBox = new AABBox();
        int n = charSequence.length();
        int n2 = this.getLineHeightFU();
        int n3 = 0;
        int n4 = 0;
        Font.Glyph glyph = null;
        AABBox aABBox2 = new AABBox();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) {
                n3 -= n2;
                n4 = 0;
                glyph = null;
                continue;
            }
            affineTransform.setToIdentity();
            Font.Glyph glyph2 = this.getGlyph(c);
            if (glyph2.isUndefined()) {
                n4 += glyph2.getAdvanceWidthFU();
                glyph = null;
                continue;
            }
            if (glyph2.isWhitespace()) {
                glyph = null;
                affineTransform.translate(n4, n3, affineTransform2);
                aABBox.resize(affineTransform.transform(glyph2.getBoundsFU(), aABBox2));
                n4 += glyph2.getAdvanceWidthFU();
                continue;
            }
            if (null != glyph) {
                n4 += glyph.getKerningFU(glyph2.getID());
            }
            affineTransform.translate(n4, n3, affineTransform2);
            aABBox.resize(affineTransform.transform(glyph2.getBoundsFU(), aABBox2));
            n4 += glyph2.getAdvanceWidthFU();
            glyph = glyph2;
        }
        return aABBox;
    }

    @Override
    public AABBox getGlyphShapeBounds(AffineTransform affineTransform, CharSequence charSequence) {
        return this.getGlyphShapeBounds(affineTransform, charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox getGlyphShapeBounds(AffineTransform affineTransform, CharSequence charSequence, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

            @Override
            public final void visit(Font.Glyph glyph, AffineTransform affineTransform) {
            }
        };
        return this.processString(glyphVisitor, affineTransform, charSequence, affineTransform2, affineTransform3);
    }

    @Override
    public AABBox processString(Font.GlyphVisitor glyphVisitor, AffineTransform affineTransform, CharSequence charSequence) {
        return this.processString(glyphVisitor, affineTransform, charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox processString(Font.GlyphVisitor glyphVisitor, AffineTransform affineTransform, CharSequence charSequence, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        AABBox aABBox = new AABBox();
        int n = charSequence.length();
        float f = this.getLineHeight();
        float f2 = 0.0f;
        float f3 = 0.0f;
        Font.Glyph glyph = null;
        AABBox aABBox2 = new AABBox();
        AABBox aABBox3 = new AABBox();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) {
                f2 -= f;
                f3 = 0.0f;
                glyph = null;
                continue;
            }
            if (null != affineTransform) {
                affineTransform2.setTransform(affineTransform);
            } else {
                affineTransform2.setToIdentity();
            }
            Font.Glyph glyph2 = this.getGlyph(c);
            if (glyph2.isUndefined()) {
                f3 += glyph2.getAdvanceWidth();
                glyph = null;
                continue;
            }
            if (glyph2.isWhitespace()) {
                glyph = null;
                affineTransform2.translate(f3, f2, affineTransform3);
                aABBox.resize(affineTransform2.transform(glyph2.getBounds(aABBox3), aABBox2));
                glyphVisitor.visit(glyph2, affineTransform2);
                f3 += glyph2.getAdvanceWidth();
                continue;
            }
            if (null != glyph) {
                f3 += glyph.getKerning(glyph2.getID());
            }
            affineTransform2.translate(f3, f2, affineTransform3);
            aABBox.resize(affineTransform2.transform(glyph2.getShape().getBounds(), aABBox2));
            glyphVisitor.visit(glyph2, affineTransform2);
            f3 += glyph2.getAdvanceWidth();
            glyph = glyph2;
        }
        return aABBox;
    }

    @Override
    public void processString(Font.GlyphVisitor2 glyphVisitor2, CharSequence charSequence) {
        if (null == charSequence || 0 == charSequence.length()) {
            return;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) continue;
            glyphVisitor2.visit(this.getGlyph(c));
        }
    }

    @Override
    public boolean isPrintableChar(char c) {
        return FontFactory.isPrintableChar(c);
    }

    @Override
    public final int hashCode() {
        return this.font.getName(3).hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TypecastFont) {
            return ((TypecastFont)object).font.getName(3).equals(this.font.getName(3));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getFullFamilyName();
    }

    @Override
    public String fullString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString()).append("[ ").append(this.font.toString());
        stringBuilder.append("\n").append(this.font.getHeadTable());
        stringBuilder.append("\n\n").append(this.font.getHheaTable());
        if (null != this.font.getVheaTable()) {
            stringBuilder.append("\n\n").append(this.font.getVheaTable());
        }
        stringBuilder.append("\n\n").append(this.font.getCmapTable());
        stringBuilder.append("\n").append(this.font.getMaxpTable());
        stringBuilder.append("\n\n").append(this.font.getOS2Table());
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    static class SymAndID {
        public final char codepoint;
        public final int id;
        public final String name;
        public TypecastGlyph glyph;

        SymAndID(char c, int n, String string) {
            this.codepoint = c;
            this.id = n;
            this.name = string;
            this.glyph = null;
        }
    }
}

