/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class CLKernel
extends CLObjectResource
implements Cloneable {
    public final String name;
    public final int numArgs;
    private final CLProgram program;
    private final CL binding;
    private final ByteBuffer buffer;
    private int argIndex;
    private boolean force32BitArgs;

    CLKernel(CLProgram cLProgram, long l) {
        this(cLProgram, null, l);
    }

    CLKernel(CLProgram cLProgram, String string, long l) {
        super(cLProgram.getContext(), l);
        this.program = cLProgram;
        this.buffer = Buffers.newDirectByteBuffer((Platform.is32Bit() ? 4 : 8) * 3);
        this.binding = cLProgram.getPlatform().getCLBinding();
        if (string == null) {
            PointerBuffer pointerBuffer = PointerBuffer.wrap(this.buffer);
            int n = this.binding.clGetKernelInfo(this.ID, 4496, 0L, null, pointerBuffer);
            CLException.checkForError(n, "error while asking for kernel function name");
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)pointerBuffer.get(0));
            n = this.binding.clGetKernelInfo(this.ID, 4496, byteBuffer.capacity(), byteBuffer, null);
            CLException.checkForError(n, "error while asking for kernel function name");
            this.name = CLUtil.clString2JavaString(byteBuffer, byteBuffer.capacity());
        } else {
            this.name = string;
        }
        int n = this.binding.clGetKernelInfo(this.ID, 4497, this.buffer.capacity(), this.buffer, null);
        CLException.checkForError(n, "error while asking for number of function arguments.");
        this.numArgs = this.buffer.getInt(0);
    }

    public CLKernel putArg(CLMemory<?> cLMemory) {
        this.setArg(this.argIndex, cLMemory);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(short s) {
        this.setArg(this.argIndex, s);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(int n) {
        this.setArg(this.argIndex, n);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(long l) {
        this.setArg(this.argIndex, l);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(float f) {
        this.setArg(this.argIndex, f);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(double d) {
        this.setArg(this.argIndex, d);
        ++this.argIndex;
        return this;
    }

    public CLKernel putNullArg(int n) {
        this.setNullArg(this.argIndex, n);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArgs(CLMemory<?> ... cLMemoryArray) {
        this.setArgs(this.argIndex, cLMemoryArray);
        this.argIndex += cLMemoryArray.length;
        return this;
    }

    public CLKernel rewind() {
        this.argIndex = 0;
        return this;
    }

    public int position() {
        return this.argIndex;
    }

    public CLKernel setArg(int n, CLMemory<?> cLMemory) {
        this.setArgument(n, Platform.is32Bit() ? 4 : 8, this.wrap(cLMemory.ID));
        return this;
    }

    public CLKernel setArg(int n, short s) {
        this.setArgument(n, 2, this.wrap(s));
        return this;
    }

    public CLKernel setArg(int n, int n2) {
        this.setArgument(n, 4, this.wrap(n2));
        return this;
    }

    public CLKernel setArg(int n, long l) {
        if (this.force32BitArgs) {
            this.setArgument(n, 4, this.wrap((int)l));
        } else {
            this.setArgument(n, 8, this.wrap(l));
        }
        return this;
    }

    public CLKernel setArg(int n, float f) {
        this.setArgument(n, 4, this.wrap(f));
        return this;
    }

    public CLKernel setArg(int n, double d) {
        if (this.force32BitArgs) {
            this.setArgument(n, 4, this.wrap((float)d));
        } else {
            this.setArgument(n, 8, this.wrap(d));
        }
        return this;
    }

    public CLKernel setNullArg(int n, int n2) {
        this.setArgument(n, n2, null);
        return this;
    }

    public CLKernel setArgs(CLMemory<?> ... cLMemoryArray) {
        this.setArgs(0, cLMemoryArray);
        return this;
    }

    public CLKernel setArgs(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("values array was empty or null.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof CLMemory) {
                this.setArg(i, (CLMemory)object);
                continue;
            }
            if (object instanceof Short) {
                this.setArg(i, (Short)object);
                continue;
            }
            if (object instanceof Integer) {
                this.setArg(i, (Integer)object);
                continue;
            }
            if (object instanceof Long) {
                this.setArg(i, (Long)object);
                continue;
            }
            if (object instanceof Float) {
                this.setArg(i, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Double) {
                this.setArg(i, (Double)object);
                continue;
            }
            throw new IllegalArgumentException(object + " is not a valid argument.");
        }
        return this;
    }

    private void setArgs(int n, CLMemory<?> ... cLMemoryArray) {
        for (int i = 0; i < cLMemoryArray.length; ++i) {
            this.setArg(i + n, cLMemoryArray[i]);
        }
    }

    private void setArgument(int n, int n2, Buffer buffer) {
        if (n >= this.numArgs || n < 0) {
            throw new IndexOutOfBoundsException("kernel " + this + " has " + this.numArgs + " arguments, can not set argument with index " + n);
        }
        if (!this.program.isExecutable()) {
            throw new IllegalStateException("can not set program arguments for a not executable program. " + this.program);
        }
        int n3 = this.binding.clSetKernelArg(this.ID, n, n2, buffer);
        if (n3 != 0) {
            throw CLException.newException(n3, "error setting arg " + n + " to value " + buffer + " of size " + n2 + " of " + this);
        }
    }

    public CLKernel setForce32BitArgs(boolean bl) {
        this.force32BitArgs = bl;
        return this;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public boolean isForce32BitArgsEnabled() {
        return this.force32BitArgs;
    }

    private Buffer wrap(float f) {
        return this.buffer.putFloat(0, f);
    }

    private Buffer wrap(double d) {
        return this.buffer.putDouble(0, d);
    }

    private Buffer wrap(short s) {
        return this.buffer.putShort(0, s);
    }

    private Buffer wrap(int n) {
        return this.buffer.putInt(0, n);
    }

    private Buffer wrap(long l) {
        return this.buffer.putLong(0, l);
    }

    public long getLocalMemorySize(CLDevice cLDevice) {
        return this.getWorkGroupInfo(cLDevice, 4530);
    }

    public long getWorkGroupSize(CLDevice cLDevice) {
        return this.getWorkGroupInfo(cLDevice, 4528);
    }

    public long[] getCompileWorkGroupSize(CLDevice cLDevice) {
        int n = this.binding.clGetKernelWorkGroupInfo(this.ID, cLDevice.ID, 4529, (Platform.is32Bit() ? 4 : 8) * 3, this.buffer, null);
        if (n != 0) {
            throw CLException.newException(n, "error while asking for CL_KERNEL_COMPILE_WORK_GROUP_SIZE of " + this + " on " + cLDevice);
        }
        if (Platform.is32Bit()) {
            return new long[]{this.buffer.getInt(0), this.buffer.getInt(4), this.buffer.getInt(8)};
        }
        return new long[]{this.buffer.getLong(0), this.buffer.getLong(8), this.buffer.getLong(16)};
    }

    public long getPreferredWorkGroupSizeMultiple(CLDevice cLDevice) {
        return this.getWorkGroupInfo(cLDevice, 4531);
    }

    public long getPrivateMemSize(CLDevice cLDevice) {
        return this.getWorkGroupInfo(cLDevice, 4532);
    }

    private long getWorkGroupInfo(CLDevice cLDevice, int n) {
        int n2 = this.binding.clGetKernelWorkGroupInfo(this.ID, cLDevice.ID, n, 8L, this.buffer, null);
        if (n2 != 0) {
            throw CLException.newException(n2, "error while asking for clGetKernelWorkGroupInfo of " + this + " on " + cLDevice);
        }
        return this.buffer.getLong(0);
    }

    @Override
    public void release() {
        super.release();
        int n = this.binding.clReleaseKernel(this.ID);
        this.program.onKernelReleased(this);
        if (n != 0) {
            throw CLException.newException(n, "can not release " + this);
        }
    }

    @Override
    public String toString() {
        return "CLKernel [id: " + this.ID + " name: " + this.name + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLKernel cLKernel = (CLKernel)object;
        if (this.ID != cLKernel.ID) {
            return false;
        }
        return this.program.equals(cLKernel.program);
    }

    public int hashCode() {
        int n = 7;
        n = 43 * n + (int)(this.ID ^ this.ID >>> 32);
        n = 43 * n + (this.program != null ? this.program.hashCode() : 0);
        return n;
    }

    public CLKernel clone() {
        return this.program.createCLKernel(this.name).setForce32BitArgs(this.force32BitArgs);
    }
}

