/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.J3dClock;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Transform3D;

public class SensorRead {
    public static final int MAXIMUM_SENSOR_BUTTON_COUNT = 12;
    long time;
    Transform3D read = new Transform3D();
    int[] buttonValues;
    int numButtons;

    public SensorRead() {
        this(0);
    }

    public SensorRead(int numButtons) {
        this.numButtons = numButtons;
        this.buttonValues = new int[numButtons];
        this.time = J3dClock.currentTimeMillis();
    }

    final void set(SensorRead sensorRead) {
        this.time = sensorRead.time;
        this.numButtons = sensorRead.numButtons;
        this.read.set(sensorRead.read);
        if (this.numButtons > 0) {
            System.arraycopy(sensorRead.buttonValues, 0, this.buttonValues, 0, sensorRead.numButtons);
        }
    }

    public void set(Transform3D t1) {
        this.read.set(t1);
    }

    public void get(Transform3D result) {
        result.set(this.read);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setButtons(int[] values) {
        if (this.numButtons == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SensorRead1"));
        }
        if (values.length < this.numButtons) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SensorRead0"));
        }
        System.arraycopy(values, 0, this.buttonValues, 0, this.numButtons);
    }

    public void getButtons(int[] values) {
        if (this.numButtons > 0) {
            System.arraycopy(this.buttonValues, 0, values, 0, this.numButtons);
        }
    }

    public int getNumButtons() {
        return this.numButtons;
    }
}

