/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IndexedObject;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.VirtualUniverse;

abstract class SceneGraphObjectRetained
extends IndexedObject
implements Cloneable {
    SceneGraphObject source;
    boolean inBackgroundGroup = false;
    boolean onUpdateList = false;
    boolean inSetLive = false;
    static final int DONT_MERGE = 0;
    static final int MERGE = 1;
    static final int MERGE_DONE = 2;
    int mergeFlag = 0;

    SceneGraphObjectRetained() {
    }

    void setSource(SceneGraphObject source) {
        this.source = source;
    }

    SceneGraphObject getSource() {
        return this.source;
    }

    void markAsLive() {
        this.source.setLive();
        this.inSetLive = false;
    }

    void setLive(boolean inBackgroundGroup) {
        this.doSetLive(inBackgroundGroup);
        this.markAsLive();
    }

    boolean isInSetLive() {
        return this.inSetLive;
    }

    void doSetLive(boolean inBackgroundGroup) {
        this.inSetLive = true;
        this.inBackgroundGroup = inBackgroundGroup;
    }

    void setLive(SetLiveState s) {
        this.doSetLive(s);
        this.markAsLive();
    }

    void doSetLive(SetLiveState s) {
        this.inSetLive = true;
        this.inBackgroundGroup = s.inBackgroundGroup;
    }

    void clearLive(VirtualUniverse univ, int index, boolean sharedGroup, HashKey[] keys) {
        this.inBackgroundGroup = false;
        this.source.clearLive();
    }

    void clearLive() {
        this.inBackgroundGroup = false;
        this.source.clearLive();
    }

    void setCompiled() {
        this.source.setCompiled();
    }

    void compile(CompileState compState) {
        this.setCompiled();
    }

    void merge(CompileState compState) {
    }

    void mergeTransform(TransformGroupRetained xform) {
    }

    void traverse(boolean sameLevel, int level) {
        System.err.println();
        for (int i = 0; i < level; ++i) {
            System.err.print(".");
        }
        System.err.print(this.source.getName() + " ret:" + this.getClass().getSimpleName() + " source:" + this.source.getClass().getSimpleName());
    }

    boolean isStatic() {
        return this.source.capabilityBitsEmpty();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void handleFrequencyChange(int bit) {
    }

    @Override
    VirtualUniverse getVirtualUniverse() {
        return null;
    }
}

