/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.GeneralizedStrip;
import org.jogamp.java3d.GeneralizedStripFlags;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.LineStripArray;
import org.jogamp.java3d.PointArray;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

@Deprecated
class GeneralizedVertexList
implements GeneralizedStripFlags {
    private ArrayList<Vertex> vertices;
    private boolean hasColor3 = false;
    private boolean hasColor4 = false;
    private boolean hasNormals = false;
    private int frontFace;
    int stripCount;
    int vertexCount;
    int triangleCount;
    int vertexFormat;

    GeneralizedVertexList(int vertexFormat, int frontFace, int initSize) {
        this.frontFace = frontFace;
        this.setVertexFormat(vertexFormat);
        this.vertices = initSize == 0 ? new ArrayList() : new ArrayList(initSize);
        this.stripCount = 0;
        this.vertexCount = 0;
        this.triangleCount = 0;
    }

    GeneralizedVertexList(int vertexFormat, int frontFace) {
        this(vertexFormat, frontFace, 0);
    }

    void setVertexFormat(int vertexFormat) {
        this.vertexFormat = vertexFormat;
        if ((vertexFormat & 2) != 0) {
            this.hasNormals = true;
        }
        if ((vertexFormat & 4) != 0) {
            if ((vertexFormat & 8) != 0) {
                this.hasColor4 = true;
            } else {
                this.hasColor3 = true;
            }
        }
    }

    void addVertex(Point3f pos, Vector3f norm, Color4f color, int flag) {
        this.vertices.add(new Vertex(pos, norm, color, flag));
    }

    int size() {
        return this.vertices.size();
    }

    @Override
    public int getFlagCount() {
        return this.vertices.size();
    }

    @Override
    public int getFlag(int index) {
        return this.vertices.get((int)index).flag;
    }

    private void copyVertexData(GeometryArray ga, GeneralizedStrip.IntList indices) {
        Point3f[] p3f = new Point3f[indices.count];
        if (this.hasNormals) {
            Vector3f[] v3f = new Vector3f[indices.count];
            if (this.hasColor3) {
                Color3f[] c3f = new Color3f[indices.count];
                for (int i = 0; i < indices.count; ++i) {
                    Vertex v = this.vertices.get(indices.ints[i]);
                    p3f[i] = v.coord;
                    v3f[i] = v.normal;
                    c3f[i] = v.color3;
                }
                ga.setColors(0, c3f);
            } else if (this.hasColor4) {
                Color4f[] c4f = new Color4f[indices.count];
                for (int i = 0; i < indices.count; ++i) {
                    Vertex v = this.vertices.get(indices.ints[i]);
                    p3f[i] = v.coord;
                    v3f[i] = v.normal;
                    c4f[i] = v.color4;
                }
                ga.setColors(0, c4f);
            } else {
                for (int i = 0; i < indices.count; ++i) {
                    Vertex v = this.vertices.get(indices.ints[i]);
                    p3f[i] = v.coord;
                    v3f[i] = v.normal;
                }
            }
            ga.setNormals(0, v3f);
        } else if (this.hasColor3) {
            Color3f[] c3f = new Color3f[indices.count];
            for (int i = 0; i < indices.count; ++i) {
                Vertex v = this.vertices.get(indices.ints[i]);
                p3f[i] = v.coord;
                c3f[i] = v.color3;
            }
            ga.setColors(0, c3f);
        } else if (this.hasColor4) {
            Color4f[] c4f = new Color4f[indices.count];
            for (int i = 0; i < indices.count; ++i) {
                Vertex v = this.vertices.get(indices.ints[i]);
                p3f[i] = v.coord;
                c4f[i] = v.color4;
            }
            ga.setColors(0, c4f);
        } else {
            for (int i = 0; i < indices.count; ++i) {
                Vertex v = this.vertices.get(indices.ints[i]);
                p3f[i] = v.coord;
            }
        }
        ga.setCoordinates(0, p3f);
    }

    PointArray toPointArray() {
        int size = this.vertices.size();
        if (size > 0) {
            PointArray pa = new PointArray(size, this.vertexFormat);
            GeneralizedStrip.IntList il = new GeneralizedStrip.IntList(size);
            il.fillAscending();
            this.copyVertexData(pa, il);
            this.vertexCount += size;
            return pa;
        }
        return null;
    }

    TriangleArray toTriangleArray() {
        int[] vertices = GeneralizedStrip.toTriangles(this, this.frontFace);
        if (vertices != null) {
            TriangleArray ta = new TriangleArray(vertices.length, this.vertexFormat);
            GeneralizedStrip.IntList il = new GeneralizedStrip.IntList(vertices);
            this.copyVertexData(ta, il);
            this.vertexCount += vertices.length;
            this.triangleCount += vertices.length / 3;
            return ta;
        }
        return null;
    }

    LineStripArray toLineStripArray() {
        GeneralizedStrip.StripArray stripArray = GeneralizedStrip.toLineStrips(this);
        if (stripArray != null) {
            LineStripArray lsa = new LineStripArray(stripArray.vertices.count, this.vertexFormat, stripArray.stripCounts.trim());
            this.copyVertexData(lsa, stripArray.vertices);
            this.vertexCount += stripArray.vertices.count;
            this.stripCount += stripArray.stripCounts.count;
            return lsa;
        }
        return null;
    }

    TriangleStripArray toTriangleStripArray() {
        GeneralizedStrip.StripArray stripArray = GeneralizedStrip.toTriangleStrips(this, this.frontFace);
        if (stripArray != null) {
            TriangleStripArray tsa = new TriangleStripArray(stripArray.vertices.count, this.vertexFormat, stripArray.stripCounts.trim());
            this.copyVertexData(tsa, stripArray.vertices);
            this.vertexCount += stripArray.vertices.count;
            this.stripCount += stripArray.stripCounts.count;
            return tsa;
        }
        return null;
    }

    GeometryStripArray[] toStripAndFanArrays() {
        GeneralizedStrip.StripArray[] stripArray = GeneralizedStrip.toStripsAndFans(this, this.frontFace);
        GeometryStripArray[] gsa = new GeometryStripArray[2];
        if (stripArray[0] != null) {
            gsa[0] = new TriangleStripArray(stripArray[0].vertices.count, this.vertexFormat, stripArray[0].stripCounts.trim());
            this.copyVertexData(gsa[0], stripArray[0].vertices);
            this.vertexCount += stripArray[0].vertices.count;
            this.stripCount += stripArray[0].stripCounts.count;
        }
        if (stripArray[1] != null) {
            gsa[1] = new TriangleFanArray(stripArray[1].vertices.count, this.vertexFormat, stripArray[1].stripCounts.trim());
            this.copyVertexData(gsa[1], stripArray[1].vertices);
            this.vertexCount += stripArray[1].vertices.count;
            this.stripCount += stripArray[1].stripCounts.count;
        }
        return gsa;
    }

    GeometryArray[] toStripAndTriangleArrays() {
        GeneralizedStrip.StripArray[] stripArray = GeneralizedStrip.toStripsAndTriangles(this, this.frontFace, 4, 12);
        GeometryArray[] ga = new GeometryArray[2];
        if (stripArray[0] != null) {
            ga[0] = new TriangleStripArray(stripArray[0].vertices.count, this.vertexFormat, stripArray[0].stripCounts.trim());
            this.copyVertexData(ga[0], stripArray[0].vertices);
            this.vertexCount += stripArray[0].vertices.count;
            this.stripCount += stripArray[0].stripCounts.count;
        }
        if (stripArray[1] != null) {
            ga[1] = new TriangleArray(stripArray[1].vertices.count, this.vertexFormat);
            this.copyVertexData(ga[1], stripArray[1].vertices);
            this.triangleCount += stripArray[1].vertices.count / 3;
        }
        return ga;
    }

    class Vertex {
        int flag;
        Point3f coord;
        Color3f color3;
        Color4f color4;
        Vector3f normal;

        Vertex(Point3f p, Vector3f n, Color4f c, int flag) {
            this.flag = flag;
            this.coord = new Point3f(p);
            if (GeneralizedVertexList.this.hasNormals) {
                this.normal = new Vector3f(n);
            }
            if (GeneralizedVertexList.this.hasColor3) {
                this.color3 = new Color3f(c.x, c.y, c.z);
            } else if (GeneralizedVertexList.this.hasColor4) {
                this.color4 = new Color4f(c);
            }
        }
    }
}

