/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.util.ArrayDeque;
import java.util.Iterator;

public final class PDeque
extends PythonBuiltinObject {
    final ArrayDeque<Object> data = PDeque.createArrayDeque();
    private int maxLength = -1;
    private int state;

    public PDeque(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    @CompilerDirectives.TruffleBoundary
    private static ArrayDeque<Object> createArrayDeque() {
        return new ArrayDeque<Object>();
    }

    int getSize() {
        return this.data.size();
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @CompilerDirectives.TruffleBoundary
    void append(Object value) {
        assert (this.maxLength == -1 || this.data.size() <= this.maxLength);
        this.data.addLast(value);
        if (this.maxLength != -1 && this.data.size() > this.maxLength) {
            this.popLeft();
        } else {
            ++this.state;
        }
        assert (this.maxLength == -1 || this.data.size() <= this.maxLength);
    }

    @CompilerDirectives.TruffleBoundary
    void appendLeft(Object value) {
        assert (this.maxLength == -1 || this.data.size() <= this.maxLength);
        this.data.addFirst(value);
        if (this.maxLength != -1 && this.data.size() > this.maxLength) {
            this.pop();
        } else {
            ++this.state;
        }
        assert (this.maxLength == -1 || this.data.size() <= this.maxLength);
    }

    @CompilerDirectives.TruffleBoundary
    Object pop() {
        ++this.state;
        return this.data.pollLast();
    }

    @CompilerDirectives.TruffleBoundary
    Object popLeft() {
        ++this.state;
        return this.data.pollFirst();
    }

    @CompilerDirectives.TruffleBoundary
    Object peekLeft() {
        return this.data.peekFirst();
    }

    @CompilerDirectives.TruffleBoundary
    void addAll(Object[] c) {
        for (Object e : c) {
            this.append(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    void addAll(PDeque other) {
        for (Object e : other.data) {
            this.append(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Iterator<Object> iterator() {
        return this.data.iterator();
    }

    @CompilerDirectives.TruffleBoundary
    public Iterator<Object> reverseIterator() {
        return this.data.descendingIterator();
    }

    @CompilerDirectives.TruffleBoundary
    public void clear() {
        this.data.clear();
        ++this.state;
    }

    @CompilerDirectives.TruffleBoundary
    public void setItem(int idx, Object value) {
        int i;
        assert (0 <= idx && idx < this.data.size());
        int n = this.data.size() - idx - 1;
        Object[] savedItems = new Object[n];
        for (i = 0; i < savedItems.length; ++i) {
            savedItems[i] = this.data.pollLast();
        }
        this.data.pollLast();
        assert (this.data.size() == idx);
        if (value != null) {
            this.data.addLast(value);
        } else {
            ++this.state;
        }
        for (i = savedItems.length - 1; i >= 0; --i) {
            this.data.addLast(savedItems[i]);
        }
        assert (this.maxLength == -1 || this.data.size() <= this.maxLength);
        assert (value != null && this.data.size() == n + idx + 1 || value == null && this.data.size() == n + idx);
    }

    public int getState() {
        return this.state;
    }
}

