/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.UnivariateSwitchingFunction;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math3.util.FastMath;

public class SquaredTrigSwitch
implements UnivariateSwitchingFunction {
    private static final double PI_OVER_TWO = 1.5707963267948966;
    private final double multiplier;
    private final double halfPeriod;
    private final DoubleUnaryOperator xTransform;
    private final boolean cosine;

    public SquaredTrigSwitch(boolean cosine) {
        this(1.5707963267948966, cosine);
    }

    public SquaredTrigSwitch(double coefficient, boolean cosine) {
        this.multiplier = coefficient;
        this.halfPeriod = 1.5707963267948966 / this.multiplier;
        this.xTransform = cosine ? this::cosineTransform : this::sineTransform;
        this.cosine = cosine;
    }

    @Override
    public boolean constantOutsideBounds() {
        return false;
    }

    @Override
    public double firstDerivative(double x) throws IllegalArgumentException {
        x = this.xTransform.applyAsDouble(x);
        return 2.0 * FastMath.sin((double)x) * FastMath.cos((double)x) * this.multiplier;
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return 1;
    }

    @Override
    public double getOneBound() {
        return this.cosine ? 0.0 : this.halfPeriod;
    }

    public double getPeriod() {
        return 2.0 * this.halfPeriod;
    }

    @Override
    public double getZeroBound() {
        return this.cosine ? this.halfPeriod : 0.0;
    }

    public boolean isCosine() {
        return this.cosine;
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        if (order < 1) {
            throw new IllegalArgumentException("Order must be >= 1");
        }
        x = this.xTransform.applyAsDouble(x);
        double sinVal = FastMath.sin((double)x);
        double cosVal = FastMath.cos((double)x);
        double multPow = FastMath.pow((double)this.multiplier, (int)order);
        return switch (order % 4) {
            case 0 -> FastMath.pow((double)2.0, (int)(order - 1)) * multPow * (sinVal * sinVal - cosVal * cosVal);
            case 1 -> FastMath.pow((double)2.0, (int)order) * multPow * sinVal * cosVal;
            case 2 -> FastMath.pow((double)2.0, (int)(order - 1)) * multPow * (cosVal * cosVal - sinVal * sinVal);
            case 3 -> -1.0 * FastMath.pow((double)2.0, (int)order) * multPow * sinVal * cosVal;
            default -> throw new ArithmeticException("A positive number modulo 4 was not 0-3");
        };
    }

    @Override
    public double secondDerivative(double x) throws IllegalArgumentException {
        double val = 2.0 * this.multiplier * this.multiplier;
        x = this.xTransform.applyAsDouble(x);
        double cosTerm = FastMath.cos((double)x);
        double sinTerm = FastMath.sin((double)x);
        return val * (cosTerm * cosTerm - sinTerm * sinTerm);
    }

    @Override
    public boolean symmetricToUnity() {
        return true;
    }

    public String toString() {
        if (this.cosine) {
            return String.format("Cosine-squared switching function of form f(x) = cos^2(%8.4g * x)", this.multiplier);
        }
        return String.format("Sine-squared switching function of form f(x) = sin^2(%8.4g * x)", this.multiplier);
    }

    @Override
    public boolean validOutsideBounds() {
        return true;
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        x = this.xTransform.applyAsDouble(x);
        x = FastMath.sin((double)x);
        x *= x;
        return x;
    }

    private double sineTransform(double x) {
        return x * this.multiplier;
    }

    private double cosineTransform(double x) {
        return 1.5707963267948966 + x * this.multiplier;
    }
}

