/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.UnivariateSwitchingFunction;
import org.apache.commons.math3.util.FastMath;

public class PowerSwitch
implements UnivariateSwitchingFunction {
    private final double a;
    private final double beta;
    private final double ub;

    public PowerSwitch() {
        this(1.0, 1.0);
    }

    public PowerSwitch(double a, double beta) {
        if (a <= 0.0) {
            throw new IllegalArgumentException(" The constant a must be > 0");
        }
        if (beta == 0.0) {
            throw new IllegalArgumentException(" The exponent must be > 0 (preferably >= 1)");
        }
        this.a = a;
        this.beta = beta;
        this.ub = 1.0 / a;
    }

    @Override
    public boolean constantOutsideBounds() {
        return false;
    }

    @Override
    public double firstDerivative(double x) throws IllegalArgumentException {
        return this.beta * this.a * FastMath.pow((double)(x *= this.a), (double)(this.beta - 1.0));
    }

    public double getExponent() {
        return this.beta;
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return 0;
    }

    public double getMultiplier() {
        return this.a;
    }

    @Override
    public double getOneBound() {
        return this.ub;
    }

    @Override
    public double getZeroBound() {
        return 0.0;
    }

    @Override
    public int highestOrderZeroDerivativeAtZeroBound() {
        return this.beta >= 1.0 ? (int)this.beta - 1 : 0;
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        x *= this.a;
        if (order < 1) {
            throw new IllegalArgumentException("Order must be >= 1");
        }
        switch (order) {
            case 1: {
                return this.firstDerivative(x);
            }
            case 2: {
                return this.secondDerivative(x);
            }
        }
        double orderDiff = (double)order - this.beta;
        if (orderDiff % 1.0 == 0.0 && orderDiff >= 1.0) {
            return 0.0;
        }
        double val = FastMath.pow((double)x, (double)(this.beta - (double)order));
        for (int i = 0; i < order; ++i) {
            val *= (this.beta - (double)i) * this.a;
        }
        return val;
    }

    @Override
    public double secondDerivative(double x) throws IllegalArgumentException {
        return this.beta == 1.0 ? 0.0 : this.beta * (this.beta - 1.0) * this.a * this.a * FastMath.pow((double)(x *= this.a), (double)(this.beta - 2.0));
    }

    @Override
    public boolean symmetricToUnity() {
        return this.beta == 1.0;
    }

    public String toString() {
        return String.format("Power switching function f(x) = (%8.4g * x)^%8.4g", this.a, this.beta);
    }

    @Override
    public boolean validOutsideBounds() {
        return false;
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        return FastMath.pow((double)(x *= this.a), (double)this.beta);
    }
}

