/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.special;

import org.apache.commons.math3.util.FastMath;

public class Erf {
    private static final double sqrtPI = 1.0 / FastMath.sqrt((double)Math.PI);
    private static final double oneSixteenth = 0.0625;
    private static final double thresh = 0.46875;
    private static final double xSmall = 1.11E-16;
    private static final double xBig = 26.543;

    private Erf() {
    }

    public static double erf(double arg) {
        if (Double.isNaN(arg)) {
            return Double.NaN;
        }
        if (Double.isInfinite(arg)) {
            return arg > 0.0 ? 1.0 : -1.0;
        }
        return Erf.erfCore(arg, false);
    }

    public static double erfc(double arg) {
        if (Double.isNaN(arg)) {
            return Double.NaN;
        }
        if (Double.isInfinite(arg)) {
            return arg > 0.0 ? 0.0 : 2.0;
        }
        return Erf.erfCore(arg, true);
    }

    private static double erfCore(double x, boolean mode) {
        double y = FastMath.abs((double)x);
        double result = 0.0;
        if (y <= 0.46875) {
            double ysq = 0.0;
            if (y > 1.11E-16) {
                ysq = y * y;
            }
            double xNum = 0.18577770618460315 * ysq;
            double xDen = ysq;
            xNum = (xNum + 3.1611237438705655) * ysq;
            xDen = (xDen + 23.601290952344122) * ysq;
            xNum = (xNum + 113.86415415105016) * ysq;
            xDen = (xDen + 244.02463793444417) * ysq;
            xNum = (xNum + 377.485237685302) * ysq;
            xDen = (xDen + 1282.6165260773723) * ysq;
            result = x * (xNum + 3209.3775891384694) / (xDen + 2844.236833439171);
            if (mode) {
                result = 1.0 - result;
            }
        } else if (y <= 4.0) {
            double xNum = 2.1531153547440383E-8 * y;
            double xDen = y;
            xNum = (xNum + 0.5641884969886701) * y;
            xDen = (xDen + 15.744926110709835) * y;
            xNum = (xNum + 8.883149794388377) * y;
            xDen = (xDen + 117.6939508913125) * y;
            xNum = (xNum + 66.11919063714163) * y;
            xDen = (xDen + 537.1811018620099) * y;
            xNum = (xNum + 298.6351381974001) * y;
            xDen = (xDen + 1621.3895745666903) * y;
            xNum = (xNum + 881.952221241769) * y;
            xDen = (xDen + 3290.7992357334597) * y;
            xNum = (xNum + 1712.0476126340707) * y;
            xDen = (xDen + 4362.619090143247) * y;
            xNum = (xNum + 2051.0783778260716) * y;
            xDen = (xDen + 3439.3676741437216) * y;
            result = (xNum + 1230.3393547979972) / (xDen + 1230.3393548037495);
            double ysq = FastMath.floor((double)(16.0 * y)) * 0.0625;
            double del = (y - ysq) * (y + ysq);
            result = FastMath.exp((double)(-ysq * ysq - del)) * result;
            if (!mode) {
                result = 1.0 - result;
                if (x < 0.0) {
                    result = -result;
                }
            } else if (x < 0.0) {
                result = 2.0 - result;
            }
        } else {
            if (y < 26.543) {
                double iy = 1.0 / y;
                double ysq = iy * iy;
                double xNum = 0.016315387137302097 * ysq;
                double xDen = ysq;
                xNum = (xNum + 0.30532663496123236) * ysq;
                xDen = (xDen + 2.568520192289822) * ysq;
                xNum = (xNum + 0.36034489994980445) * ysq;
                xDen = (xDen + 1.8729528499234604) * ysq;
                xNum = (xNum + 0.12578172611122926) * ysq;
                xDen = (xDen + 0.5279051029514285) * ysq;
                xNum = (xNum + 0.016083785148742275) * ysq;
                xDen = (xDen + 0.06051834131244132) * ysq;
                result = ysq * (xNum + 6.587491615298378E-4) / (xDen + 0.0023352049762686918);
                result = (sqrtPI - result) * iy;
                ysq = FastMath.floor((double)(16.0 * y)) * 0.0625;
                double del = (y - ysq) * (y + ysq);
                result = FastMath.exp((double)(-ysq * ysq - del)) * result;
            }
            if (!mode) {
                result = 1.0 - result;
                if (x < 0.0) {
                    result = -result;
                }
            } else if (x < 0.0) {
                result = 2.0 - result;
            }
        }
        return result;
    }
}

