/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.math.ScalarMath;
import ffx.numerics.multipole.CoordinateSystem;
import ffx.numerics.multipole.MultipoleUtilities;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import org.apache.commons.math3.util.FastMath;

public abstract class MultipoleTensorSIMD {
    private static final Logger logger = Logger.getLogger(MultipoleTensorSIMD.class.getName());
    protected final int order;
    protected final int o1;
    protected final int il;
    protected final int im;
    protected final int in;
    protected final int size;
    protected Operator operator;
    protected final double[] coulombSource;
    protected final CoordinateSystem coordinates;
    protected DoubleVector R;
    protected DoubleVector r2;
    protected DoubleVector x;
    protected DoubleVector y;
    protected DoubleVector z;
    protected final DoubleVector[] work;
    protected DoubleVector R000;
    protected DoubleVector R100;
    protected DoubleVector R010;
    protected DoubleVector R001;
    protected DoubleVector R200;
    protected DoubleVector R020;
    protected DoubleVector R002;
    protected DoubleVector R110;
    protected DoubleVector R101;
    protected DoubleVector R011;
    protected DoubleVector R300;
    protected DoubleVector R030;
    protected DoubleVector R003;
    protected DoubleVector R210;
    protected DoubleVector R201;
    protected DoubleVector R120;
    protected DoubleVector R021;
    protected DoubleVector R102;
    protected DoubleVector R012;
    protected DoubleVector R111;
    protected DoubleVector R400;
    protected DoubleVector R040;
    protected DoubleVector R004;
    protected DoubleVector R310;
    protected DoubleVector R301;
    protected DoubleVector R130;
    protected DoubleVector R031;
    protected DoubleVector R103;
    protected DoubleVector R013;
    protected DoubleVector R220;
    protected DoubleVector R202;
    protected DoubleVector R022;
    protected DoubleVector R211;
    protected DoubleVector R121;
    protected DoubleVector R112;
    protected DoubleVector R500;
    protected DoubleVector R050;
    protected DoubleVector R005;
    protected DoubleVector R410;
    protected DoubleVector R401;
    protected DoubleVector R140;
    protected DoubleVector R041;
    protected DoubleVector R104;
    protected DoubleVector R014;
    protected DoubleVector R320;
    protected DoubleVector R302;
    protected DoubleVector R230;
    protected DoubleVector R032;
    protected DoubleVector R203;
    protected DoubleVector R023;
    protected DoubleVector R311;
    protected DoubleVector R131;
    protected DoubleVector R113;
    protected DoubleVector R221;
    protected DoubleVector R212;
    protected DoubleVector R122;
    protected DoubleVector R006;
    protected DoubleVector R402;
    protected DoubleVector R042;
    protected DoubleVector R204;
    protected DoubleVector R024;
    protected DoubleVector R222;
    protected DoubleVector R600;
    protected DoubleVector R060;
    protected DoubleVector R510;
    protected DoubleVector R501;
    protected DoubleVector R150;
    protected DoubleVector R051;
    protected DoubleVector R105;
    protected DoubleVector R015;
    protected DoubleVector R420;
    protected DoubleVector R240;
    protected DoubleVector R411;
    protected DoubleVector R141;
    protected DoubleVector R114;
    protected DoubleVector R330;
    protected DoubleVector R303;
    protected DoubleVector R033;
    protected DoubleVector R321;
    protected DoubleVector R231;
    protected DoubleVector R213;
    protected DoubleVector R312;
    protected DoubleVector R132;
    protected DoubleVector R123;
    protected DoubleVector E000;
    protected DoubleVector E100;
    protected DoubleVector E010;
    protected DoubleVector E001;
    protected DoubleVector E200;
    protected DoubleVector E020;
    protected DoubleVector E002;
    protected DoubleVector E110;
    protected DoubleVector E101;
    protected DoubleVector E011;
    protected DoubleVector E300;
    protected DoubleVector E030;
    protected DoubleVector E003;
    protected DoubleVector E210;
    protected DoubleVector E201;
    protected DoubleVector E120;
    protected DoubleVector E021;
    protected DoubleVector E102;
    protected DoubleVector E012;
    protected DoubleVector E111;
    protected final int t000;
    protected final int t100;
    protected final int t010;
    protected final int t001;
    protected final int t200;
    protected final int t020;
    protected final int t002;
    protected final int t110;
    protected final int t101;
    protected final int t011;
    protected final int t300;
    protected final int t030;
    protected final int t003;
    protected final int t210;
    protected final int t201;
    protected final int t120;
    protected final int t021;
    protected final int t102;
    protected final int t012;
    protected final int t111;
    protected final int t400;
    protected final int t040;
    protected final int t004;
    protected final int t310;
    protected final int t301;
    protected final int t130;
    protected final int t031;
    protected final int t103;
    protected final int t013;
    protected final int t220;
    protected final int t202;
    protected final int t022;
    protected final int t211;
    protected final int t121;
    protected final int t112;
    protected final int t500;
    protected final int t050;
    protected final int t005;
    protected final int t410;
    protected final int t401;
    protected final int t140;
    protected final int t041;
    protected final int t104;
    protected final int t014;
    protected final int t320;
    protected final int t302;
    protected final int t230;
    protected final int t032;
    protected final int t203;
    protected final int t023;
    protected final int t311;
    protected final int t131;
    protected final int t113;
    protected final int t221;
    protected final int t212;
    protected final int t122;
    protected final int t600;
    protected final int t060;
    protected final int t006;
    protected final int t510;
    protected final int t501;
    protected final int t150;
    protected final int t051;
    protected final int t105;
    protected final int t015;
    protected final int t420;
    protected final int t402;
    protected final int t240;
    protected final int t042;
    protected final int t204;
    protected final int t024;
    protected final int t411;
    protected final int t141;
    protected final int t114;
    protected final int t330;
    protected final int t303;
    protected final int t033;
    protected final int t321;
    protected final int t231;
    protected final int t213;
    protected final int t312;
    protected final int t132;
    protected final int t123;
    protected final int t222;

    public MultipoleTensorSIMD(CoordinateSystem coordinates, int order) {
        assert (order > 0);
        this.il = this.o1 = order + 1;
        this.im = this.il * this.o1;
        this.in = this.im * this.o1;
        this.size = (order + 1) * (order + 2) * (order + 3) / 6;
        this.order = order;
        this.coordinates = coordinates;
        this.operator = Operator.COULOMB;
        this.coulombSource = new double[this.o1];
        for (int n = 0; n <= order; n = (int)((short)(n + 1))) {
            this.coulombSource[n] = FastMath.pow((double)-1.0, (int)n) * (double)ScalarMath.doubleFactorial(2 * n - 1);
        }
        this.work = new DoubleVector[this.in * this.o1];
        this.t000 = MultipoleUtilities.ti(0, 0, 0, order);
        this.t100 = MultipoleUtilities.ti(1, 0, 0, order);
        this.t010 = MultipoleUtilities.ti(0, 1, 0, order);
        this.t001 = MultipoleUtilities.ti(0, 0, 1, order);
        this.t200 = MultipoleUtilities.ti(2, 0, 0, order);
        this.t020 = MultipoleUtilities.ti(0, 2, 0, order);
        this.t002 = MultipoleUtilities.ti(0, 0, 2, order);
        this.t110 = MultipoleUtilities.ti(1, 1, 0, order);
        this.t101 = MultipoleUtilities.ti(1, 0, 1, order);
        this.t011 = MultipoleUtilities.ti(0, 1, 1, order);
        this.t300 = MultipoleUtilities.ti(3, 0, 0, order);
        this.t030 = MultipoleUtilities.ti(0, 3, 0, order);
        this.t003 = MultipoleUtilities.ti(0, 0, 3, order);
        this.t210 = MultipoleUtilities.ti(2, 1, 0, order);
        this.t201 = MultipoleUtilities.ti(2, 0, 1, order);
        this.t120 = MultipoleUtilities.ti(1, 2, 0, order);
        this.t021 = MultipoleUtilities.ti(0, 2, 1, order);
        this.t102 = MultipoleUtilities.ti(1, 0, 2, order);
        this.t012 = MultipoleUtilities.ti(0, 1, 2, order);
        this.t111 = MultipoleUtilities.ti(1, 1, 1, order);
        this.t400 = MultipoleUtilities.ti(4, 0, 0, order);
        this.t040 = MultipoleUtilities.ti(0, 4, 0, order);
        this.t004 = MultipoleUtilities.ti(0, 0, 4, order);
        this.t310 = MultipoleUtilities.ti(3, 1, 0, order);
        this.t301 = MultipoleUtilities.ti(3, 0, 1, order);
        this.t130 = MultipoleUtilities.ti(1, 3, 0, order);
        this.t031 = MultipoleUtilities.ti(0, 3, 1, order);
        this.t103 = MultipoleUtilities.ti(1, 0, 3, order);
        this.t013 = MultipoleUtilities.ti(0, 1, 3, order);
        this.t220 = MultipoleUtilities.ti(2, 2, 0, order);
        this.t202 = MultipoleUtilities.ti(2, 0, 2, order);
        this.t022 = MultipoleUtilities.ti(0, 2, 2, order);
        this.t211 = MultipoleUtilities.ti(2, 1, 1, order);
        this.t121 = MultipoleUtilities.ti(1, 2, 1, order);
        this.t112 = MultipoleUtilities.ti(1, 1, 2, order);
        this.t500 = MultipoleUtilities.ti(5, 0, 0, order);
        this.t050 = MultipoleUtilities.ti(0, 5, 0, order);
        this.t005 = MultipoleUtilities.ti(0, 0, 5, order);
        this.t410 = MultipoleUtilities.ti(4, 1, 0, order);
        this.t401 = MultipoleUtilities.ti(4, 0, 1, order);
        this.t140 = MultipoleUtilities.ti(1, 4, 0, order);
        this.t041 = MultipoleUtilities.ti(0, 4, 1, order);
        this.t104 = MultipoleUtilities.ti(1, 0, 4, order);
        this.t014 = MultipoleUtilities.ti(0, 1, 4, order);
        this.t320 = MultipoleUtilities.ti(3, 2, 0, order);
        this.t302 = MultipoleUtilities.ti(3, 0, 2, order);
        this.t230 = MultipoleUtilities.ti(2, 3, 0, order);
        this.t032 = MultipoleUtilities.ti(0, 3, 2, order);
        this.t203 = MultipoleUtilities.ti(2, 0, 3, order);
        this.t023 = MultipoleUtilities.ti(0, 2, 3, order);
        this.t311 = MultipoleUtilities.ti(3, 1, 1, order);
        this.t131 = MultipoleUtilities.ti(1, 3, 1, order);
        this.t113 = MultipoleUtilities.ti(1, 1, 3, order);
        this.t221 = MultipoleUtilities.ti(2, 2, 1, order);
        this.t212 = MultipoleUtilities.ti(2, 1, 2, order);
        this.t122 = MultipoleUtilities.ti(1, 2, 2, order);
        this.t600 = MultipoleUtilities.ti(6, 0, 0, order);
        this.t060 = MultipoleUtilities.ti(0, 6, 0, order);
        this.t006 = MultipoleUtilities.ti(0, 0, 6, order);
        this.t510 = MultipoleUtilities.ti(5, 1, 0, order);
        this.t501 = MultipoleUtilities.ti(5, 0, 1, order);
        this.t150 = MultipoleUtilities.ti(1, 5, 0, order);
        this.t051 = MultipoleUtilities.ti(0, 5, 1, order);
        this.t105 = MultipoleUtilities.ti(1, 0, 5, order);
        this.t015 = MultipoleUtilities.ti(0, 1, 5, order);
        this.t420 = MultipoleUtilities.ti(4, 2, 0, order);
        this.t402 = MultipoleUtilities.ti(4, 0, 2, order);
        this.t240 = MultipoleUtilities.ti(2, 4, 0, order);
        this.t042 = MultipoleUtilities.ti(0, 4, 2, order);
        this.t204 = MultipoleUtilities.ti(2, 0, 4, order);
        this.t024 = MultipoleUtilities.ti(0, 2, 4, order);
        this.t411 = MultipoleUtilities.ti(4, 1, 1, order);
        this.t141 = MultipoleUtilities.ti(1, 4, 1, order);
        this.t114 = MultipoleUtilities.ti(1, 1, 4, order);
        this.t330 = MultipoleUtilities.ti(3, 3, 0, order);
        this.t303 = MultipoleUtilities.ti(3, 0, 3, order);
        this.t033 = MultipoleUtilities.ti(0, 3, 3, order);
        this.t321 = MultipoleUtilities.ti(3, 2, 1, order);
        this.t231 = MultipoleUtilities.ti(2, 3, 1, order);
        this.t213 = MultipoleUtilities.ti(2, 1, 3, order);
        this.t312 = MultipoleUtilities.ti(3, 1, 2, order);
        this.t132 = MultipoleUtilities.ti(1, 3, 2, order);
        this.t123 = MultipoleUtilities.ti(1, 2, 3, order);
        this.t222 = MultipoleUtilities.ti(2, 2, 2, order);
    }

    public final void setR(DoubleVector[] r) {
        this.setR(r[0], r[1], r[2]);
    }

    public abstract void setR(DoubleVector var1, DoubleVector var2, DoubleVector var3);

    public void generateTensor() {
        switch (this.order) {
            case 1: {
                this.order1();
                break;
            }
            case 2: {
                this.order2();
                break;
            }
            case 3: {
                this.order3();
                break;
            }
            case 4: {
                this.order4();
                break;
            }
            case 5: {
                this.order5();
                break;
            }
            case 6: {
                this.order6();
                break;
            }
            default: {
                if (!logger.isLoggable(Level.WARNING)) break;
                logger.severe("Order " + this.order + " not supported.");
            }
        }
    }

    public DoubleVector[] getSource() {
        this.source(this.work);
        return this.work;
    }

    protected final DoubleVector multipoleEnergy(PolarizableMultipoleSIMD m) {
        DoubleVector total = m.q.mul((Vector)this.E000);
        total = m.dx.fma((Vector)this.E100, (Vector)total);
        total = m.dy.fma((Vector)this.E010, (Vector)total);
        total = m.dz.fma((Vector)this.E001, (Vector)total);
        total = m.qxx.fma((Vector)this.E200, (Vector)total);
        total = m.qyy.fma((Vector)this.E020, (Vector)total);
        total = m.qzz.fma((Vector)this.E002, (Vector)total);
        total = m.qxy.fma((Vector)this.E110, (Vector)total);
        total = m.qxz.fma((Vector)this.E101, (Vector)total);
        total = m.qyz.fma((Vector)this.E011, (Vector)total);
        return total;
    }

    public DoubleVector multipoleEnergy(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        this.multipoleIPotentialAtK(mI, 2);
        return this.multipoleEnergy(mK);
    }

    protected final void multipoleGradient(PolarizableMultipoleSIMD m, DoubleVector[] g) {
        DoubleVector total = m.q.mul((Vector)this.E100);
        total = m.dx.fma((Vector)this.E200, (Vector)total);
        total = m.dy.fma((Vector)this.E110, (Vector)total);
        total = m.dz.fma((Vector)this.E101, (Vector)total);
        total = m.qxx.fma((Vector)this.E300, (Vector)total);
        total = m.qyy.fma((Vector)this.E120, (Vector)total);
        total = m.qzz.fma((Vector)this.E102, (Vector)total);
        total = m.qxy.fma((Vector)this.E210, (Vector)total);
        total = m.qxz.fma((Vector)this.E201, (Vector)total);
        g[0] = total = m.qyz.fma((Vector)this.E111, (Vector)total);
        total = m.q.mul((Vector)this.E010);
        total = m.dx.fma((Vector)this.E110, (Vector)total);
        total = m.dy.fma((Vector)this.E020, (Vector)total);
        total = m.dz.fma((Vector)this.E011, (Vector)total);
        total = m.qxx.fma((Vector)this.E210, (Vector)total);
        total = m.qyy.fma((Vector)this.E030, (Vector)total);
        total = m.qzz.fma((Vector)this.E012, (Vector)total);
        total = m.qxy.fma((Vector)this.E120, (Vector)total);
        total = m.qxz.fma((Vector)this.E111, (Vector)total);
        g[1] = total = m.qyz.fma((Vector)this.E021, (Vector)total);
        total = m.q.mul((Vector)this.E001);
        total = m.dx.fma((Vector)this.E101, (Vector)total);
        total = m.dy.fma((Vector)this.E011, (Vector)total);
        total = m.dz.fma((Vector)this.E002, (Vector)total);
        total = m.qxx.fma((Vector)this.E201, (Vector)total);
        total = m.qyy.fma((Vector)this.E021, (Vector)total);
        total = m.qzz.fma((Vector)this.E003, (Vector)total);
        total = m.qxy.fma((Vector)this.E111, (Vector)total);
        total = m.qxz.fma((Vector)this.E102, (Vector)total);
        g[2] = total = m.qyz.fma((Vector)this.E012, (Vector)total);
    }

    protected final void multipoleTorque(PolarizableMultipoleSIMD m, DoubleVector[] torque) {
        DoubleVector dx = m.dy.mul((Vector)this.E001).sub((Vector)m.dz.mul((Vector)this.E010));
        DoubleVector dy = m.dz.mul((Vector)this.E100).sub((Vector)m.dx.mul((Vector)this.E001));
        DoubleVector dz = m.dx.mul((Vector)this.E010).sub((Vector)m.dy.mul((Vector)this.E100));
        DoubleVector qx = m.qxy.mul((Vector)this.E101).add((Vector)m.qyy.mul((Vector)this.E011).mul(2.0)).add((Vector)m.qyz.mul((Vector)this.E002)).sub((Vector)m.qxz.mul((Vector)this.E110).add((Vector)m.qyz.mul((Vector)this.E020)).add((Vector)m.qzz.mul((Vector)this.E011).mul(2.0)));
        DoubleVector qy = m.qxz.mul((Vector)this.E200).add((Vector)m.qyz.mul((Vector)this.E110)).add((Vector)m.qzz.mul((Vector)this.E101).mul(2.0)).sub((Vector)m.qxx.mul((Vector)this.E101).mul(2.0).add((Vector)m.qxy.mul((Vector)this.E011)).add((Vector)m.qxz.mul((Vector)this.E002)));
        DoubleVector qz = m.qxx.mul((Vector)this.E110).mul(2.0).add((Vector)m.qxy.mul((Vector)this.E020)).add((Vector)m.qxz.mul((Vector)this.E011)).sub((Vector)m.qxy.mul((Vector)this.E200).add((Vector)m.qyy.mul((Vector)this.E110).mul(2.0)).add((Vector)m.qyz.mul((Vector)this.E101)));
        torque[0] = torque[0].sub((Vector)dx.add((Vector)qx));
        torque[1] = torque[1].sub((Vector)dy.add((Vector)qy));
        torque[2] = torque[2].sub((Vector)dz.add((Vector)qz));
    }

    protected final void dipoleTorque(PolarizableMultipoleSIMD m, DoubleVector[] torque) {
        DoubleVector dx = m.dy.mul((Vector)this.E001).sub((Vector)m.dz.mul((Vector)this.E010));
        DoubleVector dy = m.dz.mul((Vector)this.E100).sub((Vector)m.dx.mul((Vector)this.E001));
        DoubleVector dz = m.dx.mul((Vector)this.E010).sub((Vector)m.dy.mul((Vector)this.E100));
        torque[0] = torque[0].sub((Vector)dx);
        torque[1] = torque[1].sub((Vector)dy);
        torque[2] = torque[2].sub((Vector)dz);
    }

    protected final void quadrupoleTorque(PolarizableMultipoleSIMD m, DoubleVector[] torque) {
        DoubleVector qx = m.qxy.mul((Vector)this.E101).add((Vector)m.qyy.mul((Vector)this.E011).mul(2.0)).add((Vector)m.qyz.mul((Vector)this.E002)).sub((Vector)m.qxz.mul((Vector)this.E110).add((Vector)m.qyz.mul((Vector)this.E020)).add((Vector)m.qzz.mul((Vector)this.E011).mul(2.0)));
        DoubleVector qy = m.qxz.mul((Vector)this.E200).add((Vector)m.qyz.mul((Vector)this.E110)).add((Vector)m.qzz.mul((Vector)this.E101).mul(2.0)).sub((Vector)m.qxx.mul((Vector)this.E101).mul(2.0).add((Vector)m.qxy.mul((Vector)this.E011)).add((Vector)m.qxz.mul((Vector)this.E002)));
        DoubleVector qz = m.qxx.mul((Vector)this.E110).mul(2.0).add((Vector)m.qxy.mul((Vector)this.E020)).add((Vector)m.qxz.mul((Vector)this.E011)).sub((Vector)m.qxy.mul((Vector)this.E200).add((Vector)m.qyy.mul((Vector)this.E110).mul(2.0)).add((Vector)m.qyz.mul((Vector)this.E101)));
        torque[0] = torque[0].sub((Vector)qx);
        torque[1] = torque[1].sub((Vector)qy);
        torque[2] = torque[2].sub((Vector)qz);
    }

    protected final DoubleVector polarizationEnergy(PolarizableMultipoleSIMD m) {
        return m.ux.mul((Vector)this.E100).add((Vector)m.uy.mul((Vector)this.E010)).add((Vector)m.uz.mul((Vector)this.E001)).mul(0.5);
    }

    protected final DoubleVector polarizationEnergyS(PolarizableMultipoleSIMD m) {
        return m.sx.mul((Vector)this.E100).add((Vector)m.sy.mul((Vector)this.E010)).add((Vector)m.sz.mul((Vector)this.E001)).mul(0.5);
    }

    public DoubleVector polarizationEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector inductionMask, DoubleVector energyMask, DoubleVector mutualMask, DoubleVector[] Gi, DoubleVector[] Ti, DoubleVector[] Tk) {
        mI.applyMasks(inductionMask, energyMask);
        mK.applyMasks(inductionMask, energyMask);
        this.multipoleIPotentialAtK(mI, 2);
        DoubleVector eK = this.polarizationEnergy(mK);
        Gi[0] = mK.sx.mul((Vector)this.E200).add((Vector)mK.sy.mul((Vector)this.E110)).add((Vector)mK.sz.mul((Vector)this.E101)).neg();
        Gi[1] = mK.sx.mul((Vector)this.E110).add((Vector)mK.sy.mul((Vector)this.E020)).add((Vector)mK.sz.mul((Vector)this.E011)).neg();
        Gi[2] = mK.sx.mul((Vector)this.E101).add((Vector)mK.sy.mul((Vector)this.E011)).add((Vector)mK.sz.mul((Vector)this.E002)).neg();
        this.multipoleKPotentialAtI(mK, 2);
        DoubleVector eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0].add((Vector)mI.sx.mul((Vector)this.E200).add((Vector)mI.sy.mul((Vector)this.E110)).add((Vector)mI.sz.mul((Vector)this.E101)));
        Gi[1] = Gi[1].add((Vector)mI.sx.mul((Vector)this.E110).add((Vector)mI.sy.mul((Vector)this.E020)).add((Vector)mI.sz.mul((Vector)this.E011)));
        Gi[2] = Gi[2].add((Vector)mI.sx.mul((Vector)this.E101).add((Vector)mI.sy.mul((Vector)this.E011)).add((Vector)mI.sz.mul((Vector)this.E002)));
        DoubleVector energy = eI.add((Vector)eK).mul((Vector)energyMask);
        this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
        Gi[0] = Gi[0].sub((Vector)mK.px.mul((Vector)this.E200).add((Vector)mK.py.mul((Vector)this.E110)).add((Vector)mK.pz.mul((Vector)this.E101)).mul(0.5).mul((Vector)mutualMask));
        Gi[1] = Gi[1].sub((Vector)mK.px.mul((Vector)this.E110).add((Vector)mK.py.mul((Vector)this.E020)).add((Vector)mK.pz.mul((Vector)this.E011)).mul(0.5).mul((Vector)mutualMask));
        Gi[2] = Gi[2].sub((Vector)mK.px.mul((Vector)this.E101).add((Vector)mK.py.mul((Vector)this.E011)).add((Vector)mK.pz.mul((Vector)this.E002)).mul(0.5).mul((Vector)mutualMask));
        this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
        Gi[0] = Gi[0].add((Vector)mI.px.mul((Vector)this.E200).add((Vector)mI.py.mul((Vector)this.E110)).add((Vector)mI.pz.mul((Vector)this.E101)).mul(0.5).mul((Vector)mutualMask));
        Gi[1] = Gi[1].add((Vector)mI.px.mul((Vector)this.E110).add((Vector)mI.py.mul((Vector)this.E020)).add((Vector)mI.pz.mul((Vector)this.E011)).mul(0.5).mul((Vector)mutualMask));
        Gi[2] = Gi[2].add((Vector)mI.px.mul((Vector)this.E101).add((Vector)mI.py.mul((Vector)this.E011)).add((Vector)mI.pz.mul((Vector)this.E002)).mul(0.5).mul((Vector)mutualMask));
        this.dipoleIPotentialAtK(mI.sx, mI.sy, mI.sz, 2);
        this.multipoleTorque(mK, Tk);
        this.dipoleKPotentialAtI(mK.sx, mK.sy, mK.sz, 2);
        this.multipoleTorque(mI, Ti);
        return energy;
    }

    public DoubleVector multipoleEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi, DoubleVector[] Gk, DoubleVector[] Ti, DoubleVector[] Tk) {
        this.multipoleIPotentialAtK(mI, 3);
        DoubleVector energy = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        Gi[0] = Gi[0].sub((Vector)Gk[0]);
        Gi[1] = Gi[1].sub((Vector)Gk[1]);
        Gi[2] = Gi[2].sub((Vector)Gk[2]);
        this.multipoleTorque(mK, Tk);
        this.multipoleKPotentialAtI(mK, 2);
        this.multipoleTorque(mI, Ti);
        return energy;
    }

    protected abstract void source(DoubleVector[] var1);

    protected abstract void order1();

    protected abstract void order2();

    protected abstract void order3();

    protected abstract void order4();

    protected abstract void order5();

    protected abstract void order6();

    protected abstract void multipoleIPotentialAtK(PolarizableMultipoleSIMD var1, int var2);

    protected abstract void multipoleKPotentialAtI(PolarizableMultipoleSIMD var1, int var2);

    protected abstract void chargeKPotentialAtI(PolarizableMultipoleSIMD var1, int var2);

    protected abstract void dipoleKPotentialAtI(DoubleVector var1, DoubleVector var2, DoubleVector var3, int var4);

    protected abstract void quadrupoleKPotentialAtI(PolarizableMultipoleSIMD var1, int var2);

    protected abstract void chargeIPotentialAtK(PolarizableMultipoleSIMD var1, int var2);

    protected abstract void dipoleIPotentialAtK(DoubleVector var1, DoubleVector var2, DoubleVector var3, int var4);

    protected abstract void quadrupoleIPotentialAtK(PolarizableMultipoleSIMD var1, int var2);

    protected final int ti(int dx, int dy, int dz) {
        return MultipoleUtilities.ti(dx, dy, dz, this.order);
    }
}

