/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobal;
import ffx.numerics.multipole.GKMultipoleOrder;
import ffx.numerics.multipole.GKSource;
import ffx.numerics.multipole.PolarizableMultipole;
import jdk.incubator.vector.DoubleVector;

public class GKTensorGlobal
extends CoulombTensorGlobal {
    protected final GKMultipoleOrder multipoleOrder;
    private final double c;
    private final GKSource gkSource;

    public GKTensorGlobal(GKMultipoleOrder multipoleOrder, int order, GKSource gkSource, double Eh, double Es) {
        super(order);
        this.multipoleOrder = multipoleOrder;
        this.gkSource = gkSource;
        this.c = GKSource.cn(multipoleOrder.getOrder(), Eh, Es);
    }

    @Override
    public double multipoleEnergy(PolarizableMultipole mI, PolarizableMultipole mK) {
        return switch (this.multipoleOrder) {
            default -> {
                this.chargeIPotentialAtK(mI, 2);
                double eK = this.multipoleEnergy(mK);
                this.chargeKPotentialAtI(mK, 2);
                double eI = this.multipoleEnergy(mI);
                yield this.c * 0.5 * (eK + eI);
            }
            case GKMultipoleOrder.DIPOLE -> {
                this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 2);
                double eK = this.multipoleEnergy(mK);
                this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 2);
                double eI = this.multipoleEnergy(mI);
                yield this.c * 0.5 * (eK + eI);
            }
            case GKMultipoleOrder.QUADRUPOLE -> {
                this.quadrupoleIPotentialAtK(mI, 2);
                double eK = this.multipoleEnergy(mK);
                this.quadrupoleKPotentialAtI(mK, 2);
                double eI = this.multipoleEnergy(mI);
                yield this.c * 0.5 * (eK + eI);
            }
        };
    }

    @Override
    public double multipoleEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Gk, double[] Ti, double[] Tk) {
        return switch (this.multipoleOrder) {
            default -> this.monopoleEnergyAndGradient(mI, mK, Gi, Gk, Ti, Tk);
            case GKMultipoleOrder.DIPOLE -> this.dipoleEnergyAndGradient(mI, mK, Gi, Gk, Ti, Tk);
            case GKMultipoleOrder.QUADRUPOLE -> this.quadrupoleEnergyAndGradient(mI, mK, Gi, Gk, Ti, Tk);
        };
    }

    protected double monopoleEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Gk, double[] Ti, double[] Tk) {
        this.chargeIPotentialAtK(mI, 3);
        double eK = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        this.multipoleTorque(mK, Tk);
        this.chargeKPotentialAtI(mK, 3);
        double eI = this.multipoleEnergy(mI);
        this.multipoleGradient(mI, Gi);
        this.multipoleTorque(mI, Ti);
        double scale = this.c * 0.5;
        Gi[0] = scale * (Gi[0] - Gk[0]);
        Gi[1] = scale * (Gi[1] - Gk[1]);
        Gi[2] = scale * (Gi[2] - Gk[2]);
        Gk[0] = -Gi[0];
        Gk[1] = -Gi[1];
        Gk[2] = -Gi[2];
        Ti[0] = scale * Ti[0];
        Ti[1] = scale * Ti[1];
        Ti[2] = scale * Ti[2];
        Tk[0] = scale * Tk[0];
        Tk[1] = scale * Tk[1];
        Tk[2] = scale * Tk[2];
        return scale * (eK + eI);
    }

    protected double dipoleEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Gk, double[] Ti, double[] Tk) {
        this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 3);
        double eK = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        this.multipoleTorque(mK, Tk);
        this.multipoleKPotentialAtI(mK, 1);
        this.dipoleTorque(mI, Ti);
        this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 3);
        double eI = this.multipoleEnergy(mI);
        this.multipoleGradient(mI, Gi);
        this.multipoleTorque(mI, Ti);
        this.multipoleIPotentialAtK(mI, 1);
        this.dipoleTorque(mK, Tk);
        double scale = this.c * 0.5;
        Gi[0] = scale * (Gi[0] - Gk[0]);
        Gi[1] = scale * (Gi[1] - Gk[1]);
        Gi[2] = scale * (Gi[2] - Gk[2]);
        Gk[0] = -Gi[0];
        Gk[1] = -Gi[1];
        Gk[2] = -Gi[2];
        Ti[0] = scale * Ti[0];
        Ti[1] = scale * Ti[1];
        Ti[2] = scale * Ti[2];
        Tk[0] = scale * Tk[0];
        Tk[1] = scale * Tk[1];
        Tk[2] = scale * Tk[2];
        return scale * (eK + eI);
    }

    protected double quadrupoleEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Gk, double[] Ti, double[] Tk) {
        this.quadrupoleIPotentialAtK(mI, 3);
        double eK = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        this.multipoleTorque(mK, Tk);
        this.multipoleKPotentialAtI(mK, 2);
        this.quadrupoleTorque(mI, Ti);
        this.quadrupoleKPotentialAtI(mK, 3);
        double eI = this.multipoleEnergy(mI);
        this.multipoleGradient(mI, Gi);
        this.multipoleTorque(mI, Ti);
        this.multipoleIPotentialAtK(mI, 2);
        this.quadrupoleTorque(mK, Tk);
        double scale = this.c * 0.5;
        Gi[0] = scale * (Gi[0] - Gk[0]);
        Gi[1] = scale * (Gi[1] - Gk[1]);
        Gi[2] = scale * (Gi[2] - Gk[2]);
        Gk[0] = -Gi[0];
        Gk[1] = -Gi[1];
        Gk[2] = -Gi[2];
        Ti[0] = scale * Ti[0];
        Ti[1] = scale * Ti[1];
        Ti[2] = scale * Ti[2];
        Tk[0] = scale * Tk[0];
        Tk[1] = scale * Tk[1];
        Tk[2] = scale * Tk[2];
        return scale * (eK + eI);
    }

    public double multipoleEnergyBornGrad(PolarizableMultipole mI, PolarizableMultipole mK) {
        return this.multipoleEnergy(mI, mK);
    }

    public double polarizationEnergy(PolarizableMultipole mI, PolarizableMultipole mK, DoubleVector scaleEnergy) {
        return this.polarizationEnergy(mI, mK);
    }

    public double polarizationEnergy(PolarizableMultipole mI, PolarizableMultipole mK) {
        return switch (this.multipoleOrder) {
            default -> {
                this.chargeIPotentialAtK(mI, 1);
                double eK = this.polarizationEnergy(mK);
                this.chargeKPotentialAtI(mK, 1);
                double eI = this.polarizationEnergy(mI);
                yield this.c * 0.5 * (eK + eI);
            }
            case GKMultipoleOrder.DIPOLE -> {
                this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 1);
                double eK = this.polarizationEnergy(mK);
                this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
                this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 1);
                double eI = this.polarizationEnergy(mI);
                this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
                yield this.c * 0.5 * ((eK += 0.5 * this.multipoleEnergy(mK)) + (eI += 0.5 * this.multipoleEnergy(mI)));
            }
            case GKMultipoleOrder.QUADRUPOLE -> {
                this.quadrupoleIPotentialAtK(mI, 1);
                double eK = this.polarizationEnergy(mK);
                this.quadrupoleKPotentialAtI(mK, 1);
                double eI = this.polarizationEnergy(mI);
                yield this.c * 0.5 * (eK + eI);
            }
        };
    }

    public double polarizationEnergyBorn(PolarizableMultipole mI, PolarizableMultipole mK) {
        return switch (this.multipoleOrder) {
            default -> {
                this.chargeIPotentialAtK(mI, 1);
                double eK = this.polarizationEnergyS(mK);
                this.chargeKPotentialAtI(mK, 1);
                double eI = this.polarizationEnergyS(mI);
                yield this.c * 0.5 * (eK + eI);
            }
            case GKMultipoleOrder.DIPOLE -> {
                this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 1);
                double eK = this.polarizationEnergyS(mK);
                this.dipoleIPotentialAtK(mI.sx, mI.sy, mI.sz, 2);
                this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 1);
                double eI = this.polarizationEnergyS(mI);
                this.dipoleKPotentialAtI(mK.sx, mK.sy, mK.sz, 2);
                yield this.c * 0.5 * ((eK += 0.5 * this.multipoleEnergy(mK)) + (eI += 0.5 * this.multipoleEnergy(mI)));
            }
            case GKMultipoleOrder.QUADRUPOLE -> {
                this.quadrupoleIPotentialAtK(mI, 1);
                double eK = this.polarizationEnergyS(mK);
                this.quadrupoleKPotentialAtI(mK, 1);
                double eI = this.polarizationEnergyS(mI);
                yield this.c * 0.5 * (eK + eI);
            }
        };
    }

    @Override
    public double polarizationEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double inductionMask, double energyMask, double mutualMask, double[] Gi, double[] Ti, double[] Tk) {
        return switch (this.multipoleOrder) {
            default -> this.monopolePolarizationEnergyAndGradient(mI, mK, Gi);
            case GKMultipoleOrder.DIPOLE -> this.dipolePolarizationEnergyAndGradient(mI, mK, mutualMask, Gi, Ti, Tk);
            case GKMultipoleOrder.QUADRUPOLE -> this.quadrupolePolarizationEnergyAndGradient(mI, mK, Gi, Ti, Tk);
        };
    }

    public double monopolePolarizationEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi) {
        this.chargeIPotentialAtK(mI, 2);
        double eK = this.polarizationEnergy(mK);
        Gi[0] = -(mK.sx * this.E200 + mK.sy * this.E110 + mK.sz * this.E101);
        Gi[1] = -(mK.sx * this.E110 + mK.sy * this.E020 + mK.sz * this.E011);
        Gi[2] = -(mK.sx * this.E101 + mK.sy * this.E011 + mK.sz * this.E002);
        this.chargeKPotentialAtI(mK, 2);
        double eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0] + (mI.sx * this.E200 + mI.sy * this.E110 + mI.sz * this.E101);
        Gi[1] = Gi[1] + (mI.sx * this.E110 + mI.sy * this.E020 + mI.sz * this.E011);
        Gi[2] = Gi[2] + (mI.sx * this.E101 + mI.sy * this.E011 + mI.sz * this.E002);
        double scale = this.c * 0.5;
        Gi[0] = Gi[0] * scale;
        Gi[1] = Gi[1] * scale;
        Gi[2] = Gi[2] * scale;
        return scale * (eI + eK);
    }

    public double dipolePolarizationEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double mutualMask, double[] Gi, double[] Ti, double[] Tk) {
        this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 2);
        double eK = this.polarizationEnergy(mK);
        Gi[0] = -(mK.sx * this.E200 + mK.sy * this.E110 + mK.sz * this.E101);
        Gi[1] = -(mK.sx * this.E110 + mK.sy * this.E020 + mK.sz * this.E011);
        Gi[2] = -(mK.sx * this.E101 + mK.sy * this.E011 + mK.sz * this.E002);
        this.dipoleIPotentialAtK(mI.sx, mI.sy, mI.sz, 2);
        this.dipoleTorque(mK, Tk);
        this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 3);
        eK += 0.5 * this.multipoleEnergy(mK);
        double[] G = new double[3];
        this.multipoleGradient(mK, G);
        Gi[0] = Gi[0] - G[0];
        Gi[1] = Gi[1] - G[1];
        Gi[2] = Gi[2] - G[2];
        this.multipoleTorque(mK, Tk);
        this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 2);
        double eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0] + (mI.sx * this.E200 + mI.sy * this.E110 + mI.sz * this.E101);
        Gi[1] = Gi[1] + (mI.sx * this.E110 + mI.sy * this.E020 + mI.sz * this.E011);
        Gi[2] = Gi[2] + (mI.sx * this.E101 + mI.sy * this.E011 + mI.sz * this.E002);
        this.dipoleKPotentialAtI(mK.sx, mK.sy, mK.sz, 2);
        this.dipoleTorque(mI, Ti);
        this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 3);
        eI += 0.5 * this.multipoleEnergy(mI);
        G = new double[3];
        this.multipoleGradient(mI, G);
        Gi[0] = Gi[0] + G[0];
        Gi[1] = Gi[1] + G[1];
        Gi[2] = Gi[2] + G[2];
        this.multipoleTorque(mI, Ti);
        if (mutualMask != 0.0) {
            this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
            Gi[0] = Gi[0] - mutualMask * (mK.px * this.E200 + mK.py * this.E110 + mK.pz * this.E101);
            Gi[1] = Gi[1] - mutualMask * (mK.px * this.E110 + mK.py * this.E020 + mK.pz * this.E011);
            Gi[2] = Gi[2] - mutualMask * (mK.px * this.E101 + mK.py * this.E011 + mK.pz * this.E002);
            this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
            Gi[0] = Gi[0] + mutualMask * (mI.px * this.E200 + mI.py * this.E110 + mI.pz * this.E101);
            Gi[1] = Gi[1] + mutualMask * (mI.px * this.E110 + mI.py * this.E020 + mI.pz * this.E011);
            Gi[2] = Gi[2] + mutualMask * (mI.px * this.E101 + mI.py * this.E011 + mI.pz * this.E002);
        }
        double scale = this.c * 0.5;
        double energy = scale * (eI + eK);
        Gi[0] = Gi[0] * scale;
        Gi[1] = Gi[1] * scale;
        Gi[2] = Gi[2] * scale;
        Ti[0] = Ti[0] * scale;
        Ti[1] = Ti[1] * scale;
        Ti[2] = Ti[2] * scale;
        Tk[0] = Tk[0] * scale;
        Tk[1] = Tk[1] * scale;
        Tk[2] = Tk[2] * scale;
        return energy;
    }

    public double quadrupolePolarizationEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Ti, double[] Tk) {
        this.quadrupoleIPotentialAtK(mI, 2);
        double eK = this.polarizationEnergy(mK);
        Gi[0] = -(mK.sx * this.E200 + mK.sy * this.E110 + mK.sz * this.E101);
        Gi[1] = -(mK.sx * this.E110 + mK.sy * this.E020 + mK.sz * this.E011);
        Gi[2] = -(mK.sx * this.E101 + mK.sy * this.E011 + mK.sz * this.E002);
        this.quadrupoleKPotentialAtI(mK, 2);
        double eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0] + (mI.sx * this.E200 + mI.sy * this.E110 + mI.sz * this.E101);
        Gi[1] = Gi[1] + (mI.sx * this.E110 + mI.sy * this.E020 + mI.sz * this.E011);
        Gi[2] = Gi[2] + (mI.sx * this.E101 + mI.sy * this.E011 + mI.sz * this.E002);
        double scale = this.c * 0.5;
        Gi[0] = Gi[0] * scale;
        Gi[1] = Gi[1] * scale;
        Gi[2] = Gi[2] * scale;
        this.dipoleIPotentialAtK(scale * mI.sx, scale * mI.sy, scale * mI.sz, 2);
        this.quadrupoleTorque(mK, Tk);
        this.dipoleKPotentialAtI(scale * mK.sx, scale * mK.sy, scale * mK.sz, 2);
        this.quadrupoleTorque(mI, Ti);
        return scale * (eI + eK);
    }

    public double polarizationEnergyBornGrad(PolarizableMultipole mI, PolarizableMultipole mK) {
        return 2.0 * this.polarizationEnergyBorn(mI, mK);
    }

    public double mutualPolarizationEnergyBornGrad(PolarizableMultipole mI, PolarizableMultipole mK) {
        double db = 0.0;
        if (this.multipoleOrder == GKMultipoleOrder.DIPOLE) {
            this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
            db = 0.5 * (mK.px * this.E100 + mK.py * this.E010 + mK.pz * this.E001);
            this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
            db += 0.5 * (mI.px * this.E100 + mI.py * this.E010 + mI.pz * this.E001);
        }
        return this.c * db;
    }

    @Override
    protected void source(double[] work) {
        this.gkSource.source(work, this.multipoleOrder);
    }
}

