/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.math.ScalarMath;
import ffx.numerics.multipole.GKMultipoleOrder;
import ffx.numerics.multipole.GKTensorMode;
import ffx.numerics.multipole.PolarizableMultipole;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class GKSource {
    private GKTensorMode mode = GKTensorMode.POTENTIAL;
    private double rb2;
    private double expTerm;
    private double f;
    private double f1;
    private double f2;
    private final double gc;
    private final double igc;
    private double gcAiAj;
    private double ratio;
    private double fr;
    private double r2;
    private final int order;
    private final double[] kirkwoodSource;
    private final double[][] anmc;
    private final double[] fn;
    protected final double[] bn;
    private final double[][] anm;
    private final double[][] bnm;

    public GKSource(int order, double gc) {
        int n;
        this.order = order;
        this.gc = gc;
        this.igc = 1.0 / gc;
        this.kirkwoodSource = new double[order + 1];
        for (n = 0; n <= order; n = (int)((short)(n + 1))) {
            this.kirkwoodSource[n] = FastMath.pow((double)-1.0, (int)n) * (double)ScalarMath.doubleFactorial(2 * n - 1);
        }
        this.anmc = new double[order + 1][];
        for (n = 0; n <= order; ++n) {
            this.anmc[n] = GKSource.anmc(n);
        }
        this.fn = new double[order + 1];
        this.anm = new double[order + 1][order + 1];
        this.bn = new double[order + 1];
        this.bnm = new double[order + 1][order + 1];
    }

    protected void source(double[] work, GKMultipoleOrder multipoleOrder) {
        int mpoleOrder = multipoleOrder.getOrder();
        Arrays.fill(work, 0, mpoleOrder, 0.0);
        if (this.mode == GKTensorMode.POTENTIAL) {
            int derivatives = this.order - mpoleOrder;
            System.arraycopy(this.anm[mpoleOrder], 0, work, mpoleOrder, derivatives + 1);
        } else {
            int derivatives = this.order - 1 - mpoleOrder;
            System.arraycopy(this.bnm[mpoleOrder], 0, work, mpoleOrder, derivatives + 1);
        }
    }

    public void generateSource(GKTensorMode mode, GKMultipoleOrder multipole, double r2, double ai, double aj) {
        int multipoleOrder = multipole.getOrder();
        this.mode = mode;
        this.r2 = r2;
        this.rb2 = ai * aj;
        this.gcAiAj = this.gc * this.rb2;
        this.ratio = -r2 / this.gcAiAj;
        this.expTerm = FastMath.exp((double)this.ratio);
        this.fr = -2.0 / this.gcAiAj;
        this.f = FastMath.sqrt((double)(r2 + this.rb2 * this.expTerm));
        this.f1 = 1.0 - this.expTerm * this.igc;
        this.f2 = 2.0 * this.expTerm / (this.gc * this.gcAiAj);
        if (mode == GKTensorMode.POTENTIAL) {
            this.anm(this.order, this.order - multipoleOrder);
        } else {
            this.bnm(this.order - 1, this.order - 1 - multipoleOrder);
        }
    }

    private void anm(int n, int derivatives) {
        this.fn(n);
        this.an0(n);
        for (int d = 1; d <= derivatives; ++d) {
            double[] coef = this.anmc[d];
            int limit = n - d;
            for (int order = 0; order <= limit; ++order) {
                double[] terms = this.anm[order + 1];
                double sum = 0.0;
                for (int i = 1; i <= d; ++i) {
                    sum += coef[i - 1] * this.fn[i] * terms[d - i];
                }
                this.anm[order][d] = sum;
            }
        }
    }

    private void bnm(int n, int derivatives) {
        this.bn(n);
        this.bn0(n);
        for (int d = 1; d <= derivatives; ++d) {
            double[] coef = this.anmc[d];
            int limit = n - d;
            for (int order = 0; order <= limit; ++order) {
                double[] terma = this.anm[order + 1];
                double[] termb = this.bnm[order + 1];
                double sum = 0.0;
                for (int i = 1; i <= d; ++i) {
                    sum += coef[i - 1] * this.bn[i] * terma[d - i];
                    sum += coef[i - 1] * this.fn[i] * termb[d - i];
                }
                this.bnm[order][d] = sum;
            }
        }
    }

    private void fn(int n) {
        switch (n) {
            case 0: {
                this.fn[0] = this.f;
                break;
            }
            case 1: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                break;
            }
            case 2: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                break;
            }
            case 3: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr * this.f2;
                break;
            }
            case 4: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr * this.f2;
                this.fn[4] = this.fr * this.fn[3];
                break;
            }
            case 5: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr * this.f2;
                this.fn[4] = this.fr * this.fn[3];
                this.fn[5] = this.fr * this.fn[4];
                break;
            }
            case 6: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr * this.f2;
                this.fn[4] = this.fr * this.fn[3];
                this.fn[5] = this.fr * this.fn[4];
                this.fn[6] = this.fr * this.fn[5];
                break;
            }
            default: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                for (int i = 3; i <= n; ++i) {
                    this.fn[i] = this.fr * this.fn[i - 1];
                }
            }
        }
    }

    protected void bn(int n) {
        double b2 = 2.0 * this.expTerm / (this.gcAiAj * this.gcAiAj) * (-this.ratio - 1.0);
        switch (n) {
            case 0: {
                this.bn[0] = 0.5 * this.expTerm * (1.0 - this.ratio);
                break;
            }
            case 1: {
                this.bn[0] = 0.5 * this.expTerm * (1.0 - this.ratio);
                this.bn[1] = -this.r2 * this.expTerm / (this.gcAiAj * this.gcAiAj);
                break;
            }
            case 2: {
                this.bn[0] = 0.5 * this.expTerm * (1.0 - this.ratio);
                this.bn[1] = -this.r2 * this.expTerm / (this.gcAiAj * this.gcAiAj);
                this.bn[2] = b2;
                break;
            }
            default: {
                this.bn[0] = 0.5 * this.expTerm * (1.0 - this.ratio);
                this.bn[1] = -this.r2 * this.expTerm / (this.gcAiAj * this.gcAiAj);
                this.bn[2] = b2;
                double br = 2.0 / (this.gcAiAj * this.rb2);
                double f2 = 2.0 / (this.gc * this.gcAiAj) * this.expTerm;
                double frA = 1.0;
                double frB = this.fr;
                for (int i = 3; i < n; ++i) {
                    this.bn[i] = (double)(i - 2) * frA * br * f2 + frB * b2;
                    frA *= this.fr;
                    frB *= this.fr;
                }
            }
        }
    }

    private void an0(int n) {
        double inverseF = 1.0 / this.f;
        double inverseF2 = inverseF * inverseF;
        for (int i = 0; i <= n; ++i) {
            this.anm[i][0] = this.kirkwoodSource[i] * inverseF;
            inverseF *= inverseF2;
        }
    }

    private void bn0(int n) {
        for (int i = 0; i <= n; ++i) {
            this.bnm[i][0] = this.bn[0] * this.anm[i + 1][0];
        }
    }

    protected static double[] anmc(int n) {
        double[] ret = new double[n + 1];
        ret[0] = 1.0;
        switch (n) {
            case 0: {
                return ret;
            }
            case 1: {
                ret[1] = 1.0;
                return ret;
            }
        }
        ret[1] = 1.0;
        double[] prev = new double[n];
        prev[0] = 1.0;
        prev[1] = 1.0;
        for (int i = 3; i <= n; ++i) {
            for (int j = 2; j <= i - 1; ++j) {
                ret[j - 1] = prev[j - 2] + prev[j - 1];
            }
            ret[i - 1] = 1.0;
            System.arraycopy(ret, 0, prev, 0, i);
        }
        return ret;
    }

    public static double cn(int n, double Eh, double Es) {
        double ret = (double)(n + 1) * (Eh - Es) / ((double)(n + 1) * Es + (double)n * Eh);
        return ret / Eh;
    }

    public static double selfEnergy(PolarizableMultipole polarizableMultipole, double ai, double Eh, double Es) {
        double q2 = polarizableMultipole.q * polarizableMultipole.q;
        double dx = polarizableMultipole.dx;
        double dy = polarizableMultipole.dy;
        double dz = polarizableMultipole.dz;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dz2 = dz * dz;
        double ux = polarizableMultipole.ux;
        double uy = polarizableMultipole.uy;
        double uz = polarizableMultipole.uz;
        double qxy2 = polarizableMultipole.qxy * polarizableMultipole.qxy;
        double qxz2 = polarizableMultipole.qxz * polarizableMultipole.qxz;
        double qyz2 = polarizableMultipole.qyz * polarizableMultipole.qyz;
        double qxx2 = polarizableMultipole.qxx * polarizableMultipole.qxx;
        double qyy2 = polarizableMultipole.qyy * polarizableMultipole.qyy;
        double qzz2 = polarizableMultipole.qzz * polarizableMultipole.qzz;
        double a2 = ai * ai;
        double a3 = ai * a2;
        double a5 = a2 * a3;
        double e0 = GKSource.cn(0, Eh, Es) * q2 / ai;
        double e1 = GKSource.cn(1, Eh, Es) * (dx2 + dy2 + dz2) / a3;
        double e2 = GKSource.cn(2, Eh, Es) * (3.0 * (qxy2 + qxz2 + qyz2) + 6.0 * (qxx2 + qyy2 + qzz2)) / a5;
        double ei = GKSource.cn(1, Eh, Es) * (dx * ux + dy * uy + dz * uz) / a3;
        return 0.5 * (e0 + e1 + e2 + ei);
    }
}

