/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobalSIMD;
import ffx.numerics.multipole.EwaldTensorGlobal;
import ffx.numerics.multipole.Operator;
import ffx.numerics.special.Erf;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.util.FastMath;

public class EwaldTensorGlobalSIMD
extends CoulombTensorGlobalSIMD {
    private static final double sqrtPI = FastMath.sqrt((double)Math.PI);
    private final double[] ewaldSource;
    private final double[] work;
    private final double beta;

    public EwaldTensorGlobalSIMD(int order, double beta) {
        super(order);
        this.beta = beta;
        this.operator = Operator.SCREENED_COULOMB;
        this.ewaldSource = new double[this.o1];
        this.work = new double[this.o1];
        EwaldTensorGlobal.initEwaldSource(order, beta, this.ewaldSource);
    }

    @Override
    protected void source(DoubleVector[] T000) {
        if (this.beta > 0.0) {
            EwaldTensorGlobalSIMD.fillEwaldSource(this.order, this.beta, this.ewaldSource, this.R, T000, this.work);
        } else {
            super.source(T000);
        }
    }

    protected static void fillEwaldSource(int order, double beta, double[] ewaldSource, DoubleVector R, DoubleVector[] T000, double[] work) {
        DoubleVector betaR = R.mul(beta);
        DoubleVector betaR2 = betaR.mul((Vector)betaR);
        DoubleVector iBetaR2 = DoubleVector.broadcast((VectorSpecies)R.species(), (double)1.0);
        iBetaR2 = iBetaR2.div((Vector)betaR2.mul(2.0));
        DoubleVector expBR2 = betaR2.neg().lanewise(VectorOperators.EXP);
        betaR.intoArray(work, 0);
        for (int i = 0; i < R.length(); ++i) {
            work[i] = Erf.erfc(work[i]);
        }
        DoubleVector Fnc = DoubleVector.fromArray((VectorSpecies)R.species(), (double[])work, (int)0);
        Fnc = Fnc.mul(sqrtPI).div((Vector)betaR.mul(2.0));
        for (int n = 0; n <= order; ++n) {
            T000[n] = Fnc.mul(ewaldSource[n]);
            Fnc = Fnc.mul(2.0 * (double)n + 1.0).add((Vector)expBR2).mul((Vector)iBetaR2);
        }
    }
}

