/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobal;
import ffx.numerics.multipole.Operator;
import ffx.numerics.special.Erf;
import org.apache.commons.math3.util.FastMath;

public class EwaldTensorGlobal
extends CoulombTensorGlobal {
    private static final double sqrtPI = FastMath.sqrt((double)Math.PI);
    private final double[] ewaldSource;
    private final double beta;

    public EwaldTensorGlobal(int order, double beta) {
        super(order);
        this.beta = beta;
        this.operator = Operator.SCREENED_COULOMB;
        this.ewaldSource = new double[this.o1];
        EwaldTensorGlobal.initEwaldSource(order, beta, this.ewaldSource);
    }

    protected static double[] initEwaldSource(int order, double beta, double[] ewaldSource) {
        double prefactor = 2.0 * beta / sqrtPI;
        double twoBeta2 = -2.0 * beta * beta;
        for (int n = 0; n <= order; ++n) {
            ewaldSource[n] = prefactor * FastMath.pow((double)twoBeta2, (int)n);
        }
        return ewaldSource;
    }

    @Override
    protected void source(double[] T000) {
        if (this.beta > 0.0) {
            EwaldTensorGlobal.fillEwaldSource(this.order, this.beta, this.ewaldSource, this.R, T000);
        } else {
            super.source(T000);
        }
    }

    protected static void fillEwaldSource(int order, double beta, double[] ewaldSource, double R, double[] T000) {
        double betaR = beta * R;
        double betaR2 = betaR * betaR;
        double iBetaR2 = 1.0 / (2.0 * betaR2);
        double expBR2 = FastMath.exp((double)(-betaR2));
        double Fnc = sqrtPI * Erf.erfc(betaR) / (2.0 * betaR);
        for (int n = 0; n <= order; ++n) {
            T000[n] = ewaldSource[n] * Fnc;
            Fnc = ((2.0 * (double)n + 1.0) * Fnc + expBR2) * iBetaR2;
        }
    }
}

