/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoordinateSystem;
import ffx.numerics.multipole.MultipoleTensorSIMD;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class CoulombTensorGlobalSIMD
extends MultipoleTensorSIMD {
    public CoulombTensorGlobalSIMD(int order) {
        super(CoordinateSystem.GLOBAL, order);
        this.operator = Operator.COULOMB;
    }

    @Override
    public void setR(DoubleVector dx, DoubleVector dy, DoubleVector dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
        DoubleVector x2 = this.x.mul((Vector)this.x);
        DoubleVector y2 = this.y.mul((Vector)this.y);
        DoubleVector z2 = this.z.mul((Vector)this.z);
        this.r2 = x2.add((Vector)y2).add((Vector)z2);
        this.R = this.r2.sqrt();
    }

    @Override
    protected void source(DoubleVector[] T000) {
        DoubleVector ONE = DoubleVector.broadcast((VectorSpecies)this.R.species(), (double)1.0);
        DoubleVector ir = ONE.div((Vector)this.R);
        DoubleVector ir2 = ir.mul((Vector)ir);
        for (int n = 0; n < this.o1; ++n) {
            T000[n] = ir.mul(this.coulombSource[n]);
            ir = ir.mul((Vector)ir2);
        }
    }

    @Override
    protected void order1() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        this.R000 = term0000;
        this.R100 = this.x.mul((Vector)term0001);
        this.R010 = this.y.mul((Vector)term0001);
        this.R001 = this.z.mul((Vector)term0001);
    }

    @Override
    protected void order2() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        this.R000 = term0000;
        this.R100 = this.x.mul((Vector)term0001);
        DoubleVector term1001 = this.x.mul((Vector)term0002);
        this.R200 = this.x.fma((Vector)term1001, (Vector)term0001);
        this.R010 = this.y.mul((Vector)term0001);
        DoubleVector term0101 = this.y.mul((Vector)term0002);
        this.R020 = this.y.fma((Vector)term0101, (Vector)term0001);
        this.R110 = this.y.mul((Vector)term1001);
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        this.R011 = this.z.mul((Vector)term0101);
        this.R101 = this.z.mul((Vector)term1001);
    }

    @Override
    protected void order3() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        this.R000 = term0000;
        this.R100 = this.x.mul((Vector)term0001);
        DoubleVector term1001 = this.x.mul((Vector)term0002);
        this.R200 = this.x.fma((Vector)term1001, (Vector)term0001);
        DoubleVector term1002 = this.x.mul((Vector)term0003);
        DoubleVector term2001 = this.x.fma((Vector)term1002, (Vector)term0002);
        this.R300 = this.x.fma((Vector)term2001, (Vector)term1001.mul(2.0));
        this.R010 = this.y.mul((Vector)term0001);
        DoubleVector term0101 = this.y.mul((Vector)term0002);
        this.R020 = this.y.fma((Vector)term0101, (Vector)term0001);
        DoubleVector term0102 = this.y.mul((Vector)term0003);
        DoubleVector term0201 = this.y.fma((Vector)term0102, (Vector)term0002);
        this.R030 = this.y.fma((Vector)term0201, (Vector)term0101.mul(2.0));
        this.R110 = this.y.mul((Vector)term1001);
        DoubleVector term1101 = this.y.mul((Vector)term1002);
        this.R120 = this.y.fma((Vector)term1101, (Vector)term1001);
        this.R210 = this.y.mul((Vector)term2001);
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        this.R011 = this.z.mul((Vector)term0101);
        DoubleVector term0111 = this.z.mul((Vector)term0102);
        this.R012 = this.z.fma((Vector)term0111, (Vector)term0101);
        this.R021 = this.z.mul((Vector)term0201);
        this.R101 = this.z.mul((Vector)term1001);
        DoubleVector term1011 = this.z.mul((Vector)term1002);
        this.R102 = this.z.fma((Vector)term1011, (Vector)term1001);
        this.R111 = this.z.mul((Vector)term1101);
        this.R201 = this.z.mul((Vector)term2001);
    }

    @Override
    protected void order4() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        DoubleVector term0004 = this.work[4];
        this.R000 = term0000;
        this.R100 = this.x.mul((Vector)term0001);
        DoubleVector term1001 = this.x.mul((Vector)term0002);
        this.R200 = this.x.fma((Vector)term1001, (Vector)term0001);
        DoubleVector term1002 = this.x.mul((Vector)term0003);
        DoubleVector term2001 = this.x.fma((Vector)term1002, (Vector)term0002);
        this.R300 = this.x.fma((Vector)term2001, (Vector)term1001.mul(2.0));
        DoubleVector term1003 = this.x.mul((Vector)term0004);
        DoubleVector term2002 = this.x.fma((Vector)term1003, (Vector)term0003);
        DoubleVector term3001 = this.x.fma((Vector)term2002, (Vector)term1002.mul(2.0));
        this.R400 = this.x.fma((Vector)term3001, (Vector)term2001.mul(3.0));
        this.R010 = this.y.mul((Vector)term0001);
        DoubleVector term0101 = this.y.mul((Vector)term0002);
        this.R020 = this.y.fma((Vector)term0101, (Vector)term0001);
        DoubleVector term0102 = this.y.mul((Vector)term0003);
        DoubleVector term0201 = this.y.fma((Vector)term0102, (Vector)term0002);
        this.R030 = this.y.fma((Vector)term0201, (Vector)term0101.mul(2.0));
        DoubleVector term0103 = this.y.mul((Vector)term0004);
        DoubleVector term0202 = this.y.fma((Vector)term0103, (Vector)term0003);
        DoubleVector term0301 = this.y.fma((Vector)term0202, (Vector)term0102.mul(2.0));
        this.R040 = this.y.fma((Vector)term0301, (Vector)term0201.mul(3.0));
        this.R110 = this.y.mul((Vector)term1001);
        DoubleVector term1101 = this.y.mul((Vector)term1002);
        this.R120 = this.y.fma((Vector)term1101, (Vector)term1001);
        DoubleVector term1102 = this.y.mul((Vector)term1003);
        DoubleVector term1201 = this.y.fma((Vector)term1102, (Vector)term1002);
        this.R130 = this.y.fma((Vector)term1201, (Vector)term1101.mul(2.0));
        this.R210 = this.y.mul((Vector)term2001);
        DoubleVector term2101 = this.y.mul((Vector)term2002);
        this.R220 = this.y.fma((Vector)term2101, (Vector)term2001);
        this.R310 = this.y.mul((Vector)term3001);
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        DoubleVector term0013 = this.z.mul((Vector)term0004);
        DoubleVector term0022 = this.z.fma((Vector)term0013, (Vector)term0003);
        DoubleVector term0031 = this.z.fma((Vector)term0022, (Vector)term0012.mul(2.0));
        this.R004 = this.z.fma((Vector)term0031, (Vector)term0021.mul(3.0));
        this.R011 = this.z.mul((Vector)term0101);
        DoubleVector term0111 = this.z.mul((Vector)term0102);
        this.R012 = this.z.fma((Vector)term0111, (Vector)term0101);
        DoubleVector term0112 = this.z.mul((Vector)term0103);
        DoubleVector term0121 = this.z.fma((Vector)term0112, (Vector)term0102);
        this.R013 = this.z.fma((Vector)term0121, (Vector)term0111.mul(2.0));
        this.R021 = this.z.mul((Vector)term0201);
        DoubleVector term0211 = this.z.mul((Vector)term0202);
        this.R022 = this.z.fma((Vector)term0211, (Vector)term0201);
        this.R031 = this.z.mul((Vector)term0301);
        this.R101 = this.z.mul((Vector)term1001);
        DoubleVector term1011 = this.z.mul((Vector)term1002);
        this.R102 = this.z.fma((Vector)term1011, (Vector)term1001);
        DoubleVector term1012 = this.z.mul((Vector)term1003);
        DoubleVector term1021 = this.z.fma((Vector)term1012, (Vector)term1002);
        this.R103 = this.z.fma((Vector)term1021, (Vector)term1011.mul(2.0));
        this.R111 = this.z.mul((Vector)term1101);
        DoubleVector term1111 = this.z.mul((Vector)term1102);
        this.R112 = this.z.fma((Vector)term1111, (Vector)term1101);
        this.R121 = this.z.mul((Vector)term1201);
        this.R201 = this.z.mul((Vector)term2001);
        DoubleVector term2011 = this.z.mul((Vector)term2002);
        this.R202 = this.z.fma((Vector)term2011, (Vector)term2001);
        this.R211 = this.z.mul((Vector)term2101);
        this.R301 = this.z.mul((Vector)term3001);
    }

    @Override
    protected void order5() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        DoubleVector term0004 = this.work[4];
        DoubleVector term0005 = this.work[5];
        this.R000 = term0000;
        this.R100 = this.x.mul((Vector)term0001);
        DoubleVector term1001 = this.x.mul((Vector)term0002);
        this.R200 = this.x.fma((Vector)term1001, (Vector)term0001);
        DoubleVector term1002 = this.x.mul((Vector)term0003);
        DoubleVector term2001 = this.x.fma((Vector)term1002, (Vector)term0002);
        this.R300 = this.x.fma((Vector)term2001, (Vector)term1001.mul(2.0));
        DoubleVector term1003 = this.x.mul((Vector)term0004);
        DoubleVector term2002 = this.x.fma((Vector)term1003, (Vector)term0003);
        DoubleVector term3001 = this.x.fma((Vector)term2002, (Vector)term1002.mul(2.0));
        this.R400 = this.x.fma((Vector)term3001, (Vector)term2001.mul(3.0));
        DoubleVector term1004 = this.x.mul((Vector)term0005);
        DoubleVector term2003 = this.x.fma((Vector)term1004, (Vector)term0004);
        DoubleVector term3002 = this.x.fma((Vector)term2003, (Vector)term1003.mul(2.0));
        DoubleVector term4001 = this.x.fma((Vector)term3002, (Vector)term2002.mul(3.0));
        this.R500 = this.x.fma((Vector)term4001, (Vector)term3001.mul(4.0));
        this.R010 = this.y.mul((Vector)term0001);
        DoubleVector term0101 = this.y.mul((Vector)term0002);
        this.R020 = this.y.fma((Vector)term0101, (Vector)term0001);
        DoubleVector term0102 = this.y.mul((Vector)term0003);
        DoubleVector term0201 = this.y.fma((Vector)term0102, (Vector)term0002);
        this.R030 = this.y.fma((Vector)term0201, (Vector)term0101.mul(2.0));
        DoubleVector term0103 = this.y.mul((Vector)term0004);
        DoubleVector term0202 = this.y.fma((Vector)term0103, (Vector)term0003);
        DoubleVector term0301 = this.y.fma((Vector)term0202, (Vector)term0102.mul(2.0));
        this.R040 = this.y.fma((Vector)term0301, (Vector)term0201.mul(3.0));
        DoubleVector term0104 = this.y.mul((Vector)term0005);
        DoubleVector term0203 = this.y.fma((Vector)term0104, (Vector)term0004);
        DoubleVector term0302 = this.y.fma((Vector)term0203, (Vector)term0103.mul(2.0));
        DoubleVector term0401 = this.y.fma((Vector)term0302, (Vector)term0202.mul(3.0));
        this.R050 = this.y.fma((Vector)term0401, (Vector)term0301.mul(4.0));
        this.R110 = this.y.mul((Vector)term1001);
        DoubleVector term1101 = this.y.mul((Vector)term1002);
        this.R120 = this.y.fma((Vector)term1101, (Vector)term1001);
        DoubleVector term1102 = this.y.mul((Vector)term1003);
        DoubleVector term1201 = this.y.fma((Vector)term1102, (Vector)term1002);
        this.R130 = this.y.fma((Vector)term1201, (Vector)term1101.mul(2.0));
        DoubleVector term1103 = this.y.mul((Vector)term1004);
        DoubleVector term1202 = this.y.fma((Vector)term1103, (Vector)term1003);
        DoubleVector term1301 = this.y.fma((Vector)term1202, (Vector)term1102.mul(2.0));
        this.R140 = this.y.fma((Vector)term1301, (Vector)term1201.mul(3.0));
        this.R210 = this.y.mul((Vector)term2001);
        DoubleVector term2101 = this.y.mul((Vector)term2002);
        this.R220 = this.y.fma((Vector)term2101, (Vector)term2001);
        DoubleVector term2102 = this.y.mul((Vector)term2003);
        DoubleVector term2201 = this.y.fma((Vector)term2102, (Vector)term2002);
        this.R230 = this.y.fma((Vector)term2201, (Vector)term2101.mul(2.0));
        this.R310 = this.y.mul((Vector)term3001);
        DoubleVector term3101 = this.y.mul((Vector)term3002);
        this.R320 = this.y.fma((Vector)term3101, (Vector)term3001);
        this.R410 = this.y.mul((Vector)term4001);
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        DoubleVector term0013 = this.z.mul((Vector)term0004);
        DoubleVector term0022 = this.z.fma((Vector)term0013, (Vector)term0003);
        DoubleVector term0031 = this.z.fma((Vector)term0022, (Vector)term0012.mul(2.0));
        this.R004 = this.z.fma((Vector)term0031, (Vector)term0021.mul(3.0));
        DoubleVector term0014 = this.z.mul((Vector)term0005);
        DoubleVector term0023 = this.z.fma((Vector)term0014, (Vector)term0004);
        DoubleVector term0032 = this.z.fma((Vector)term0023, (Vector)term0013.mul(2.0));
        DoubleVector term0041 = this.z.fma((Vector)term0032, (Vector)term0022.mul(3.0));
        this.R005 = this.z.fma((Vector)term0041, (Vector)term0031.mul(4.0));
        this.R011 = this.z.mul((Vector)term0101);
        DoubleVector term0111 = this.z.mul((Vector)term0102);
        this.R012 = this.z.fma((Vector)term0111, (Vector)term0101);
        DoubleVector term0112 = this.z.mul((Vector)term0103);
        DoubleVector term0121 = this.z.fma((Vector)term0112, (Vector)term0102);
        this.R013 = this.z.fma((Vector)term0121, (Vector)term0111.mul(2.0));
        DoubleVector term0113 = this.z.mul((Vector)term0104);
        DoubleVector term0122 = this.z.fma((Vector)term0113, (Vector)term0103);
        DoubleVector term0131 = this.z.fma((Vector)term0122, (Vector)term0112.mul(2.0));
        this.R014 = this.z.fma((Vector)term0131, (Vector)term0121.mul(3.0));
        this.R021 = this.z.mul((Vector)term0201);
        DoubleVector term0211 = this.z.mul((Vector)term0202);
        this.R022 = this.z.fma((Vector)term0211, (Vector)term0201);
        DoubleVector term0212 = this.z.mul((Vector)term0203);
        DoubleVector term0221 = this.z.fma((Vector)term0212, (Vector)term0202);
        this.R023 = this.z.fma((Vector)term0221, (Vector)term0211.mul(2.0));
        this.R031 = this.z.mul((Vector)term0301);
        DoubleVector term0311 = this.z.mul((Vector)term0302);
        this.R032 = this.z.fma((Vector)term0311, (Vector)term0301);
        this.R041 = this.z.mul((Vector)term0401);
        this.R101 = this.z.mul((Vector)term1001);
        DoubleVector term1011 = this.z.mul((Vector)term1002);
        this.R102 = this.z.fma((Vector)term1011, (Vector)term1001);
        DoubleVector term1012 = this.z.mul((Vector)term1003);
        DoubleVector term1021 = this.z.fma((Vector)term1012, (Vector)term1002);
        this.R103 = this.z.fma((Vector)term1021, (Vector)term1011.mul(2.0));
        DoubleVector term1013 = this.z.mul((Vector)term1004);
        DoubleVector term1022 = this.z.fma((Vector)term1013, (Vector)term1003);
        DoubleVector term1031 = this.z.fma((Vector)term1022, (Vector)term1012.mul(2.0));
        this.R104 = this.z.fma((Vector)term1031, (Vector)term1021.mul(3.0));
        this.R111 = this.z.mul((Vector)term1101);
        DoubleVector term1111 = this.z.mul((Vector)term1102);
        this.R112 = this.z.fma((Vector)term1111, (Vector)term1101);
        DoubleVector term1112 = this.z.mul((Vector)term1103);
        DoubleVector term1121 = this.z.fma((Vector)term1112, (Vector)term1102);
        this.R113 = this.z.fma((Vector)term1121, (Vector)term1111.mul(2.0));
        this.R121 = this.z.mul((Vector)term1201);
        DoubleVector term1211 = this.z.mul((Vector)term1202);
        this.R122 = this.z.fma((Vector)term1211, (Vector)term1201);
        this.R131 = this.z.mul((Vector)term1301);
        this.R201 = this.z.mul((Vector)term2001);
        DoubleVector term2011 = this.z.mul((Vector)term2002);
        this.R202 = this.z.fma((Vector)term2011, (Vector)term2001);
        DoubleVector term2012 = this.z.mul((Vector)term2003);
        DoubleVector term2021 = this.z.fma((Vector)term2012, (Vector)term2002);
        this.R203 = this.z.fma((Vector)term2021, (Vector)term2011.mul(2.0));
        this.R211 = this.z.mul((Vector)term2101);
        DoubleVector term2111 = this.z.mul((Vector)term2102);
        this.R212 = this.z.fma((Vector)term2111, (Vector)term2101);
        this.R221 = this.z.mul((Vector)term2201);
        this.R301 = this.z.mul((Vector)term3001);
        DoubleVector term3011 = this.z.mul((Vector)term3002);
        this.R302 = this.z.fma((Vector)term3011, (Vector)term3001);
        this.R311 = this.z.mul((Vector)term3101);
        this.R401 = this.z.mul((Vector)term4001);
    }

    @Override
    protected void order6() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        DoubleVector term0004 = this.work[4];
        DoubleVector term0005 = this.work[5];
        DoubleVector term0006 = this.work[6];
        this.R000 = term0000;
        this.R100 = this.x.mul((Vector)term0001);
        DoubleVector term1001 = this.x.mul((Vector)term0002);
        this.R200 = this.x.fma((Vector)term1001, (Vector)term0001);
        DoubleVector term1002 = this.x.mul((Vector)term0003);
        DoubleVector term2001 = this.x.fma((Vector)term1002, (Vector)term0002);
        this.R300 = this.x.fma((Vector)term2001, (Vector)term1001.mul(2.0));
        DoubleVector term1003 = this.x.mul((Vector)term0004);
        DoubleVector term2002 = this.x.fma((Vector)term1003, (Vector)term0003);
        DoubleVector term3001 = this.x.fma((Vector)term2002, (Vector)term1002.mul(2.0));
        this.R400 = this.x.fma((Vector)term3001, (Vector)term2001.mul(3.0));
        DoubleVector term1004 = this.x.mul((Vector)term0005);
        DoubleVector term2003 = this.x.fma((Vector)term1004, (Vector)term0004);
        DoubleVector term3002 = this.x.fma((Vector)term2003, (Vector)term1003.mul(2.0));
        DoubleVector term4001 = this.x.fma((Vector)term3002, (Vector)term2002.mul(3.0));
        this.R500 = this.x.fma((Vector)term4001, (Vector)term3001.mul(4.0));
        DoubleVector term1005 = this.x.mul((Vector)term0006);
        DoubleVector term2004 = this.x.fma((Vector)term1005, (Vector)term0005);
        DoubleVector term3003 = this.x.fma((Vector)term2004, (Vector)term1004.mul(2.0));
        DoubleVector term4002 = this.x.fma((Vector)term3003, (Vector)term2003.mul(3.0));
        DoubleVector term5001 = this.x.fma((Vector)term4002, (Vector)term3002.mul(4.0));
        this.R600 = this.x.fma((Vector)term5001, (Vector)term4001.mul(5.0));
        this.R010 = this.y.mul((Vector)term0001);
        DoubleVector term0101 = this.y.mul((Vector)term0002);
        this.R020 = this.y.fma((Vector)term0101, (Vector)term0001);
        DoubleVector term0102 = this.y.mul((Vector)term0003);
        DoubleVector term0201 = this.y.fma((Vector)term0102, (Vector)term0002);
        this.R030 = this.y.fma((Vector)term0201, (Vector)term0101.mul(2.0));
        DoubleVector term0103 = this.y.mul((Vector)term0004);
        DoubleVector term0202 = this.y.fma((Vector)term0103, (Vector)term0003);
        DoubleVector term0301 = this.y.fma((Vector)term0202, (Vector)term0102.mul(2.0));
        this.R040 = this.y.fma((Vector)term0301, (Vector)term0201.mul(3.0));
        DoubleVector term0104 = this.y.mul((Vector)term0005);
        DoubleVector term0203 = this.y.fma((Vector)term0104, (Vector)term0004);
        DoubleVector term0302 = this.y.fma((Vector)term0203, (Vector)term0103.mul(2.0));
        DoubleVector term0401 = this.y.fma((Vector)term0302, (Vector)term0202.mul(3.0));
        this.R050 = this.y.fma((Vector)term0401, (Vector)term0301.mul(4.0));
        DoubleVector term0105 = this.y.mul((Vector)term0006);
        DoubleVector term0204 = this.y.fma((Vector)term0105, (Vector)term0005);
        DoubleVector term0303 = this.y.fma((Vector)term0204, (Vector)term0104.mul(2.0));
        DoubleVector term0402 = this.y.fma((Vector)term0303, (Vector)term0203.mul(3.0));
        DoubleVector term0501 = this.y.fma((Vector)term0402, (Vector)term0302.mul(4.0));
        this.R060 = this.y.fma((Vector)term0501, (Vector)term0401.mul(5.0));
        this.R110 = this.y.mul((Vector)term1001);
        DoubleVector term1101 = this.y.mul((Vector)term1002);
        this.R120 = this.y.fma((Vector)term1101, (Vector)term1001);
        DoubleVector term1102 = this.y.mul((Vector)term1003);
        DoubleVector term1201 = this.y.fma((Vector)term1102, (Vector)term1002);
        this.R130 = this.y.fma((Vector)term1201, (Vector)term1101.mul(2.0));
        DoubleVector term1103 = this.y.mul((Vector)term1004);
        DoubleVector term1202 = this.y.fma((Vector)term1103, (Vector)term1003);
        DoubleVector term1301 = this.y.fma((Vector)term1202, (Vector)term1102.mul(2.0));
        this.R140 = this.y.fma((Vector)term1301, (Vector)term1201.mul(3.0));
        DoubleVector term1104 = this.y.mul((Vector)term1005);
        DoubleVector term1203 = this.y.fma((Vector)term1104, (Vector)term1004);
        DoubleVector term1302 = this.y.fma((Vector)term1203, (Vector)term1103.mul(2.0));
        DoubleVector term1401 = this.y.fma((Vector)term1302, (Vector)term1202.mul(3.0));
        this.R150 = this.y.fma((Vector)term1401, (Vector)term1301.mul(4.0));
        this.R210 = this.y.mul((Vector)term2001);
        DoubleVector term2101 = this.y.mul((Vector)term2002);
        this.R220 = this.y.fma((Vector)term2101, (Vector)term2001);
        DoubleVector term2102 = this.y.mul((Vector)term2003);
        DoubleVector term2201 = this.y.fma((Vector)term2102, (Vector)term2002);
        this.R230 = this.y.fma((Vector)term2201, (Vector)term2101.mul(2.0));
        DoubleVector term2103 = this.y.mul((Vector)term2004);
        DoubleVector term2202 = this.y.fma((Vector)term2103, (Vector)term2003);
        DoubleVector term2301 = this.y.fma((Vector)term2202, (Vector)term2102.mul(2.0));
        this.R240 = this.y.fma((Vector)term2301, (Vector)term2201.mul(3.0));
        this.R310 = this.y.mul((Vector)term3001);
        DoubleVector term3101 = this.y.mul((Vector)term3002);
        this.R320 = this.y.fma((Vector)term3101, (Vector)term3001);
        DoubleVector term3102 = this.y.mul((Vector)term3003);
        DoubleVector term3201 = this.y.fma((Vector)term3102, (Vector)term3002);
        this.R330 = this.y.fma((Vector)term3201, (Vector)term3101.mul(2.0));
        this.R410 = this.y.mul((Vector)term4001);
        DoubleVector term4101 = this.y.mul((Vector)term4002);
        this.R420 = this.y.fma((Vector)term4101, (Vector)term4001);
        this.R510 = this.y.mul((Vector)term5001);
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        DoubleVector term0013 = this.z.mul((Vector)term0004);
        DoubleVector term0022 = this.z.fma((Vector)term0013, (Vector)term0003);
        DoubleVector term0031 = this.z.fma((Vector)term0022, (Vector)term0012.mul(2.0));
        this.R004 = this.z.fma((Vector)term0031, (Vector)term0021.mul(3.0));
        DoubleVector term0014 = this.z.mul((Vector)term0005);
        DoubleVector term0023 = this.z.fma((Vector)term0014, (Vector)term0004);
        DoubleVector term0032 = this.z.fma((Vector)term0023, (Vector)term0013.mul(2.0));
        DoubleVector term0041 = this.z.fma((Vector)term0032, (Vector)term0022.mul(3.0));
        this.R005 = this.z.fma((Vector)term0041, (Vector)term0031.mul(4.0));
        DoubleVector term0015 = this.z.mul((Vector)term0006);
        DoubleVector term0024 = this.z.fma((Vector)term0015, (Vector)term0005);
        DoubleVector term0033 = this.z.fma((Vector)term0024, (Vector)term0014.mul(2.0));
        DoubleVector term0042 = this.z.fma((Vector)term0033, (Vector)term0023.mul(3.0));
        DoubleVector term0051 = this.z.fma((Vector)term0042, (Vector)term0032.mul(4.0));
        this.R006 = this.z.fma((Vector)term0051, (Vector)term0041.mul(5.0));
        this.R011 = this.z.mul((Vector)term0101);
        DoubleVector term0111 = this.z.mul((Vector)term0102);
        this.R012 = this.z.fma((Vector)term0111, (Vector)term0101);
        DoubleVector term0112 = this.z.mul((Vector)term0103);
        DoubleVector term0121 = this.z.fma((Vector)term0112, (Vector)term0102);
        this.R013 = this.z.fma((Vector)term0121, (Vector)term0111.mul(2.0));
        DoubleVector term0113 = this.z.mul((Vector)term0104);
        DoubleVector term0122 = this.z.fma((Vector)term0113, (Vector)term0103);
        DoubleVector term0131 = this.z.fma((Vector)term0122, (Vector)term0112.mul(2.0));
        this.R014 = this.z.fma((Vector)term0131, (Vector)term0121.mul(3.0));
        DoubleVector term0114 = this.z.mul((Vector)term0105);
        DoubleVector term0123 = this.z.fma((Vector)term0114, (Vector)term0104);
        DoubleVector term0132 = this.z.fma((Vector)term0123, (Vector)term0113.mul(2.0));
        DoubleVector term0141 = this.z.fma((Vector)term0132, (Vector)term0122.mul(3.0));
        this.R015 = this.z.fma((Vector)term0141, (Vector)term0131.mul(4.0));
        this.R021 = this.z.mul((Vector)term0201);
        DoubleVector term0211 = this.z.mul((Vector)term0202);
        this.R022 = this.z.fma((Vector)term0211, (Vector)term0201);
        DoubleVector term0212 = this.z.mul((Vector)term0203);
        DoubleVector term0221 = this.z.fma((Vector)term0212, (Vector)term0202);
        this.R023 = this.z.fma((Vector)term0221, (Vector)term0211.mul(2.0));
        DoubleVector term0213 = this.z.mul((Vector)term0204);
        DoubleVector term0222 = this.z.fma((Vector)term0213, (Vector)term0203);
        DoubleVector term0231 = this.z.fma((Vector)term0222, (Vector)term0212.mul(2.0));
        this.R024 = this.z.fma((Vector)term0231, (Vector)term0221.mul(3.0));
        this.R031 = this.z.mul((Vector)term0301);
        DoubleVector term0311 = this.z.mul((Vector)term0302);
        this.R032 = this.z.fma((Vector)term0311, (Vector)term0301);
        DoubleVector term0312 = this.z.mul((Vector)term0303);
        DoubleVector term0321 = this.z.fma((Vector)term0312, (Vector)term0302);
        this.R033 = this.z.fma((Vector)term0321, (Vector)term0311.mul(2.0));
        this.R041 = this.z.mul((Vector)term0401);
        DoubleVector term0411 = this.z.mul((Vector)term0402);
        this.R042 = this.z.fma((Vector)term0411, (Vector)term0401);
        this.R051 = this.z.mul((Vector)term0501);
        this.R101 = this.z.mul((Vector)term1001);
        DoubleVector term1011 = this.z.mul((Vector)term1002);
        this.R102 = this.z.fma((Vector)term1011, (Vector)term1001);
        DoubleVector term1012 = this.z.mul((Vector)term1003);
        DoubleVector term1021 = this.z.fma((Vector)term1012, (Vector)term1002);
        this.R103 = this.z.fma((Vector)term1021, (Vector)term1011.mul(2.0));
        DoubleVector term1013 = this.z.mul((Vector)term1004);
        DoubleVector term1022 = this.z.fma((Vector)term1013, (Vector)term1003);
        DoubleVector term1031 = this.z.fma((Vector)term1022, (Vector)term1012.mul(2.0));
        this.R104 = this.z.fma((Vector)term1031, (Vector)term1021.mul(3.0));
        DoubleVector term1014 = this.z.mul((Vector)term1005);
        DoubleVector term1023 = this.z.fma((Vector)term1014, (Vector)term1004);
        DoubleVector term1032 = this.z.fma((Vector)term1023, (Vector)term1013.mul(2.0));
        DoubleVector term1041 = this.z.fma((Vector)term1032, (Vector)term1022.mul(3.0));
        this.R105 = this.z.fma((Vector)term1041, (Vector)term1031.mul(4.0));
        this.R111 = this.z.mul((Vector)term1101);
        DoubleVector term1111 = this.z.mul((Vector)term1102);
        this.R112 = this.z.fma((Vector)term1111, (Vector)term1101);
        DoubleVector term1112 = this.z.mul((Vector)term1103);
        DoubleVector term1121 = this.z.fma((Vector)term1112, (Vector)term1102);
        this.R113 = this.z.fma((Vector)term1121, (Vector)term1111.mul(2.0));
        DoubleVector term1113 = this.z.mul((Vector)term1104);
        DoubleVector term1122 = this.z.fma((Vector)term1113, (Vector)term1103);
        DoubleVector term1131 = this.z.fma((Vector)term1122, (Vector)term1112.mul(2.0));
        this.R114 = this.z.fma((Vector)term1131, (Vector)term1121.mul(3.0));
        this.R121 = this.z.mul((Vector)term1201);
        DoubleVector term1211 = this.z.mul((Vector)term1202);
        this.R122 = this.z.fma((Vector)term1211, (Vector)term1201);
        DoubleVector term1212 = this.z.mul((Vector)term1203);
        DoubleVector term1221 = this.z.fma((Vector)term1212, (Vector)term1202);
        this.R123 = this.z.fma((Vector)term1221, (Vector)term1211.mul(2.0));
        this.R131 = this.z.mul((Vector)term1301);
        DoubleVector term1311 = this.z.mul((Vector)term1302);
        this.R132 = this.z.fma((Vector)term1311, (Vector)term1301);
        this.R141 = this.z.mul((Vector)term1401);
        this.R201 = this.z.mul((Vector)term2001);
        DoubleVector term2011 = this.z.mul((Vector)term2002);
        this.R202 = this.z.fma((Vector)term2011, (Vector)term2001);
        DoubleVector term2012 = this.z.mul((Vector)term2003);
        DoubleVector term2021 = this.z.fma((Vector)term2012, (Vector)term2002);
        this.R203 = this.z.fma((Vector)term2021, (Vector)term2011.mul(2.0));
        DoubleVector term2013 = this.z.mul((Vector)term2004);
        DoubleVector term2022 = this.z.fma((Vector)term2013, (Vector)term2003);
        DoubleVector term2031 = this.z.fma((Vector)term2022, (Vector)term2012.mul(2.0));
        this.R204 = this.z.fma((Vector)term2031, (Vector)term2021.mul(3.0));
        this.R211 = this.z.mul((Vector)term2101);
        DoubleVector term2111 = this.z.mul((Vector)term2102);
        this.R212 = this.z.fma((Vector)term2111, (Vector)term2101);
        DoubleVector term2112 = this.z.mul((Vector)term2103);
        DoubleVector term2121 = this.z.fma((Vector)term2112, (Vector)term2102);
        this.R213 = this.z.fma((Vector)term2121, (Vector)term2111.mul(2.0));
        this.R221 = this.z.mul((Vector)term2201);
        DoubleVector term2211 = this.z.mul((Vector)term2202);
        this.R222 = this.z.fma((Vector)term2211, (Vector)term2201);
        this.R231 = this.z.mul((Vector)term2301);
        this.R301 = this.z.mul((Vector)term3001);
        DoubleVector term3011 = this.z.mul((Vector)term3002);
        this.R302 = this.z.fma((Vector)term3011, (Vector)term3001);
        DoubleVector term3012 = this.z.mul((Vector)term3003);
        DoubleVector term3021 = this.z.fma((Vector)term3012, (Vector)term3002);
        this.R303 = this.z.fma((Vector)term3021, (Vector)term3011.mul(2.0));
        this.R311 = this.z.mul((Vector)term3101);
        DoubleVector term3111 = this.z.mul((Vector)term3102);
        this.R312 = this.z.fma((Vector)term3111, (Vector)term3101);
        this.R321 = this.z.mul((Vector)term3201);
        this.R401 = this.z.mul((Vector)term4001);
        DoubleVector term4011 = this.z.mul((Vector)term4002);
        this.R402 = this.z.fma((Vector)term4011, (Vector)term4001);
        this.R411 = this.z.mul((Vector)term4101);
        this.R501 = this.z.mul((Vector)term5001);
    }

    @Override
    protected void multipoleKPotentialAtI(PolarizableMultipoleSIMD mK, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = mK.q.mul((Vector)this.R300);
                term300 = mK.dx.fma((Vector)this.R400, (Vector)term300);
                term300 = mK.dy.fma((Vector)this.R310, (Vector)term300);
                term300 = mK.dz.fma((Vector)this.R301, (Vector)term300);
                term300 = mK.qxx.fma((Vector)this.R500, (Vector)term300);
                term300 = mK.qyy.fma((Vector)this.R320, (Vector)term300);
                term300 = mK.qzz.fma((Vector)this.R302, (Vector)term300);
                term300 = mK.qxy.fma((Vector)this.R410, (Vector)term300);
                term300 = mK.qxz.fma((Vector)this.R401, (Vector)term300);
                term300 = mK.qyz.fma((Vector)this.R311, (Vector)term300);
                this.E300 = term300.neg();
                DoubleVector term030 = mK.q.mul((Vector)this.R030);
                term030 = mK.dx.fma((Vector)this.R130, (Vector)term030);
                term030 = mK.dy.fma((Vector)this.R040, (Vector)term030);
                term030 = mK.dz.fma((Vector)this.R031, (Vector)term030);
                term030 = mK.qxx.fma((Vector)this.R230, (Vector)term030);
                term030 = mK.qyy.fma((Vector)this.R050, (Vector)term030);
                term030 = mK.qzz.fma((Vector)this.R032, (Vector)term030);
                term030 = mK.qxy.fma((Vector)this.R140, (Vector)term030);
                term030 = mK.qxz.fma((Vector)this.R131, (Vector)term030);
                term030 = mK.qyz.fma((Vector)this.R041, (Vector)term030);
                this.E030 = term030.neg();
                DoubleVector term003 = mK.q.mul((Vector)this.R003);
                term003 = mK.dx.fma((Vector)this.R103, (Vector)term003);
                term003 = mK.dy.fma((Vector)this.R013, (Vector)term003);
                term003 = mK.dz.fma((Vector)this.R004, (Vector)term003);
                term003 = mK.qxx.fma((Vector)this.R203, (Vector)term003);
                term003 = mK.qyy.fma((Vector)this.R023, (Vector)term003);
                term003 = mK.qzz.fma((Vector)this.R005, (Vector)term003);
                term003 = mK.qxy.fma((Vector)this.R113, (Vector)term003);
                term003 = mK.qxz.fma((Vector)this.R104, (Vector)term003);
                term003 = mK.qyz.fma((Vector)this.R014, (Vector)term003);
                this.E003 = term003.neg();
                DoubleVector term210 = mK.q.mul((Vector)this.R210);
                term210 = mK.dx.fma((Vector)this.R310, (Vector)term210);
                term210 = mK.dy.fma((Vector)this.R220, (Vector)term210);
                term210 = mK.dz.fma((Vector)this.R211, (Vector)term210);
                term210 = mK.qxx.fma((Vector)this.R410, (Vector)term210);
                term210 = mK.qyy.fma((Vector)this.R230, (Vector)term210);
                term210 = mK.qzz.fma((Vector)this.R212, (Vector)term210);
                term210 = mK.qxy.fma((Vector)this.R320, (Vector)term210);
                term210 = mK.qxz.fma((Vector)this.R311, (Vector)term210);
                term210 = mK.qyz.fma((Vector)this.R221, (Vector)term210);
                this.E210 = term210.neg();
                DoubleVector term201 = mK.q.mul((Vector)this.R201);
                term201 = mK.dx.fma((Vector)this.R301, (Vector)term201);
                term201 = mK.dy.fma((Vector)this.R211, (Vector)term201);
                term201 = mK.dz.fma((Vector)this.R202, (Vector)term201);
                term201 = mK.qxx.fma((Vector)this.R401, (Vector)term201);
                term201 = mK.qyy.fma((Vector)this.R221, (Vector)term201);
                term201 = mK.qzz.fma((Vector)this.R203, (Vector)term201);
                term201 = mK.qxy.fma((Vector)this.R311, (Vector)term201);
                term201 = mK.qxz.fma((Vector)this.R302, (Vector)term201);
                term201 = mK.qyz.fma((Vector)this.R212, (Vector)term201);
                this.E201 = term201.neg();
                DoubleVector term120 = mK.q.mul((Vector)this.R120);
                term120 = mK.dx.fma((Vector)this.R220, (Vector)term120);
                term120 = mK.dy.fma((Vector)this.R130, (Vector)term120);
                term120 = mK.dz.fma((Vector)this.R121, (Vector)term120);
                term120 = mK.qxx.fma((Vector)this.R320, (Vector)term120);
                term120 = mK.qyy.fma((Vector)this.R140, (Vector)term120);
                term120 = mK.qzz.fma((Vector)this.R122, (Vector)term120);
                term120 = mK.qxy.fma((Vector)this.R230, (Vector)term120);
                term120 = mK.qxz.fma((Vector)this.R221, (Vector)term120);
                term120 = mK.qyz.fma((Vector)this.R131, (Vector)term120);
                this.E120 = term120.neg();
                DoubleVector term021 = mK.q.mul((Vector)this.R021);
                term021 = mK.dx.fma((Vector)this.R121, (Vector)term021);
                term021 = mK.dy.fma((Vector)this.R031, (Vector)term021);
                term021 = mK.dz.fma((Vector)this.R022, (Vector)term021);
                term021 = mK.qxx.fma((Vector)this.R221, (Vector)term021);
                term021 = mK.qyy.fma((Vector)this.R041, (Vector)term021);
                term021 = mK.qzz.fma((Vector)this.R023, (Vector)term021);
                term021 = mK.qxy.fma((Vector)this.R131, (Vector)term021);
                term021 = mK.qxz.fma((Vector)this.R122, (Vector)term021);
                term021 = mK.qyz.fma((Vector)this.R032, (Vector)term021);
                this.E021 = term021.neg();
                DoubleVector term102 = mK.q.mul((Vector)this.R102);
                term102 = mK.dx.fma((Vector)this.R202, (Vector)term102);
                term102 = mK.dy.fma((Vector)this.R112, (Vector)term102);
                term102 = mK.dz.fma((Vector)this.R103, (Vector)term102);
                term102 = mK.qxx.fma((Vector)this.R302, (Vector)term102);
                term102 = mK.qyy.fma((Vector)this.R122, (Vector)term102);
                term102 = mK.qzz.fma((Vector)this.R104, (Vector)term102);
                term102 = mK.qxy.fma((Vector)this.R212, (Vector)term102);
                term102 = mK.qxz.fma((Vector)this.R203, (Vector)term102);
                term102 = mK.qyz.fma((Vector)this.R113, (Vector)term102);
                this.E102 = term102.neg();
                DoubleVector term012 = mK.q.mul((Vector)this.R012);
                term012 = mK.dx.fma((Vector)this.R112, (Vector)term012);
                term012 = mK.dy.fma((Vector)this.R022, (Vector)term012);
                term012 = mK.dz.fma((Vector)this.R013, (Vector)term012);
                term012 = mK.qxx.fma((Vector)this.R212, (Vector)term012);
                term012 = mK.qyy.fma((Vector)this.R032, (Vector)term012);
                term012 = mK.qzz.fma((Vector)this.R014, (Vector)term012);
                term012 = mK.qxy.fma((Vector)this.R122, (Vector)term012);
                term012 = mK.qxz.fma((Vector)this.R113, (Vector)term012);
                term012 = mK.qyz.fma((Vector)this.R023, (Vector)term012);
                this.E012 = term012.neg();
                DoubleVector term111 = mK.q.mul((Vector)this.R111);
                term111 = mK.dx.fma((Vector)this.R211, (Vector)term111);
                term111 = mK.dy.fma((Vector)this.R121, (Vector)term111);
                term111 = mK.dz.fma((Vector)this.R112, (Vector)term111);
                term111 = mK.qxx.fma((Vector)this.R311, (Vector)term111);
                term111 = mK.qyy.fma((Vector)this.R131, (Vector)term111);
                term111 = mK.qzz.fma((Vector)this.R113, (Vector)term111);
                term111 = mK.qxy.fma((Vector)this.R221, (Vector)term111);
                term111 = mK.qxz.fma((Vector)this.R212, (Vector)term111);
                term111 = mK.qyz.fma((Vector)this.R122, (Vector)term111);
                this.E111 = term111.neg();
            }
            case 2: {
                DoubleVector term200 = mK.q.mul((Vector)this.R200);
                term200 = mK.dx.fma((Vector)this.R300, (Vector)term200);
                term200 = mK.dy.fma((Vector)this.R210, (Vector)term200);
                term200 = mK.dz.fma((Vector)this.R201, (Vector)term200);
                term200 = mK.qxx.fma((Vector)this.R400, (Vector)term200);
                term200 = mK.qyy.fma((Vector)this.R220, (Vector)term200);
                term200 = mK.qzz.fma((Vector)this.R202, (Vector)term200);
                term200 = mK.qxy.fma((Vector)this.R310, (Vector)term200);
                term200 = mK.qxz.fma((Vector)this.R301, (Vector)term200);
                this.E200 = term200 = mK.qyz.fma((Vector)this.R211, (Vector)term200);
                DoubleVector term020 = mK.q.mul((Vector)this.R020);
                term020 = mK.dx.fma((Vector)this.R120, (Vector)term020);
                term020 = mK.dy.fma((Vector)this.R030, (Vector)term020);
                term020 = mK.dz.fma((Vector)this.R021, (Vector)term020);
                term020 = mK.qxx.fma((Vector)this.R220, (Vector)term020);
                term020 = mK.qyy.fma((Vector)this.R040, (Vector)term020);
                term020 = mK.qzz.fma((Vector)this.R022, (Vector)term020);
                term020 = mK.qxy.fma((Vector)this.R130, (Vector)term020);
                term020 = mK.qxz.fma((Vector)this.R121, (Vector)term020);
                this.E020 = term020 = mK.qyz.fma((Vector)this.R031, (Vector)term020);
                DoubleVector term002 = mK.q.mul((Vector)this.R002);
                term002 = mK.dx.fma((Vector)this.R102, (Vector)term002);
                term002 = mK.dy.fma((Vector)this.R012, (Vector)term002);
                term002 = mK.dz.fma((Vector)this.R003, (Vector)term002);
                term002 = mK.qxx.fma((Vector)this.R202, (Vector)term002);
                term002 = mK.qyy.fma((Vector)this.R022, (Vector)term002);
                term002 = mK.qzz.fma((Vector)this.R004, (Vector)term002);
                term002 = mK.qxy.fma((Vector)this.R112, (Vector)term002);
                term002 = mK.qxz.fma((Vector)this.R103, (Vector)term002);
                this.E002 = term002 = mK.qyz.fma((Vector)this.R013, (Vector)term002);
                DoubleVector term110 = mK.q.mul((Vector)this.R110);
                term110 = mK.dx.fma((Vector)this.R210, (Vector)term110);
                term110 = mK.dy.fma((Vector)this.R120, (Vector)term110);
                term110 = mK.dz.fma((Vector)this.R111, (Vector)term110);
                term110 = mK.qxx.fma((Vector)this.R310, (Vector)term110);
                term110 = mK.qyy.fma((Vector)this.R130, (Vector)term110);
                term110 = mK.qzz.fma((Vector)this.R112, (Vector)term110);
                term110 = mK.qxy.fma((Vector)this.R220, (Vector)term110);
                term110 = mK.qxz.fma((Vector)this.R211, (Vector)term110);
                this.E110 = term110 = mK.qyz.fma((Vector)this.R121, (Vector)term110);
                DoubleVector term101 = mK.q.mul((Vector)this.R101);
                term101 = mK.dx.fma((Vector)this.R201, (Vector)term101);
                term101 = mK.dy.fma((Vector)this.R111, (Vector)term101);
                term101 = mK.dz.fma((Vector)this.R102, (Vector)term101);
                term101 = mK.qxx.fma((Vector)this.R301, (Vector)term101);
                term101 = mK.qyy.fma((Vector)this.R121, (Vector)term101);
                term101 = mK.qzz.fma((Vector)this.R103, (Vector)term101);
                term101 = mK.qxy.fma((Vector)this.R211, (Vector)term101);
                term101 = mK.qxz.fma((Vector)this.R202, (Vector)term101);
                this.E101 = term101 = mK.qyz.fma((Vector)this.R112, (Vector)term101);
                DoubleVector term011 = mK.q.mul((Vector)this.R011);
                term011 = mK.dx.fma((Vector)this.R111, (Vector)term011);
                term011 = mK.dy.fma((Vector)this.R021, (Vector)term011);
                term011 = mK.dz.fma((Vector)this.R012, (Vector)term011);
                term011 = mK.qxx.fma((Vector)this.R211, (Vector)term011);
                term011 = mK.qyy.fma((Vector)this.R031, (Vector)term011);
                term011 = mK.qzz.fma((Vector)this.R013, (Vector)term011);
                term011 = mK.qxy.fma((Vector)this.R121, (Vector)term011);
                term011 = mK.qxz.fma((Vector)this.R112, (Vector)term011);
                this.E011 = term011 = mK.qyz.fma((Vector)this.R022, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = mK.q.mul((Vector)this.R100);
                term100 = mK.dx.fma((Vector)this.R200, (Vector)term100);
                term100 = mK.dy.fma((Vector)this.R110, (Vector)term100);
                term100 = mK.dz.fma((Vector)this.R101, (Vector)term100);
                term100 = mK.qxx.fma((Vector)this.R300, (Vector)term100);
                term100 = mK.qyy.fma((Vector)this.R120, (Vector)term100);
                term100 = mK.qzz.fma((Vector)this.R102, (Vector)term100);
                term100 = mK.qxy.fma((Vector)this.R210, (Vector)term100);
                term100 = mK.qxz.fma((Vector)this.R201, (Vector)term100);
                term100 = mK.qyz.fma((Vector)this.R111, (Vector)term100);
                this.E100 = term100.neg();
                DoubleVector term010 = mK.q.mul((Vector)this.R010);
                term010 = mK.dx.fma((Vector)this.R110, (Vector)term010);
                term010 = mK.dy.fma((Vector)this.R020, (Vector)term010);
                term010 = mK.dz.fma((Vector)this.R011, (Vector)term010);
                term010 = mK.qxx.fma((Vector)this.R210, (Vector)term010);
                term010 = mK.qyy.fma((Vector)this.R030, (Vector)term010);
                term010 = mK.qzz.fma((Vector)this.R012, (Vector)term010);
                term010 = mK.qxy.fma((Vector)this.R120, (Vector)term010);
                term010 = mK.qxz.fma((Vector)this.R111, (Vector)term010);
                term010 = mK.qyz.fma((Vector)this.R021, (Vector)term010);
                this.E010 = term010.neg();
                DoubleVector term001 = mK.q.mul((Vector)this.R001);
                term001 = mK.dx.fma((Vector)this.R101, (Vector)term001);
                term001 = mK.dy.fma((Vector)this.R011, (Vector)term001);
                term001 = mK.dz.fma((Vector)this.R002, (Vector)term001);
                term001 = mK.qxx.fma((Vector)this.R201, (Vector)term001);
                term001 = mK.qyy.fma((Vector)this.R021, (Vector)term001);
                term001 = mK.qzz.fma((Vector)this.R003, (Vector)term001);
                term001 = mK.qxy.fma((Vector)this.R111, (Vector)term001);
                term001 = mK.qxz.fma((Vector)this.R102, (Vector)term001);
                term001 = mK.qyz.fma((Vector)this.R012, (Vector)term001);
                this.E001 = term001.neg();
            }
            case 0: 
        }
        DoubleVector term000 = mK.q.mul((Vector)this.R000);
        term000 = mK.dx.fma((Vector)this.R100, (Vector)term000);
        term000 = mK.dy.fma((Vector)this.R010, (Vector)term000);
        term000 = mK.dz.fma((Vector)this.R001, (Vector)term000);
        term000 = mK.qxx.fma((Vector)this.R200, (Vector)term000);
        term000 = mK.qyy.fma((Vector)this.R020, (Vector)term000);
        term000 = mK.qzz.fma((Vector)this.R002, (Vector)term000);
        term000 = mK.qxy.fma((Vector)this.R110, (Vector)term000);
        term000 = mK.qxz.fma((Vector)this.R101, (Vector)term000);
        this.E000 = term000 = mK.qyz.fma((Vector)this.R011, (Vector)term000);
    }

    @Override
    protected void chargeKPotentialAtI(PolarizableMultipoleSIMD mK, int order) {
        switch (order) {
            default: {
                this.E300 = mK.q.mul((Vector)this.R300).neg();
                this.E030 = mK.q.mul((Vector)this.R030).neg();
                this.E003 = mK.q.mul((Vector)this.R003).neg();
                this.E210 = mK.q.mul((Vector)this.R210).neg();
                this.E201 = mK.q.mul((Vector)this.R201).neg();
                this.E120 = mK.q.mul((Vector)this.R120).neg();
                this.E021 = mK.q.mul((Vector)this.R021).neg();
                this.E102 = mK.q.mul((Vector)this.R102).neg();
                this.E012 = mK.q.mul((Vector)this.R012).neg();
                this.E111 = mK.q.mul((Vector)this.R111).neg();
            }
            case 2: {
                this.E200 = mK.q.mul((Vector)this.R200);
                this.E020 = mK.q.mul((Vector)this.R020);
                this.E002 = mK.q.mul((Vector)this.R002);
                this.E110 = mK.q.mul((Vector)this.R110);
                this.E101 = mK.q.mul((Vector)this.R101);
                this.E011 = mK.q.mul((Vector)this.R011);
            }
            case 1: {
                this.E100 = mK.q.mul((Vector)this.R100).neg();
                this.E010 = mK.q.mul((Vector)this.R010).neg();
                this.E001 = mK.q.mul((Vector)this.R001).neg();
            }
            case 0: 
        }
        this.E000 = mK.q.mul((Vector)this.R000);
    }

    @Override
    protected void dipoleKPotentialAtI(DoubleVector uxk, DoubleVector uyk, DoubleVector uzk, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = uxk.mul((Vector)this.R400);
                term300 = uyk.fma((Vector)this.R310, (Vector)term300);
                term300 = uzk.fma((Vector)this.R301, (Vector)term300);
                this.E300 = term300.neg();
                DoubleVector term030 = uxk.mul((Vector)this.R130);
                term030 = uyk.fma((Vector)this.R040, (Vector)term030);
                term030 = uzk.fma((Vector)this.R031, (Vector)term030);
                this.E030 = term030.neg();
                DoubleVector term003 = uxk.mul((Vector)this.R103);
                term003 = uyk.fma((Vector)this.R013, (Vector)term003);
                term003 = uzk.fma((Vector)this.R004, (Vector)term003);
                this.E003 = term003.neg();
                DoubleVector term210 = uxk.mul((Vector)this.R310);
                term210 = uyk.fma((Vector)this.R220, (Vector)term210);
                term210 = uzk.fma((Vector)this.R211, (Vector)term210);
                this.E210 = term210.neg();
                DoubleVector term201 = uxk.mul((Vector)this.R301);
                term201 = uyk.fma((Vector)this.R211, (Vector)term201);
                term201 = uzk.fma((Vector)this.R202, (Vector)term201);
                this.E201 = term201.neg();
                DoubleVector term120 = uxk.mul((Vector)this.R220);
                term120 = uyk.fma((Vector)this.R130, (Vector)term120);
                term120 = uzk.fma((Vector)this.R121, (Vector)term120);
                this.E120 = term120.neg();
                DoubleVector term021 = uxk.mul((Vector)this.R121);
                term021 = uyk.fma((Vector)this.R031, (Vector)term021);
                term021 = uzk.fma((Vector)this.R022, (Vector)term021);
                this.E021 = term021.neg();
                DoubleVector term102 = uxk.mul((Vector)this.R202);
                term102 = uyk.fma((Vector)this.R112, (Vector)term102);
                term102 = uzk.fma((Vector)this.R103, (Vector)term102);
                this.E102 = term102.neg();
                DoubleVector term012 = uxk.mul((Vector)this.R112);
                term012 = uyk.fma((Vector)this.R022, (Vector)term012);
                term012 = uzk.fma((Vector)this.R013, (Vector)term012);
                this.E012 = term012.neg();
                DoubleVector term111 = uxk.mul((Vector)this.R211);
                term111 = uyk.fma((Vector)this.R121, (Vector)term111);
                term111 = uzk.fma((Vector)this.R112, (Vector)term111);
                this.E111 = term111.neg();
            }
            case 2: {
                DoubleVector term200 = uxk.mul((Vector)this.R300);
                term200 = uyk.fma((Vector)this.R210, (Vector)term200);
                this.E200 = term200 = uzk.fma((Vector)this.R201, (Vector)term200);
                DoubleVector term020 = uxk.mul((Vector)this.R120);
                term020 = uyk.fma((Vector)this.R030, (Vector)term020);
                this.E020 = term020 = uzk.fma((Vector)this.R021, (Vector)term020);
                DoubleVector term002 = uxk.mul((Vector)this.R102);
                term002 = uyk.fma((Vector)this.R012, (Vector)term002);
                this.E002 = term002 = uzk.fma((Vector)this.R003, (Vector)term002);
                DoubleVector term110 = uxk.mul((Vector)this.R210);
                term110 = uyk.fma((Vector)this.R120, (Vector)term110);
                this.E110 = term110 = uzk.fma((Vector)this.R111, (Vector)term110);
                DoubleVector term101 = uxk.mul((Vector)this.R201);
                term101 = uyk.fma((Vector)this.R111, (Vector)term101);
                this.E101 = term101 = uzk.fma((Vector)this.R102, (Vector)term101);
                DoubleVector term011 = uxk.mul((Vector)this.R111);
                term011 = uyk.fma((Vector)this.R021, (Vector)term011);
                this.E011 = term011 = uzk.fma((Vector)this.R012, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = uxk.mul((Vector)this.R200);
                term100 = uyk.fma((Vector)this.R110, (Vector)term100);
                term100 = uzk.fma((Vector)this.R101, (Vector)term100);
                this.E100 = term100.neg();
                DoubleVector term010 = uxk.mul((Vector)this.R110);
                term010 = uyk.fma((Vector)this.R020, (Vector)term010);
                term010 = uzk.fma((Vector)this.R011, (Vector)term010);
                this.E010 = term010.neg();
                DoubleVector term001 = uxk.mul((Vector)this.R101);
                term001 = uyk.fma((Vector)this.R011, (Vector)term001);
                term001 = uzk.fma((Vector)this.R002, (Vector)term001);
                this.E001 = term001.neg();
            }
            case 0: 
        }
        DoubleVector term000 = uxk.mul((Vector)this.R100);
        term000 = uyk.fma((Vector)this.R010, (Vector)term000);
        this.E000 = term000 = uzk.fma((Vector)this.R001, (Vector)term000);
    }

    @Override
    protected void quadrupoleKPotentialAtI(PolarizableMultipoleSIMD mK, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = mK.qxx.mul((Vector)this.R500);
                term300 = mK.qyy.fma((Vector)this.R320, (Vector)term300);
                term300 = mK.qzz.fma((Vector)this.R302, (Vector)term300);
                term300 = mK.qxy.fma((Vector)this.R410, (Vector)term300);
                term300 = mK.qxz.fma((Vector)this.R401, (Vector)term300);
                term300 = mK.qyz.fma((Vector)this.R311, (Vector)term300);
                this.E300 = term300.neg();
                DoubleVector term030 = mK.qxx.mul((Vector)this.R230);
                term030 = mK.qyy.fma((Vector)this.R050, (Vector)term030);
                term030 = mK.qzz.fma((Vector)this.R032, (Vector)term030);
                term030 = mK.qxy.fma((Vector)this.R140, (Vector)term030);
                term030 = mK.qxz.fma((Vector)this.R131, (Vector)term030);
                term030 = mK.qyz.fma((Vector)this.R041, (Vector)term030);
                this.E030 = term030.neg();
                DoubleVector term003 = mK.qxx.mul((Vector)this.R203);
                term003 = mK.qyy.fma((Vector)this.R023, (Vector)term003);
                term003 = mK.qzz.fma((Vector)this.R005, (Vector)term003);
                term003 = mK.qxy.fma((Vector)this.R113, (Vector)term003);
                term003 = mK.qxz.fma((Vector)this.R104, (Vector)term003);
                term003 = mK.qyz.fma((Vector)this.R014, (Vector)term003);
                this.E003 = term003.neg();
                DoubleVector term210 = mK.qxx.mul((Vector)this.R410);
                term210 = mK.qyy.fma((Vector)this.R230, (Vector)term210);
                term210 = mK.qzz.fma((Vector)this.R212, (Vector)term210);
                term210 = mK.qxy.fma((Vector)this.R320, (Vector)term210);
                term210 = mK.qxz.fma((Vector)this.R311, (Vector)term210);
                term210 = mK.qyz.fma((Vector)this.R221, (Vector)term210);
                this.E210 = term210.neg();
                DoubleVector term201 = mK.qxx.mul((Vector)this.R401);
                term201 = mK.qyy.fma((Vector)this.R221, (Vector)term201);
                term201 = mK.qzz.fma((Vector)this.R203, (Vector)term201);
                term201 = mK.qxy.fma((Vector)this.R311, (Vector)term201);
                term201 = mK.qxz.fma((Vector)this.R302, (Vector)term201);
                term201 = mK.qyz.fma((Vector)this.R212, (Vector)term201);
                this.E201 = term201.neg();
                DoubleVector term120 = mK.qxx.mul((Vector)this.R320);
                term120 = mK.qyy.fma((Vector)this.R140, (Vector)term120);
                term120 = mK.qzz.fma((Vector)this.R122, (Vector)term120);
                term120 = mK.qxy.fma((Vector)this.R230, (Vector)term120);
                term120 = mK.qxz.fma((Vector)this.R221, (Vector)term120);
                term120 = mK.qyz.fma((Vector)this.R131, (Vector)term120);
                this.E120 = term120.neg();
                DoubleVector term021 = mK.qxx.mul((Vector)this.R221);
                term021 = mK.qyy.fma((Vector)this.R041, (Vector)term021);
                term021 = mK.qzz.fma((Vector)this.R023, (Vector)term021);
                term021 = mK.qxy.fma((Vector)this.R131, (Vector)term021);
                term021 = mK.qxz.fma((Vector)this.R122, (Vector)term021);
                term021 = mK.qyz.fma((Vector)this.R032, (Vector)term021);
                this.E021 = term021.neg();
                DoubleVector term102 = mK.qxx.mul((Vector)this.R302);
                term102 = mK.qyy.fma((Vector)this.R122, (Vector)term102);
                term102 = mK.qzz.fma((Vector)this.R104, (Vector)term102);
                term102 = mK.qxy.fma((Vector)this.R212, (Vector)term102);
                term102 = mK.qxz.fma((Vector)this.R203, (Vector)term102);
                term102 = mK.qyz.fma((Vector)this.R113, (Vector)term102);
                this.E102 = term102.neg();
                DoubleVector term012 = mK.qxx.mul((Vector)this.R212);
                term012 = mK.qyy.fma((Vector)this.R032, (Vector)term012);
                term012 = mK.qzz.fma((Vector)this.R014, (Vector)term012);
                term012 = mK.qxy.fma((Vector)this.R122, (Vector)term012);
                term012 = mK.qxz.fma((Vector)this.R113, (Vector)term012);
                term012 = mK.qyz.fma((Vector)this.R023, (Vector)term012);
                this.E012 = term012.neg();
                DoubleVector term111 = mK.qxx.mul((Vector)this.R311);
                term111 = mK.qyy.fma((Vector)this.R131, (Vector)term111);
                term111 = mK.qzz.fma((Vector)this.R113, (Vector)term111);
                term111 = mK.qxy.fma((Vector)this.R221, (Vector)term111);
                term111 = mK.qxz.fma((Vector)this.R212, (Vector)term111);
                term111 = mK.qyz.fma((Vector)this.R122, (Vector)term111);
                this.E111 = term111.neg();
            }
            case 2: {
                DoubleVector term200 = mK.qxx.mul((Vector)this.R400);
                term200 = mK.qyy.fma((Vector)this.R220, (Vector)term200);
                term200 = mK.qzz.fma((Vector)this.R202, (Vector)term200);
                term200 = mK.qxy.fma((Vector)this.R310, (Vector)term200);
                term200 = mK.qxz.fma((Vector)this.R301, (Vector)term200);
                this.E200 = term200 = mK.qyz.fma((Vector)this.R211, (Vector)term200);
                DoubleVector term020 = mK.qxx.mul((Vector)this.R220);
                term020 = mK.qyy.fma((Vector)this.R040, (Vector)term020);
                term020 = mK.qzz.fma((Vector)this.R022, (Vector)term020);
                term020 = mK.qxy.fma((Vector)this.R130, (Vector)term020);
                term020 = mK.qxz.fma((Vector)this.R121, (Vector)term020);
                this.E020 = term020 = mK.qyz.fma((Vector)this.R031, (Vector)term020);
                DoubleVector term002 = mK.qxx.mul((Vector)this.R202);
                term002 = mK.qyy.fma((Vector)this.R022, (Vector)term002);
                term002 = mK.qzz.fma((Vector)this.R004, (Vector)term002);
                term002 = mK.qxy.fma((Vector)this.R112, (Vector)term002);
                term002 = mK.qxz.fma((Vector)this.R103, (Vector)term002);
                this.E002 = term002 = mK.qyz.fma((Vector)this.R013, (Vector)term002);
                DoubleVector term110 = mK.qxx.mul((Vector)this.R310);
                term110 = mK.qyy.fma((Vector)this.R130, (Vector)term110);
                term110 = mK.qzz.fma((Vector)this.R112, (Vector)term110);
                term110 = mK.qxy.fma((Vector)this.R220, (Vector)term110);
                term110 = mK.qxz.fma((Vector)this.R211, (Vector)term110);
                this.E110 = term110 = mK.qyz.fma((Vector)this.R121, (Vector)term110);
                DoubleVector term101 = mK.qxx.mul((Vector)this.R301);
                term101 = mK.qyy.fma((Vector)this.R121, (Vector)term101);
                term101 = mK.qzz.fma((Vector)this.R103, (Vector)term101);
                term101 = mK.qxy.fma((Vector)this.R211, (Vector)term101);
                term101 = mK.qxz.fma((Vector)this.R202, (Vector)term101);
                this.E101 = term101 = mK.qyz.fma((Vector)this.R112, (Vector)term101);
                DoubleVector term011 = mK.qxx.mul((Vector)this.R211);
                term011 = mK.qyy.fma((Vector)this.R031, (Vector)term011);
                term011 = mK.qzz.fma((Vector)this.R013, (Vector)term011);
                term011 = mK.qxy.fma((Vector)this.R121, (Vector)term011);
                term011 = mK.qxz.fma((Vector)this.R112, (Vector)term011);
                this.E011 = term011 = mK.qyz.fma((Vector)this.R022, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = mK.qxx.mul((Vector)this.R300);
                term100 = mK.qyy.fma((Vector)this.R120, (Vector)term100);
                term100 = mK.qzz.fma((Vector)this.R102, (Vector)term100);
                term100 = mK.qxy.fma((Vector)this.R210, (Vector)term100);
                term100 = mK.qxz.fma((Vector)this.R201, (Vector)term100);
                term100 = mK.qyz.fma((Vector)this.R111, (Vector)term100);
                this.E100 = term100.neg();
                DoubleVector term010 = mK.qxx.mul((Vector)this.R210);
                term010 = mK.qyy.fma((Vector)this.R030, (Vector)term010);
                term010 = mK.qzz.fma((Vector)this.R012, (Vector)term010);
                term010 = mK.qxy.fma((Vector)this.R120, (Vector)term010);
                term010 = mK.qxz.fma((Vector)this.R111, (Vector)term010);
                term010 = mK.qyz.fma((Vector)this.R021, (Vector)term010);
                this.E010 = term010.neg();
                DoubleVector term001 = mK.qxx.mul((Vector)this.R201);
                term001 = mK.qyy.fma((Vector)this.R021, (Vector)term001);
                term001 = mK.qzz.fma((Vector)this.R003, (Vector)term001);
                term001 = mK.qxy.fma((Vector)this.R111, (Vector)term001);
                term001 = mK.qxz.fma((Vector)this.R102, (Vector)term001);
                term001 = mK.qyz.fma((Vector)this.R012, (Vector)term001);
                this.E001 = term001.neg();
            }
            case 0: 
        }
        DoubleVector term000 = mK.qxx.mul((Vector)this.R200);
        term000 = mK.qyy.fma((Vector)this.R020, (Vector)term000);
        term000 = mK.qzz.fma((Vector)this.R002, (Vector)term000);
        term000 = mK.qxy.fma((Vector)this.R110, (Vector)term000);
        term000 = mK.qxz.fma((Vector)this.R101, (Vector)term000);
        this.E000 = term000 = mK.qyz.fma((Vector)this.R011, (Vector)term000);
    }

    @Override
    protected void multipoleIPotentialAtK(PolarizableMultipoleSIMD mI, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = mI.q.mul((Vector)this.R300);
                term300 = mI.dx.fma((Vector)this.R400.neg(), (Vector)term300);
                term300 = mI.dy.fma((Vector)this.R310.neg(), (Vector)term300);
                term300 = mI.dz.fma((Vector)this.R301.neg(), (Vector)term300);
                term300 = mI.qxx.fma((Vector)this.R500, (Vector)term300);
                term300 = mI.qyy.fma((Vector)this.R320, (Vector)term300);
                term300 = mI.qzz.fma((Vector)this.R302, (Vector)term300);
                term300 = mI.qxy.fma((Vector)this.R410, (Vector)term300);
                term300 = mI.qxz.fma((Vector)this.R401, (Vector)term300);
                this.E300 = term300 = mI.qyz.fma((Vector)this.R311, (Vector)term300);
                DoubleVector term030 = mI.q.mul((Vector)this.R030);
                term030 = mI.dx.fma((Vector)this.R130.neg(), (Vector)term030);
                term030 = mI.dy.fma((Vector)this.R040.neg(), (Vector)term030);
                term030 = mI.dz.fma((Vector)this.R031.neg(), (Vector)term030);
                term030 = mI.qxx.fma((Vector)this.R230, (Vector)term030);
                term030 = mI.qyy.fma((Vector)this.R050, (Vector)term030);
                term030 = mI.qzz.fma((Vector)this.R032, (Vector)term030);
                term030 = mI.qxy.fma((Vector)this.R140, (Vector)term030);
                term030 = mI.qxz.fma((Vector)this.R131, (Vector)term030);
                this.E030 = term030 = mI.qyz.fma((Vector)this.R041, (Vector)term030);
                DoubleVector term003 = mI.q.mul((Vector)this.R003);
                term003 = mI.dx.fma((Vector)this.R103.neg(), (Vector)term003);
                term003 = mI.dy.fma((Vector)this.R013.neg(), (Vector)term003);
                term003 = mI.dz.fma((Vector)this.R004.neg(), (Vector)term003);
                term003 = mI.qxx.fma((Vector)this.R203, (Vector)term003);
                term003 = mI.qyy.fma((Vector)this.R023, (Vector)term003);
                term003 = mI.qzz.fma((Vector)this.R005, (Vector)term003);
                term003 = mI.qxy.fma((Vector)this.R113, (Vector)term003);
                term003 = mI.qxz.fma((Vector)this.R104, (Vector)term003);
                this.E003 = term003 = mI.qyz.fma((Vector)this.R014, (Vector)term003);
                DoubleVector term210 = mI.q.mul((Vector)this.R210);
                term210 = mI.dx.fma((Vector)this.R310.neg(), (Vector)term210);
                term210 = mI.dy.fma((Vector)this.R220.neg(), (Vector)term210);
                term210 = mI.dz.fma((Vector)this.R211.neg(), (Vector)term210);
                term210 = mI.qxx.fma((Vector)this.R410, (Vector)term210);
                term210 = mI.qyy.fma((Vector)this.R230, (Vector)term210);
                term210 = mI.qzz.fma((Vector)this.R212, (Vector)term210);
                term210 = mI.qxy.fma((Vector)this.R320, (Vector)term210);
                term210 = mI.qxz.fma((Vector)this.R311, (Vector)term210);
                this.E210 = term210 = mI.qyz.fma((Vector)this.R221, (Vector)term210);
                DoubleVector term201 = mI.q.mul((Vector)this.R201);
                term201 = mI.dx.fma((Vector)this.R301.neg(), (Vector)term201);
                term201 = mI.dy.fma((Vector)this.R211.neg(), (Vector)term201);
                term201 = mI.dz.fma((Vector)this.R202.neg(), (Vector)term201);
                term201 = mI.qxx.fma((Vector)this.R401, (Vector)term201);
                term201 = mI.qyy.fma((Vector)this.R221, (Vector)term201);
                term201 = mI.qzz.fma((Vector)this.R203, (Vector)term201);
                term201 = mI.qxy.fma((Vector)this.R311, (Vector)term201);
                term201 = mI.qxz.fma((Vector)this.R302, (Vector)term201);
                this.E201 = term201 = mI.qyz.fma((Vector)this.R212, (Vector)term201);
                DoubleVector term120 = mI.q.mul((Vector)this.R120);
                term120 = mI.dx.fma((Vector)this.R220.neg(), (Vector)term120);
                term120 = mI.dy.fma((Vector)this.R130.neg(), (Vector)term120);
                term120 = mI.dz.fma((Vector)this.R121.neg(), (Vector)term120);
                term120 = mI.qxx.fma((Vector)this.R320, (Vector)term120);
                term120 = mI.qyy.fma((Vector)this.R140, (Vector)term120);
                term120 = mI.qzz.fma((Vector)this.R122, (Vector)term120);
                term120 = mI.qxy.fma((Vector)this.R230, (Vector)term120);
                term120 = mI.qxz.fma((Vector)this.R221, (Vector)term120);
                this.E120 = term120 = mI.qyz.fma((Vector)this.R131, (Vector)term120);
                DoubleVector term021 = mI.q.mul((Vector)this.R021);
                term021 = mI.dx.fma((Vector)this.R121.neg(), (Vector)term021);
                term021 = mI.dy.fma((Vector)this.R031.neg(), (Vector)term021);
                term021 = mI.dz.fma((Vector)this.R022.neg(), (Vector)term021);
                term021 = mI.qxx.fma((Vector)this.R221, (Vector)term021);
                term021 = mI.qyy.fma((Vector)this.R041, (Vector)term021);
                term021 = mI.qzz.fma((Vector)this.R023, (Vector)term021);
                term021 = mI.qxy.fma((Vector)this.R131, (Vector)term021);
                term021 = mI.qxz.fma((Vector)this.R122, (Vector)term021);
                this.E021 = term021 = mI.qyz.fma((Vector)this.R032, (Vector)term021);
                DoubleVector term102 = mI.q.mul((Vector)this.R102);
                term102 = mI.dx.fma((Vector)this.R202.neg(), (Vector)term102);
                term102 = mI.dy.fma((Vector)this.R112.neg(), (Vector)term102);
                term102 = mI.dz.fma((Vector)this.R103.neg(), (Vector)term102);
                term102 = mI.qxx.fma((Vector)this.R302, (Vector)term102);
                term102 = mI.qyy.fma((Vector)this.R122, (Vector)term102);
                term102 = mI.qzz.fma((Vector)this.R104, (Vector)term102);
                term102 = mI.qxy.fma((Vector)this.R212, (Vector)term102);
                term102 = mI.qxz.fma((Vector)this.R203, (Vector)term102);
                this.E102 = term102 = mI.qyz.fma((Vector)this.R113, (Vector)term102);
                DoubleVector term012 = mI.q.mul((Vector)this.R012);
                term012 = mI.dx.fma((Vector)this.R112.neg(), (Vector)term012);
                term012 = mI.dy.fma((Vector)this.R022.neg(), (Vector)term012);
                term012 = mI.dz.fma((Vector)this.R013.neg(), (Vector)term012);
                term012 = mI.qxx.fma((Vector)this.R212, (Vector)term012);
                term012 = mI.qyy.fma((Vector)this.R032, (Vector)term012);
                term012 = mI.qzz.fma((Vector)this.R014, (Vector)term012);
                term012 = mI.qxy.fma((Vector)this.R122, (Vector)term012);
                term012 = mI.qxz.fma((Vector)this.R113, (Vector)term012);
                this.E012 = term012 = mI.qyz.fma((Vector)this.R023, (Vector)term012);
                DoubleVector term111 = mI.q.mul((Vector)this.R111);
                term111 = mI.dx.fma((Vector)this.R211.neg(), (Vector)term111);
                term111 = mI.dy.fma((Vector)this.R121.neg(), (Vector)term111);
                term111 = mI.dz.fma((Vector)this.R112.neg(), (Vector)term111);
                term111 = mI.qxx.fma((Vector)this.R311, (Vector)term111);
                term111 = mI.qyy.fma((Vector)this.R131, (Vector)term111);
                term111 = mI.qzz.fma((Vector)this.R113, (Vector)term111);
                term111 = mI.qxy.fma((Vector)this.R221, (Vector)term111);
                term111 = mI.qxz.fma((Vector)this.R212, (Vector)term111);
                this.E111 = term111 = mI.qyz.fma((Vector)this.R122, (Vector)term111);
            }
            case 2: {
                DoubleVector term200 = mI.q.mul((Vector)this.R200);
                term200 = mI.dx.fma((Vector)this.R300.neg(), (Vector)term200);
                term200 = mI.dy.fma((Vector)this.R210.neg(), (Vector)term200);
                term200 = mI.dz.fma((Vector)this.R201.neg(), (Vector)term200);
                term200 = mI.qxx.fma((Vector)this.R400, (Vector)term200);
                term200 = mI.qyy.fma((Vector)this.R220, (Vector)term200);
                term200 = mI.qzz.fma((Vector)this.R202, (Vector)term200);
                term200 = mI.qxy.fma((Vector)this.R310, (Vector)term200);
                term200 = mI.qxz.fma((Vector)this.R301, (Vector)term200);
                this.E200 = term200 = mI.qyz.fma((Vector)this.R211, (Vector)term200);
                DoubleVector term020 = mI.q.mul((Vector)this.R020);
                term020 = mI.dx.fma((Vector)this.R120.neg(), (Vector)term020);
                term020 = mI.dy.fma((Vector)this.R030.neg(), (Vector)term020);
                term020 = mI.dz.fma((Vector)this.R021.neg(), (Vector)term020);
                term020 = mI.qxx.fma((Vector)this.R220, (Vector)term020);
                term020 = mI.qyy.fma((Vector)this.R040, (Vector)term020);
                term020 = mI.qzz.fma((Vector)this.R022, (Vector)term020);
                term020 = mI.qxy.fma((Vector)this.R130, (Vector)term020);
                term020 = mI.qxz.fma((Vector)this.R121, (Vector)term020);
                this.E020 = term020 = mI.qyz.fma((Vector)this.R031, (Vector)term020);
                DoubleVector term002 = mI.q.mul((Vector)this.R002);
                term002 = mI.dx.fma((Vector)this.R102.neg(), (Vector)term002);
                term002 = mI.dy.fma((Vector)this.R012.neg(), (Vector)term002);
                term002 = mI.dz.fma((Vector)this.R003.neg(), (Vector)term002);
                term002 = mI.qxx.fma((Vector)this.R202, (Vector)term002);
                term002 = mI.qyy.fma((Vector)this.R022, (Vector)term002);
                term002 = mI.qzz.fma((Vector)this.R004, (Vector)term002);
                term002 = mI.qxy.fma((Vector)this.R112, (Vector)term002);
                term002 = mI.qxz.fma((Vector)this.R103, (Vector)term002);
                this.E002 = term002 = mI.qyz.fma((Vector)this.R013, (Vector)term002);
                DoubleVector term110 = mI.q.mul((Vector)this.R110);
                term110 = mI.dx.fma((Vector)this.R210.neg(), (Vector)term110);
                term110 = mI.dy.fma((Vector)this.R120.neg(), (Vector)term110);
                term110 = mI.dz.fma((Vector)this.R111.neg(), (Vector)term110);
                term110 = mI.qxx.fma((Vector)this.R310, (Vector)term110);
                term110 = mI.qyy.fma((Vector)this.R130, (Vector)term110);
                term110 = mI.qzz.fma((Vector)this.R112, (Vector)term110);
                term110 = mI.qxy.fma((Vector)this.R220, (Vector)term110);
                term110 = mI.qxz.fma((Vector)this.R211, (Vector)term110);
                this.E110 = term110 = mI.qyz.fma((Vector)this.R121, (Vector)term110);
                DoubleVector term101 = mI.q.mul((Vector)this.R101);
                term101 = mI.dx.fma((Vector)this.R201.neg(), (Vector)term101);
                term101 = mI.dy.fma((Vector)this.R111.neg(), (Vector)term101);
                term101 = mI.dz.fma((Vector)this.R102.neg(), (Vector)term101);
                term101 = mI.qxx.fma((Vector)this.R301, (Vector)term101);
                term101 = mI.qyy.fma((Vector)this.R121, (Vector)term101);
                term101 = mI.qzz.fma((Vector)this.R103, (Vector)term101);
                term101 = mI.qxy.fma((Vector)this.R211, (Vector)term101);
                term101 = mI.qxz.fma((Vector)this.R202, (Vector)term101);
                this.E101 = term101 = mI.qyz.fma((Vector)this.R112, (Vector)term101);
                DoubleVector term011 = mI.q.mul((Vector)this.R011);
                term011 = mI.dx.fma((Vector)this.R111.neg(), (Vector)term011);
                term011 = mI.dy.fma((Vector)this.R021.neg(), (Vector)term011);
                term011 = mI.dz.fma((Vector)this.R012.neg(), (Vector)term011);
                term011 = mI.qxx.fma((Vector)this.R211, (Vector)term011);
                term011 = mI.qyy.fma((Vector)this.R031, (Vector)term011);
                term011 = mI.qzz.fma((Vector)this.R013, (Vector)term011);
                term011 = mI.qxy.fma((Vector)this.R121, (Vector)term011);
                term011 = mI.qxz.fma((Vector)this.R112, (Vector)term011);
                this.E011 = term011 = mI.qyz.fma((Vector)this.R022, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = mI.q.mul((Vector)this.R100);
                term100 = mI.dx.fma((Vector)this.R200.neg(), (Vector)term100);
                term100 = mI.dy.fma((Vector)this.R110.neg(), (Vector)term100);
                term100 = mI.dz.fma((Vector)this.R101.neg(), (Vector)term100);
                term100 = mI.qxx.fma((Vector)this.R300, (Vector)term100);
                term100 = mI.qyy.fma((Vector)this.R120, (Vector)term100);
                term100 = mI.qzz.fma((Vector)this.R102, (Vector)term100);
                term100 = mI.qxy.fma((Vector)this.R210, (Vector)term100);
                term100 = mI.qxz.fma((Vector)this.R201, (Vector)term100);
                this.E100 = term100 = mI.qyz.fma((Vector)this.R111, (Vector)term100);
                DoubleVector term010 = mI.q.mul((Vector)this.R010);
                term010 = mI.dx.fma((Vector)this.R110.neg(), (Vector)term010);
                term010 = mI.dy.fma((Vector)this.R020.neg(), (Vector)term010);
                term010 = mI.dz.fma((Vector)this.R011.neg(), (Vector)term010);
                term010 = mI.qxx.fma((Vector)this.R210, (Vector)term010);
                term010 = mI.qyy.fma((Vector)this.R030, (Vector)term010);
                term010 = mI.qzz.fma((Vector)this.R012, (Vector)term010);
                term010 = mI.qxy.fma((Vector)this.R120, (Vector)term010);
                term010 = mI.qxz.fma((Vector)this.R111, (Vector)term010);
                this.E010 = term010 = mI.qyz.fma((Vector)this.R021, (Vector)term010);
                DoubleVector term001 = mI.q.mul((Vector)this.R001);
                term001 = mI.dx.fma((Vector)this.R101.neg(), (Vector)term001);
                term001 = mI.dy.fma((Vector)this.R011.neg(), (Vector)term001);
                term001 = mI.dz.fma((Vector)this.R002.neg(), (Vector)term001);
                term001 = mI.qxx.fma((Vector)this.R201, (Vector)term001);
                term001 = mI.qyy.fma((Vector)this.R021, (Vector)term001);
                term001 = mI.qzz.fma((Vector)this.R003, (Vector)term001);
                term001 = mI.qxy.fma((Vector)this.R111, (Vector)term001);
                term001 = mI.qxz.fma((Vector)this.R102, (Vector)term001);
                this.E001 = term001 = mI.qyz.fma((Vector)this.R012, (Vector)term001);
            }
            case 0: 
        }
        DoubleVector term000 = mI.q.mul((Vector)this.R000);
        term000 = mI.dx.fma((Vector)this.R100.neg(), (Vector)term000);
        term000 = mI.dy.fma((Vector)this.R010.neg(), (Vector)term000);
        term000 = mI.dz.fma((Vector)this.R001.neg(), (Vector)term000);
        term000 = mI.qxx.fma((Vector)this.R200, (Vector)term000);
        term000 = mI.qyy.fma((Vector)this.R020, (Vector)term000);
        term000 = mI.qzz.fma((Vector)this.R002, (Vector)term000);
        term000 = mI.qxy.fma((Vector)this.R110, (Vector)term000);
        term000 = mI.qxz.fma((Vector)this.R101, (Vector)term000);
        this.E000 = term000 = mI.qyz.fma((Vector)this.R011, (Vector)term000);
    }

    @Override
    protected void chargeIPotentialAtK(PolarizableMultipoleSIMD mI, int order) {
        switch (order) {
            default: {
                this.E300 = mI.q.mul((Vector)this.R300);
                this.E030 = mI.q.mul((Vector)this.R030);
                this.E003 = mI.q.mul((Vector)this.R003);
                this.E210 = mI.q.mul((Vector)this.R210);
                this.E201 = mI.q.mul((Vector)this.R201);
                this.E120 = mI.q.mul((Vector)this.R120);
                this.E021 = mI.q.mul((Vector)this.R021);
                this.E102 = mI.q.mul((Vector)this.R102);
                this.E012 = mI.q.mul((Vector)this.R012);
                this.E111 = mI.q.mul((Vector)this.R111);
            }
            case 2: {
                this.E200 = mI.q.mul((Vector)this.R200);
                this.E020 = mI.q.mul((Vector)this.R020);
                this.E002 = mI.q.mul((Vector)this.R002);
                this.E110 = mI.q.mul((Vector)this.R110);
                this.E101 = mI.q.mul((Vector)this.R101);
                this.E011 = mI.q.mul((Vector)this.R011);
            }
            case 1: {
                this.E100 = mI.q.mul((Vector)this.R100);
                this.E010 = mI.q.mul((Vector)this.R010);
                this.E001 = mI.q.mul((Vector)this.R001);
            }
            case 0: 
        }
        this.E000 = mI.q.mul((Vector)this.R000);
    }

    @Override
    protected void dipoleIPotentialAtK(DoubleVector uxi, DoubleVector uyi, DoubleVector uzi, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = uxi.mul((Vector)this.R400.neg());
                term300 = uyi.fma((Vector)this.R310.neg(), (Vector)term300);
                this.E300 = term300 = uzi.fma((Vector)this.R301.neg(), (Vector)term300);
                DoubleVector term030 = uxi.mul((Vector)this.R130.neg());
                term030 = uyi.fma((Vector)this.R040.neg(), (Vector)term030);
                this.E030 = term030 = uzi.fma((Vector)this.R031.neg(), (Vector)term030);
                DoubleVector term003 = uxi.mul((Vector)this.R103.neg());
                term003 = uyi.fma((Vector)this.R013.neg(), (Vector)term003);
                this.E003 = term003 = uzi.fma((Vector)this.R004.neg(), (Vector)term003);
                DoubleVector term210 = uxi.mul((Vector)this.R310.neg());
                term210 = uyi.fma((Vector)this.R220.neg(), (Vector)term210);
                this.E210 = term210 = uzi.fma((Vector)this.R211.neg(), (Vector)term210);
                DoubleVector term201 = uxi.mul((Vector)this.R301.neg());
                term201 = uyi.fma((Vector)this.R211.neg(), (Vector)term201);
                this.E201 = term201 = uzi.fma((Vector)this.R202.neg(), (Vector)term201);
                DoubleVector term120 = uxi.mul((Vector)this.R220.neg());
                term120 = uyi.fma((Vector)this.R130.neg(), (Vector)term120);
                this.E120 = term120 = uzi.fma((Vector)this.R121.neg(), (Vector)term120);
                DoubleVector term021 = uxi.mul((Vector)this.R121.neg());
                term021 = uyi.fma((Vector)this.R031.neg(), (Vector)term021);
                this.E021 = term021 = uzi.fma((Vector)this.R022.neg(), (Vector)term021);
                DoubleVector term102 = uxi.mul((Vector)this.R202.neg());
                term102 = uyi.fma((Vector)this.R112.neg(), (Vector)term102);
                this.E102 = term102 = uzi.fma((Vector)this.R103.neg(), (Vector)term102);
                DoubleVector term012 = uxi.mul((Vector)this.R112.neg());
                term012 = uyi.fma((Vector)this.R022.neg(), (Vector)term012);
                this.E012 = term012 = uzi.fma((Vector)this.R013.neg(), (Vector)term012);
                DoubleVector term111 = uxi.mul((Vector)this.R211.neg());
                term111 = uyi.fma((Vector)this.R121.neg(), (Vector)term111);
                this.E111 = term111 = uzi.fma((Vector)this.R112.neg(), (Vector)term111);
            }
            case 2: {
                DoubleVector term200 = uxi.mul((Vector)this.R300.neg());
                term200 = uyi.fma((Vector)this.R210.neg(), (Vector)term200);
                this.E200 = term200 = uzi.fma((Vector)this.R201.neg(), (Vector)term200);
                DoubleVector term020 = uxi.mul((Vector)this.R120.neg());
                term020 = uyi.fma((Vector)this.R030.neg(), (Vector)term020);
                this.E020 = term020 = uzi.fma((Vector)this.R021.neg(), (Vector)term020);
                DoubleVector term002 = uxi.mul((Vector)this.R102.neg());
                term002 = uyi.fma((Vector)this.R012.neg(), (Vector)term002);
                this.E002 = term002 = uzi.fma((Vector)this.R003.neg(), (Vector)term002);
                DoubleVector term110 = uxi.mul((Vector)this.R210.neg());
                term110 = uyi.fma((Vector)this.R120.neg(), (Vector)term110);
                this.E110 = term110 = uzi.fma((Vector)this.R111.neg(), (Vector)term110);
                DoubleVector term101 = uxi.mul((Vector)this.R201.neg());
                term101 = uyi.fma((Vector)this.R111.neg(), (Vector)term101);
                this.E101 = term101 = uzi.fma((Vector)this.R102.neg(), (Vector)term101);
                DoubleVector term011 = uxi.mul((Vector)this.R111.neg());
                term011 = uyi.fma((Vector)this.R021.neg(), (Vector)term011);
                this.E011 = term011 = uzi.fma((Vector)this.R012.neg(), (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = uxi.mul((Vector)this.R200.neg());
                term100 = uyi.fma((Vector)this.R110.neg(), (Vector)term100);
                this.E100 = term100 = uzi.fma((Vector)this.R101.neg(), (Vector)term100);
                DoubleVector term010 = uxi.mul((Vector)this.R110.neg());
                term010 = uyi.fma((Vector)this.R020.neg(), (Vector)term010);
                this.E010 = term010 = uzi.fma((Vector)this.R011.neg(), (Vector)term010);
                DoubleVector term001 = uxi.mul((Vector)this.R101.neg());
                term001 = uyi.fma((Vector)this.R011.neg(), (Vector)term001);
                this.E001 = term001 = uzi.fma((Vector)this.R002.neg(), (Vector)term001);
            }
            case 0: 
        }
        DoubleVector term000 = uxi.mul((Vector)this.R100.neg());
        term000 = uyi.fma((Vector)this.R010.neg(), (Vector)term000);
        this.E000 = term000 = uzi.fma((Vector)this.R001.neg(), (Vector)term000);
    }

    @Override
    protected void quadrupoleIPotentialAtK(PolarizableMultipoleSIMD mI, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = mI.qxx.mul((Vector)this.R500);
                term300 = mI.qyy.fma((Vector)this.R320, (Vector)term300);
                term300 = mI.qzz.fma((Vector)this.R302, (Vector)term300);
                term300 = mI.qxy.fma((Vector)this.R410, (Vector)term300);
                term300 = mI.qxz.fma((Vector)this.R401, (Vector)term300);
                this.E300 = term300 = mI.qyz.fma((Vector)this.R311, (Vector)term300);
                DoubleVector term030 = mI.qxx.mul((Vector)this.R230);
                term030 = mI.qyy.fma((Vector)this.R050, (Vector)term030);
                term030 = mI.qzz.fma((Vector)this.R032, (Vector)term030);
                term030 = mI.qxy.fma((Vector)this.R140, (Vector)term030);
                term030 = mI.qxz.fma((Vector)this.R131, (Vector)term030);
                this.E030 = term030 = mI.qyz.fma((Vector)this.R041, (Vector)term030);
                DoubleVector term003 = mI.qxx.mul((Vector)this.R203);
                term003 = mI.qyy.fma((Vector)this.R023, (Vector)term003);
                term003 = mI.qzz.fma((Vector)this.R005, (Vector)term003);
                term003 = mI.qxy.fma((Vector)this.R113, (Vector)term003);
                term003 = mI.qxz.fma((Vector)this.R104, (Vector)term003);
                this.E003 = term003 = mI.qyz.fma((Vector)this.R014, (Vector)term003);
                DoubleVector term210 = mI.qxx.mul((Vector)this.R410);
                term210 = mI.qyy.fma((Vector)this.R230, (Vector)term210);
                term210 = mI.qzz.fma((Vector)this.R212, (Vector)term210);
                term210 = mI.qxy.fma((Vector)this.R320, (Vector)term210);
                term210 = mI.qxz.fma((Vector)this.R311, (Vector)term210);
                this.E210 = term210 = mI.qyz.fma((Vector)this.R221, (Vector)term210);
                DoubleVector term201 = mI.qxx.mul((Vector)this.R401);
                term201 = mI.qyy.fma((Vector)this.R221, (Vector)term201);
                term201 = mI.qzz.fma((Vector)this.R203, (Vector)term201);
                term201 = mI.qxy.fma((Vector)this.R311, (Vector)term201);
                term201 = mI.qxz.fma((Vector)this.R302, (Vector)term201);
                this.E201 = term201 = mI.qyz.fma((Vector)this.R212, (Vector)term201);
                DoubleVector term120 = mI.qxx.mul((Vector)this.R320);
                term120 = mI.qyy.fma((Vector)this.R140, (Vector)term120);
                term120 = mI.qzz.fma((Vector)this.R122, (Vector)term120);
                term120 = mI.qxy.fma((Vector)this.R230, (Vector)term120);
                term120 = mI.qxz.fma((Vector)this.R221, (Vector)term120);
                this.E120 = term120 = mI.qyz.fma((Vector)this.R131, (Vector)term120);
                DoubleVector term021 = mI.qxx.mul((Vector)this.R221);
                term021 = mI.qyy.fma((Vector)this.R041, (Vector)term021);
                term021 = mI.qzz.fma((Vector)this.R023, (Vector)term021);
                term021 = mI.qxy.fma((Vector)this.R131, (Vector)term021);
                term021 = mI.qxz.fma((Vector)this.R122, (Vector)term021);
                this.E021 = term021 = mI.qyz.fma((Vector)this.R032, (Vector)term021);
                DoubleVector term102 = mI.qxx.mul((Vector)this.R302);
                term102 = mI.qyy.fma((Vector)this.R122, (Vector)term102);
                term102 = mI.qzz.fma((Vector)this.R104, (Vector)term102);
                term102 = mI.qxy.fma((Vector)this.R212, (Vector)term102);
                term102 = mI.qxz.fma((Vector)this.R203, (Vector)term102);
                this.E102 = term102 = mI.qyz.fma((Vector)this.R113, (Vector)term102);
                DoubleVector term012 = mI.qxx.mul((Vector)this.R212);
                term012 = mI.qyy.fma((Vector)this.R032, (Vector)term012);
                term012 = mI.qzz.fma((Vector)this.R014, (Vector)term012);
                term012 = mI.qxy.fma((Vector)this.R122, (Vector)term012);
                term012 = mI.qxz.fma((Vector)this.R113, (Vector)term012);
                this.E012 = term012 = mI.qyz.fma((Vector)this.R023, (Vector)term012);
                DoubleVector term111 = mI.qxx.mul((Vector)this.R311);
                term111 = mI.qyy.fma((Vector)this.R131, (Vector)term111);
                term111 = mI.qzz.fma((Vector)this.R113, (Vector)term111);
                term111 = mI.qxy.fma((Vector)this.R221, (Vector)term111);
                term111 = mI.qxz.fma((Vector)this.R212, (Vector)term111);
                this.E111 = term111 = mI.qyz.fma((Vector)this.R122, (Vector)term111);
            }
            case 2: {
                DoubleVector term200 = mI.qxx.mul((Vector)this.R400);
                term200 = mI.qyy.fma((Vector)this.R220, (Vector)term200);
                term200 = mI.qzz.fma((Vector)this.R202, (Vector)term200);
                term200 = mI.qxy.fma((Vector)this.R310, (Vector)term200);
                term200 = mI.qxz.fma((Vector)this.R301, (Vector)term200);
                this.E200 = term200 = mI.qyz.fma((Vector)this.R211, (Vector)term200);
                DoubleVector term020 = mI.qxx.mul((Vector)this.R220);
                term020 = mI.qyy.fma((Vector)this.R040, (Vector)term020);
                term020 = mI.qzz.fma((Vector)this.R022, (Vector)term020);
                term020 = mI.qxy.fma((Vector)this.R130, (Vector)term020);
                term020 = mI.qxz.fma((Vector)this.R121, (Vector)term020);
                this.E020 = term020 = mI.qyz.fma((Vector)this.R031, (Vector)term020);
                DoubleVector term002 = mI.qxx.mul((Vector)this.R202);
                term002 = mI.qyy.fma((Vector)this.R022, (Vector)term002);
                term002 = mI.qzz.fma((Vector)this.R004, (Vector)term002);
                term002 = mI.qxy.fma((Vector)this.R112, (Vector)term002);
                term002 = mI.qxz.fma((Vector)this.R103, (Vector)term002);
                this.E002 = term002 = mI.qyz.fma((Vector)this.R013, (Vector)term002);
                DoubleVector term110 = mI.qxx.mul((Vector)this.R310);
                term110 = mI.qyy.fma((Vector)this.R130, (Vector)term110);
                term110 = mI.qzz.fma((Vector)this.R112, (Vector)term110);
                term110 = mI.qxy.fma((Vector)this.R220, (Vector)term110);
                term110 = mI.qxz.fma((Vector)this.R211, (Vector)term110);
                this.E110 = term110 = mI.qyz.fma((Vector)this.R121, (Vector)term110);
                DoubleVector term101 = mI.qxx.mul((Vector)this.R301);
                term101 = mI.qyy.fma((Vector)this.R121, (Vector)term101);
                term101 = mI.qzz.fma((Vector)this.R103, (Vector)term101);
                term101 = mI.qxy.fma((Vector)this.R211, (Vector)term101);
                term101 = mI.qxz.fma((Vector)this.R202, (Vector)term101);
                this.E101 = term101 = mI.qyz.fma((Vector)this.R112, (Vector)term101);
                DoubleVector term011 = mI.qxx.mul((Vector)this.R211);
                term011 = mI.qyy.fma((Vector)this.R031, (Vector)term011);
                term011 = mI.qzz.fma((Vector)this.R013, (Vector)term011);
                term011 = mI.qxy.fma((Vector)this.R121, (Vector)term011);
                term011 = mI.qxz.fma((Vector)this.R112, (Vector)term011);
                this.E011 = term011 = mI.qyz.fma((Vector)this.R022, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = mI.qxx.mul((Vector)this.R300);
                term100 = mI.qyy.fma((Vector)this.R120, (Vector)term100);
                term100 = mI.qzz.fma((Vector)this.R102, (Vector)term100);
                term100 = mI.qxy.fma((Vector)this.R210, (Vector)term100);
                term100 = mI.qxz.fma((Vector)this.R201, (Vector)term100);
                this.E100 = term100 = mI.qyz.fma((Vector)this.R111, (Vector)term100);
                DoubleVector term010 = mI.qxx.mul((Vector)this.R210);
                term010 = mI.qyy.fma((Vector)this.R030, (Vector)term010);
                term010 = mI.qzz.fma((Vector)this.R012, (Vector)term010);
                term010 = mI.qxy.fma((Vector)this.R120, (Vector)term010);
                term010 = mI.qxz.fma((Vector)this.R111, (Vector)term010);
                this.E010 = term010 = mI.qyz.fma((Vector)this.R021, (Vector)term010);
                DoubleVector term001 = mI.qxx.mul((Vector)this.R201);
                term001 = mI.qyy.fma((Vector)this.R021, (Vector)term001);
                term001 = mI.qzz.fma((Vector)this.R003, (Vector)term001);
                term001 = mI.qxy.fma((Vector)this.R111, (Vector)term001);
                term001 = mI.qxz.fma((Vector)this.R102, (Vector)term001);
                this.E001 = term001 = mI.qyz.fma((Vector)this.R012, (Vector)term001);
            }
            case 0: 
        }
        DoubleVector term000 = mI.qxx.mul((Vector)this.R200);
        term000 = mI.qyy.fma((Vector)this.R020, (Vector)term000);
        term000 = mI.qzz.fma((Vector)this.R002, (Vector)term000);
        term000 = mI.qxy.fma((Vector)this.R110, (Vector)term000);
        term000 = mI.qxz.fma((Vector)this.R101, (Vector)term000);
        this.E000 = term000 = mI.qyz.fma((Vector)this.R011, (Vector)term000);
    }
}

