/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

public final class MatrixMath {
    private MatrixMath() {
    }

    public static double mat3Determinant(double[][] m) {
        return m[0][0] * m[1][1] * m[2][2] - m[0][0] * m[1][2] * m[2][1] + m[0][1] * m[1][2] * m[2][0] - m[0][1] * m[1][0] * m[2][2] + m[0][2] * m[1][0] * m[2][1] - m[0][2] * m[1][1] * m[2][0];
    }

    public static double mat3Determinant(double[] m) {
        return m[0] * m[1] * m[2] - m[0] * m[5] * m[5] + m[3] * m[5] * m[4] - m[3] * m[3] * m[2] + m[4] * m[3] * m[5] - m[4] * m[1] * m[4];
    }

    public static double[][] mat3Inverse(double[][] m) {
        return MatrixMath.mat3Inverse(m, new double[3][3]);
    }

    public static double[][] mat3Inverse(double[][] m, double[][] output) {
        double inverseDet = 1.0 / MatrixMath.mat3Determinant(m);
        double r00 = (m[1][1] * m[2][2] - m[1][2] * m[2][1]) * inverseDet;
        double r01 = (m[0][2] * m[2][1] - m[0][1] * m[2][2]) * inverseDet;
        double r02 = (m[0][1] * m[1][2] - m[0][2] * m[1][1]) * inverseDet;
        double r10 = (m[1][2] * m[2][0] - m[1][0] * m[2][2]) * inverseDet;
        double r11 = (m[0][0] * m[2][2] - m[0][2] * m[2][0]) * inverseDet;
        double r12 = (m[0][2] * m[1][0] - m[0][0] * m[1][2]) * inverseDet;
        double r20 = (m[1][0] * m[2][1] - m[1][1] * m[2][0]) * inverseDet;
        double r21 = (m[0][1] * m[2][0] - m[0][0] * m[2][1]) * inverseDet;
        double r22 = (m[0][0] * m[1][1] - m[0][1] * m[1][0]) * inverseDet;
        output[0][0] = r00;
        output[0][1] = r01;
        output[0][2] = r02;
        output[1][0] = r10;
        output[1][1] = r11;
        output[1][2] = r12;
        output[2][0] = r20;
        output[2][1] = r21;
        output[2][2] = r22;
        return output;
    }

    public static double[][] mat3Mat3Multiply(double[][] m, double[][] n) {
        return MatrixMath.mat3Mat3Multiply(m, n, new double[3][3]);
    }

    public static double[][] mat3Mat3Multiply(double[][] m, double[][] n, double[][] result) {
        double r00 = m[0][0] * n[0][0] + m[0][1] * n[1][0] + m[0][2] * n[2][0];
        double r01 = m[0][0] * n[0][1] + m[0][1] * n[1][1] + m[0][2] * n[2][1];
        double r02 = m[0][0] * n[0][2] + m[0][1] * n[1][2] + m[0][2] * n[2][2];
        double r10 = m[1][0] * n[0][0] + m[1][1] * n[1][0] + m[1][2] * n[2][0];
        double r11 = m[1][0] * n[0][1] + m[1][1] * n[1][1] + m[1][2] * n[2][1];
        double r12 = m[1][0] * n[0][2] + m[1][1] * n[1][2] + m[1][2] * n[2][2];
        double r20 = m[2][0] * n[0][0] + m[2][1] * n[1][0] + m[2][2] * n[2][0];
        double r21 = m[2][0] * n[0][1] + m[2][1] * n[1][1] + m[2][2] * n[2][1];
        double r22 = m[2][0] * n[0][2] + m[2][1] * n[1][2] + m[2][2] * n[2][2];
        result[0][0] = r00;
        result[0][1] = r01;
        result[0][2] = r02;
        result[1][0] = r10;
        result[1][1] = r11;
        result[1][2] = r12;
        result[2][0] = r20;
        result[2][1] = r21;
        result[2][2] = r22;
        return result;
    }

    public static double[][] mat4Mat4(double[][] m1, double[][] m2) {
        return MatrixMath.mat4Mat4(m1, m2, new double[4][4]);
    }

    public static double[][] mat4Mat4(double[][] m1, double[][] m2, double[][] res) {
        double r00 = m1[0][0] * m2[0][0] + m1[0][1] * m2[1][0] + m1[0][2] * m2[2][0] + m1[0][3] * m2[3][0];
        double r01 = m1[0][0] * m2[0][1] + m1[0][1] * m2[1][1] + m1[0][2] * m2[2][1] + m1[0][3] * m2[3][1];
        double r02 = m1[0][0] * m2[0][2] + m1[0][1] * m2[1][2] + m1[0][2] * m2[2][2] + m1[0][3] * m2[3][2];
        double r03 = m1[0][0] * m2[0][3] + m1[0][1] * m2[1][3] + m1[0][2] * m2[2][3] + m1[0][3] * m2[3][3];
        double r10 = m1[1][0] * m2[0][0] + m1[1][1] * m2[1][0] + m1[1][2] * m2[2][0] + m1[1][3] * m2[3][0];
        double r11 = m1[1][0] * m2[0][1] + m1[1][1] * m2[1][1] + m1[1][2] * m2[2][1] + m1[1][3] * m2[3][1];
        double r12 = m1[1][0] * m2[0][2] + m1[1][1] * m2[1][2] + m1[1][2] * m2[2][2] + m1[1][3] * m2[3][2];
        double r13 = m1[1][0] * m2[0][3] + m1[1][1] * m2[1][3] + m1[1][2] * m2[2][3] + m1[1][3] * m2[3][3];
        double r20 = m1[2][0] * m2[0][0] + m1[2][1] * m2[1][0] + m1[2][2] * m2[2][0] + m1[2][3] * m2[3][0];
        double r21 = m1[2][0] * m2[0][1] + m1[2][1] * m2[1][1] + m1[2][2] * m2[2][1] + m1[2][3] * m2[3][1];
        double r22 = m1[2][0] * m2[0][2] + m1[2][1] * m2[1][2] + m1[2][2] * m2[2][2] + m1[2][3] * m2[3][2];
        double r23 = m1[2][0] * m2[0][3] + m1[2][1] * m2[1][3] + m1[2][2] * m2[2][3] + m1[2][3] * m2[3][3];
        double r30 = m1[3][0] * m2[0][0] + m1[3][1] * m2[1][0] + m1[3][2] * m2[2][0] + m1[3][3] * m2[3][0];
        double r31 = m1[3][0] * m2[0][1] + m1[3][1] * m2[1][1] + m1[3][2] * m2[2][1] + m1[3][3] * m2[3][1];
        double r32 = m1[3][0] * m2[0][2] + m1[3][1] * m2[1][2] + m1[3][2] * m2[2][2] + m1[3][3] * m2[3][2];
        double r33 = m1[3][0] * m2[0][3] + m1[3][1] * m2[1][3] + m1[3][2] * m2[2][3] + m1[3][3] * m2[3][3];
        res[0][0] = r00;
        res[0][1] = r01;
        res[0][2] = r02;
        res[0][3] = r03;
        res[1][0] = r10;
        res[1][1] = r11;
        res[1][2] = r12;
        res[1][3] = r13;
        res[2][0] = r20;
        res[2][1] = r21;
        res[2][2] = r22;
        res[2][3] = r23;
        res[3][0] = r30;
        res[3][1] = r31;
        res[3][2] = r32;
        res[3][3] = r33;
        return res;
    }

    public static double[][] mat3SymVec6(double[][] m, double[] v) {
        return MatrixMath.mat3SymVec6(m, v, new double[3][3]);
    }

    public static double[][] mat3SymVec6(double[][] m, double[] v, double[][] output) {
        double r00 = m[0][0] * v[0] + m[0][1] * v[3] + m[0][2] * v[4];
        double r01 = m[0][0] * v[3] + m[0][1] * v[1] + m[0][2] * v[5];
        double r02 = m[0][0] * v[4] + m[0][1] * v[5] + m[0][2] * v[2];
        double r10 = m[1][0] * v[0] + m[1][1] * v[3] + m[1][2] * v[4];
        double r11 = m[1][0] * v[3] + m[1][1] * v[1] + m[1][2] * v[5];
        double r12 = m[1][0] * v[4] + m[1][1] * v[5] + m[1][2] * v[2];
        double r20 = m[2][0] * v[0] + m[2][1] * v[3] + m[2][2] * v[4];
        double r21 = m[2][0] * v[3] + m[2][1] * v[1] + m[2][2] * v[5];
        double r22 = m[2][0] * v[4] + m[2][1] * v[5] + m[2][2] * v[2];
        output[0][0] = r00;
        output[0][1] = r01;
        output[0][2] = r02;
        output[1][0] = r10;
        output[1][1] = r11;
        output[1][2] = r12;
        output[2][0] = r20;
        output[2][1] = r21;
        output[2][2] = r22;
        return output;
    }

    public static double[][] mat3Transpose(double[][] m) {
        return MatrixMath.mat3Transpose(m, new double[3][3]);
    }

    public static double[][] mat3Transpose(double[][] m, double[][] output) {
        double m00 = m[0][0];
        double m01 = m[1][0];
        double m02 = m[2][0];
        double m10 = m[0][1];
        double m11 = m[1][1];
        double m12 = m[2][1];
        double m20 = m[0][2];
        double m21 = m[1][2];
        double m22 = m[2][2];
        output[0][0] = m00;
        output[0][1] = m10;
        output[0][2] = m20;
        output[1][0] = m01;
        output[1][1] = m11;
        output[1][2] = m21;
        output[2][0] = m02;
        output[2][1] = m12;
        output[2][2] = m22;
        return output;
    }

    public static double[] vec3Mat3(double[] v, double[][] m) {
        return MatrixMath.vec3Mat3(v, m, new double[3]);
    }

    public static double[] vec3Mat3(double[] v, double[][] m, double[] output) {
        double r0 = v[0] * m[0][0] + v[1] * m[1][0] + v[2] * m[2][0];
        double r1 = v[0] * m[0][1] + v[1] * m[1][1] + v[2] * m[2][1];
        double r2 = v[0] * m[0][2] + v[1] * m[1][2] + v[2] * m[2][2];
        output[0] = r0;
        output[1] = r1;
        output[2] = r2;
        return output;
    }
}

