/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

public class FloatMath {
    private static final Logger logger = Logger.getLogger(FloatMath.class.getName());

    private FloatMath() {
    }

    public static float[] fma(float[] a, float b, float[] c) {
        return FloatMath.fma(a, b, c, new float[3]);
    }

    public static float[] fma(float[] a, float b, float[] c, float[] ret) {
        ret[0] = Math.fma(a[0], b, c[0]);
        ret[1] = Math.fma(a[1], b, c[1]);
        ret[2] = Math.fma(a[2], b, c[2]);
        return ret;
    }

    public static float[] X(float[] a, float[] b) {
        return FloatMath.X(a, b, new float[3]);
    }

    public static float[] X(float[] a, float[] b, float[] ret) {
        ret[0] = a[1] * b[2] - a[2] * b[1];
        ret[1] = a[2] * b[0] - a[0] * b[2];
        ret[2] = a[0] * b[1] - a[1] * b[0];
        return ret;
    }

    public static float[] add(float[] a, float[] b) {
        return FloatMath.add(a, b, new float[3]);
    }

    public static float[] add(float[] a, float[] b, float[] ret) {
        ret[0] = a[0] + b[0];
        ret[1] = a[1] + b[1];
        ret[2] = a[2] + b[2];
        return ret;
    }

    public static float angle(float[] i, float[] j) {
        float x = FloatMath.dot(FloatMath.normalize(i), FloatMath.normalize(j));
        if (FastMath.abs((float)x) > 1.0f) {
            logger.warning(String.format(" Angle: abs(dot) > 1 %10.6f", Float.valueOf(x)));
            x = x > 0.0f ? 1.0f : -1.0f;
        }
        return (float)FastMath.acos((double)x);
    }

    public static float bondAngle(float[] i, float[] j, float[] k) {
        return FloatMath.angle(FloatMath.sub(i, j), FloatMath.sub(k, j));
    }

    public static float dihedralAngle(float[] a, float[] b, float[] c, float[] d) {
        float ru;
        float[] ba = FloatMath.sub(b, a);
        float[] cb = FloatMath.sub(c, b);
        float[] dc = FloatMath.sub(d, c);
        float[] t = FloatMath.X(ba, cb);
        float[] u = FloatMath.X(cb, dc);
        float rt = FloatMath.dot(t, t);
        float rtu = (float)FastMath.sqrt((double)(rt * (ru = FloatMath.dot(u, u))));
        if ((double)rtu != 0.0) {
            float rcb = FloatMath.length(cb);
            float cosine = FloatMath.dot(t, u) / rtu;
            float[] tu = FloatMath.X(t, u);
            float sine = FloatMath.dot(cb, tu) / (rcb * rtu);
            cosine = FastMath.min((float)1.0f, (float)FastMath.max((float)-1.0f, (float)cosine));
            float angle = (float)FastMath.acos((double)cosine);
            if ((double)sine < 0.0) {
                angle = -angle;
            }
            return angle;
        }
        return 0.0f;
    }

    public static float dist(float[] a, float[] b) {
        return (float)FastMath.sqrt((double)FloatMath.dist2(a, b));
    }

    public static float dist2(float[] a, float[] b) {
        float dx = a[0] - b[0];
        float dy = a[1] - b[1];
        float dz = a[2] - b[2];
        return Math.fma(dx, dx, Math.fma(dy, dy, dz * dz));
    }

    public static float dot(float[] a, float[] b) {
        return Math.fma(a[0], b[0], Math.fma(a[1], b[1], a[2] * b[2]));
    }

    public static float length(float[] d) {
        return (float)FastMath.sqrt((double)FloatMath.length2(d));
    }

    public static float length2(float[] d) {
        return Math.fma(d[0], d[0], Math.fma(d[1], d[1], d[2] * d[2]));
    }

    public static void log(float[] v) {
        logger.info(FloatMath.toString(v));
    }

    public static void log(float[] v, String label) {
        logger.info(FloatMath.toString(v, label));
    }

    public static float[] normalize(float[] n) {
        return FloatMath.scale(n, 1.0f / FloatMath.length(n), new float[3]);
    }

    public static float[] normalize(float[] n, float[] ret) {
        return FloatMath.scale(n, 1.0f / FloatMath.length(n), ret);
    }

    public static float[] scale(float[] n, float a) {
        return FloatMath.scale(n, a, new float[3]);
    }

    public static float[] scale(float[] n, float a, float[] ret) {
        ret[0] = n[0] * a;
        ret[1] = n[1] * a;
        ret[2] = n[2] * a;
        return ret;
    }

    public static float[] square(float[] n) {
        return FloatMath.square(n, new float[3]);
    }

    public static float[] square(float[] n, float[] ret) {
        ret[0] = n[0] * n[0];
        ret[1] = n[1] * n[1];
        ret[2] = n[2] * n[2];
        return ret;
    }

    public static float[] squareRoot(float[] n) {
        return FloatMath.squareRoot(n, new float[3]);
    }

    public static float[] squareRoot(float[] n, float[] ret) {
        ret[0] = (float)FastMath.sqrt((double)n[0]);
        ret[1] = (float)FastMath.sqrt((double)n[1]);
        ret[2] = (float)FastMath.sqrt((double)n[2]);
        return ret;
    }

    public static float[] sub(float[] a, float[] b) {
        return FloatMath.sub(a, b, new float[3]);
    }

    public static float[] sub(float[] a, float[] b, float[] ret) {
        ret[0] = a[0] - b[0];
        ret[1] = a[1] - b[1];
        ret[2] = a[2] - b[2];
        return ret;
    }

    public static String toString(float[] v) {
        StringBuilder sb = new StringBuilder("Vector ( ");
        for (float d : v) {
            sb.append(String.format("%g ", Float.valueOf(d)));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toString(@Nullable float[] v, @Nullable String label) {
        if (v == null) {
            return null;
        }
        if (label == null) {
            label = "v";
        }
        StringBuilder sb = new StringBuilder(String.format(" %16s = [", label));
        for (float value : v) {
            sb.append(String.format(" %16.8f", Float.valueOf(value)));
        }
        sb.append(" ]");
        return sb.toString();
    }
}

