/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import org.apache.commons.math3.util.FastMath;

public class ComplexNumber {
    private double re;
    private double im;

    public ComplexNumber() {
    }

    public ComplexNumber(double real, double imag) {
        this.re = real;
        this.im = imag;
    }

    public static ComplexNumber phaseShift(ComplexNumber a, double s) {
        ComplexNumber sc = new ComplexNumber(FastMath.cos((double)s), FastMath.sin((double)s));
        return a.times(sc);
    }

    public double abs() {
        return FastMath.hypot((double)this.re, (double)this.im);
    }

    public ComplexNumber conjugate() {
        return new ComplexNumber(this.re, -this.im);
    }

    public void conjugateIP() {
        this.im = -this.im;
    }

    public void copy(ComplexNumber b) {
        ComplexNumber a = this;
        a.re = b.re;
        a.im = b.im;
    }

    public ComplexNumber cos() {
        return new ComplexNumber(FastMath.cos((double)this.re) * FastMath.cosh((double)this.im), -FastMath.sin((double)this.re) * FastMath.sinh((double)this.im));
    }

    public ComplexNumber divides(ComplexNumber b) {
        ComplexNumber a = this;
        return a.times(b.reciprocal());
    }

    public ComplexNumber exp() {
        return new ComplexNumber(FastMath.exp((double)this.re) * FastMath.cos((double)this.im), FastMath.exp((double)this.re) * FastMath.sin((double)this.im));
    }

    public double im() {
        return this.im;
    }

    public void im(double im) {
        this.im = im;
    }

    public ComplexNumber minus(ComplexNumber b) {
        ComplexNumber a = this;
        double real = a.re - b.re;
        double imag = a.im - b.im;
        return new ComplexNumber(real, imag);
    }

    public void minusIP(ComplexNumber b) {
        ComplexNumber a = this;
        a.re -= b.re;
        a.im -= b.im;
    }

    public double phase() {
        return FastMath.atan2((double)this.im, (double)this.re);
    }

    public ComplexNumber phaseShift(double s) {
        ComplexNumber sc = new ComplexNumber(FastMath.cos((double)s), FastMath.sin((double)s));
        return this.times(sc);
    }

    public void phaseShiftIP(double s) {
        ComplexNumber a = this;
        double sr = FastMath.cos((double)s);
        double si = FastMath.sin((double)s);
        double real = a.re * sr - a.im * si;
        double imag = a.re * si + a.im * sr;
        a.re = real;
        a.im = imag;
    }

    public ComplexNumber plus(ComplexNumber b) {
        ComplexNumber a = this;
        double real = a.re + b.re;
        double imag = a.im + b.im;
        return new ComplexNumber(real, imag);
    }

    public void plusIP(ComplexNumber b) {
        ComplexNumber a = this;
        a.re += b.re;
        a.im += b.im;
    }

    public double re() {
        return this.re;
    }

    public void re(double re) {
        this.re = re;
    }

    public ComplexNumber reciprocal() {
        double scale = this.re * this.re + this.im * this.im;
        double iScale = 1.0 / scale;
        return new ComplexNumber(this.re * iScale, -this.im * iScale);
    }

    public void reciprocalIP() {
        double scale = this.re * this.re + this.im * this.im;
        double iScale = 1.0 / scale;
        this.re *= iScale;
        this.im *= -iScale;
    }

    public ComplexNumber sin() {
        return new ComplexNumber(FastMath.sin((double)this.re) * FastMath.cosh((double)this.im), FastMath.cos((double)this.re) * FastMath.sinh((double)this.im));
    }

    public ComplexNumber tan() {
        return this.sin().divides(this.cos());
    }

    public ComplexNumber times(ComplexNumber b) {
        ComplexNumber a = this;
        double real = a.re * b.re - a.im * b.im;
        double imag = a.re * b.im + a.im * b.re;
        return new ComplexNumber(real, imag);
    }

    public ComplexNumber times(double alpha) {
        return new ComplexNumber(alpha * this.re, alpha * this.im);
    }

    public void timesIP(ComplexNumber b) {
        ComplexNumber a = this;
        double real = a.re * b.re - a.im * b.im;
        double imag = a.re * b.im + a.im * b.re;
        a.re = real;
        a.im = imag;
    }

    public void timesIP(double alpha) {
        ComplexNumber a = this;
        a.re *= alpha;
        a.im *= alpha;
    }

    public String toString() {
        if (this.im == 0.0) {
            return "" + this.re;
        }
        if (this.re == 0.0) {
            return this.im + "i";
        }
        if (this.im < 0.0) {
            return this.re + " - " + -this.im + "i";
        }
        return this.re + " + " + this.im + "i";
    }
}

