/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import ffx.numerics.math.RunningStatistics;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.util.FastMath;

public class BootStrapStatistics {
    public final double mean;
    public final double var;
    public final double varPopulation;
    public final double sd;
    public final double sdPopulation;
    public final double sumWeights;
    public final double min;
    public final double max;
    public final long count;
    public final double sum;
    public final long dof;
    private final TDistribution tDist;
    private final String descString;

    public BootStrapStatistics(double[] values) {
        this(values, null, 0, values.length, 1);
    }

    public BootStrapStatistics(double[] values, int first) {
        this(values, null, first, values.length, 1);
    }

    public BootStrapStatistics(double[] values, int first, int last) {
        this(values, null, first, last, 1);
    }

    public BootStrapStatistics(double[] values, int first, int last, int stride) {
        this(values, null, first, last, stride);
    }

    public BootStrapStatistics(double[] values, @Nullable double[] weights, int first, int last, int stride) {
        int tempCount;
        if (values == null) {
            throw new IllegalArgumentException(" Cannot have null values!");
        }
        int nValues = BootStrapStatistics.getNumberOfValues(values, first, last);
        if (weights == null) {
            weights = new double[nValues];
            Arrays.fill(weights, 1.0);
        }
        this.count = (tempCount = last - first) % stride == 0 ? (long)(tempCount / stride) : (long)(tempCount / stride + 1);
        assert (this.count > 0L);
        if (this.count == 1L) {
            this.mean = values[first];
            this.var = Double.NaN;
            this.varPopulation = 0.0;
            this.sd = Double.NaN;
            this.sdPopulation = 0.0;
            this.min = this.mean;
            this.max = this.mean;
            this.sum = this.mean;
            this.sumWeights = weights[first];
            this.dof = 0L;
            this.tDist = null;
            this.descString = String.format(" Summary of single observation: value is %17.14g", this.mean);
        } else {
            RunningStatistics runningStatistics = this.getRunningStatistics(values, weights);
            this.min = runningStatistics.getMin();
            this.max = runningStatistics.getMax();
            this.mean = runningStatistics.getMean();
            this.sum = runningStatistics.getSum();
            this.sumWeights = runningStatistics.getWeight();
            this.varPopulation = runningStatistics.getPopulationVariance();
            this.sdPopulation = runningStatistics.getPopulationStandardDeviation();
            this.dof = runningStatistics.getDOF();
            this.var = runningStatistics.getVariance();
            this.sd = runningStatistics.getStandardDeviation();
            this.tDist = new TDistribution((double)this.dof);
            this.descString = String.format(" Summary of %d observations: sum is %17.14g, mean is %17.14g, min is %17.14g, max is %17.14g, and the sum of weights is %17.14g\nSample standard deviation: %17.14g (dof = %d)\nPopulation standard deviation: %17.14g (dof = %d)", this.count, this.sum, this.mean, this.min, this.max, this.sumWeights, this.sd, this.dof, this.sdPopulation, this.count);
        }
    }

    private RunningStatistics getRunningStatistics(double[] values, double[] weights) {
        RunningStatistics bootstrapRunningStatistics = new RunningStatistics();
        Random random = new Random();
        int bs = 0;
        while ((long)bs < this.count) {
            RunningStatistics bootstrapRound = new RunningStatistics();
            int i = 0;
            while ((long)i < this.count) {
                int j = random.nextInt((int)this.count);
                bootstrapRound.addValue(values[j], weights[j]);
                ++i;
            }
            bootstrapRunningStatistics.addValue(bootstrapRound.getMean());
            ++bs;
        }
        return bootstrapRunningStatistics;
    }

    private static int getNumberOfValues(double[] values, int first, int last) {
        int nValues = values.length;
        if (first < 0 || first > nValues - 1) {
            throw new IllegalArgumentException(String.format(" First entry %d was not in valid range 0-%d (0 to length of values - 1)", first, nValues - 1));
        }
        if (last <= first || last > nValues) {
            throw new IllegalArgumentException(String.format(" Last entry %d was not in valid range %d-%d (first+1 to length of values", last, first + 1, nValues));
        }
        return nValues;
    }

    public double confidenceInterval() {
        return this.confidenceInterval(0.05);
    }

    public double confidenceInterval(double alpha) {
        if (this.dof == 0L) {
            throw new IllegalArgumentException(" Cannot calculate confidence intervals when there are no degrees of freedom!");
        }
        double critVal = this.tDist.inverseCumulativeProbability(0.5 * (1.0 - alpha));
        return critVal * this.sd / FastMath.sqrt((double)this.count);
    }

    public double getMean() {
        return this.mean;
    }

    public double getSd() {
        return this.sd;
    }

    public double getVar() {
        return this.var;
    }

    public String toString() {
        return this.descString;
    }

    public String describe() {
        return String.format(" Mean: %12.6f +/-%12.6f, Min/Max: %12.6f/%12.6f", this.mean, this.sd, this.min, this.max);
    }
}

