/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.Complex;
import ffx.numerics.fft.Real;

public class Real3D {
    private final int nextX;
    private final int nextY;
    private final int nextZ;
    private final int nX;
    private final int nY;
    private final int nZ;
    private final int nX1;
    private final int nZ2;
    private final double[] work;
    private final double[] recip;
    private final Real fftX;
    private final Complex fftY;
    private final Complex fftZ;

    public Real3D(int nX, int nY, int nZ) {
        this.nX = nX / 2;
        this.nY = nY;
        this.nZ = nZ;
        this.nX1 = this.nX + 1;
        this.nZ2 = 2 * nZ;
        this.nextX = 2;
        this.nextY = nX + 2;
        this.nextZ = this.nextY * nY;
        this.work = new double[this.nZ2];
        this.recip = new double[this.nX1 * nY * nZ];
        this.fftX = new Real(nX);
        this.fftY = new Complex(nY);
        this.fftZ = new Complex(nZ);
    }

    public static int iReal3D(int i, int j, int k, int nX, int nY) {
        int xSide = nX + 2;
        int xySlice = xSide * nY;
        return i + j * xSide + k * xySlice;
    }

    public void convolution(double[] input) {
        int x;
        int y;
        int offset;
        int z;
        for (z = 0; z < this.nZ; ++z) {
            offset = z * this.nextZ;
            y = 0;
            while (y < this.nY) {
                this.fftX.fft(input, offset);
                ++y;
                offset += this.nextY;
            }
            offset = z * this.nextZ;
            x = 0;
            while (x < this.nX1) {
                this.fftY.fft(input, offset, this.nextY);
                ++x;
                offset += this.nextX;
            }
        }
        int index = 0;
        offset = 0;
        for (y = 0; y < this.nY; ++y) {
            int x2 = 0;
            while (x2 < this.nX1) {
                int i = 0;
                int z2 = offset;
                while (i < this.nZ2) {
                    this.work[i] = input[z2];
                    this.work[i + 1] = input[z2 + 1];
                    i += 2;
                    z2 += this.nextZ;
                }
                this.fftZ.fft(this.work, 0, 2);
                for (i = 0; i < this.nZ2; i += 2) {
                    double r = this.recip[index++];
                    int n = i;
                    this.work[n] = this.work[n] * r;
                    int n2 = i + 1;
                    this.work[n2] = this.work[n2] * r;
                }
                this.fftZ.ifft(this.work, 0, 2);
                i = 0;
                z2 = offset;
                while (i < this.nZ2) {
                    input[z2] = this.work[i];
                    input[z2 + 1] = this.work[i + 1];
                    i += 2;
                    z2 += this.nextZ;
                }
                ++x2;
                offset += this.nextX;
            }
        }
        for (z = 0; z < this.nZ; ++z) {
            offset = z * this.nextZ;
            x = 0;
            while (x < this.nX1) {
                this.fftY.ifft(input, offset, this.nextY);
                ++x;
                offset += this.nextX;
            }
            offset = z * this.nextZ;
            y = 0;
            while (y < this.nY) {
                this.fftX.ifft(input, offset);
                ++y;
                offset += this.nextY;
            }
        }
    }

    public void fft(double[] input) {
        int y;
        int offset;
        for (int z = 0; z < this.nZ; ++z) {
            offset = z * this.nextZ;
            y = 0;
            while (y < this.nY) {
                this.fftX.fft(input, offset);
                ++y;
                offset += this.nextY;
            }
            offset = z * this.nextZ;
            int x = 0;
            while (x < this.nX1) {
                this.fftY.fft(input, offset, this.nextY);
                ++x;
                offset += this.nextX;
            }
        }
        for (int x = 0; x < this.nX1; ++x) {
            offset = x * 2;
            y = 0;
            while (y < this.nY) {
                int i = 0;
                int z = offset;
                while (i < this.nZ2) {
                    this.work[i] = input[z];
                    this.work[i + 1] = input[z + 1];
                    i += 2;
                    z += this.nextZ;
                }
                this.fftZ.fft(this.work, 0, 2);
                i = 0;
                z = offset;
                while (i < this.nZ2) {
                    input[z] = this.work[i];
                    input[z + 1] = this.work[i + 1];
                    i += 2;
                    z += this.nextZ;
                }
                ++y;
                offset += this.nextY;
            }
        }
    }

    public void ifft(double[] input) {
        int y;
        int offset;
        for (int x = 0; x < this.nX1; ++x) {
            offset = x * 2;
            y = 0;
            while (y < this.nY) {
                int i = 0;
                int z = offset;
                while (i < this.nZ2) {
                    this.work[i] = input[z];
                    this.work[i + 1] = input[z + 1];
                    i += 2;
                    z += this.nextZ;
                }
                this.fftZ.ifft(this.work, 0, 2);
                i = 0;
                z = offset;
                while (i < this.nZ2) {
                    input[z] = this.work[i];
                    input[z + 1] = this.work[i + 1];
                    i += 2;
                    z += this.nextZ;
                }
                ++y;
                offset += this.nextY;
            }
        }
        for (int z = 0; z < this.nZ; ++z) {
            offset = z * this.nextZ;
            int x = 0;
            while (x < this.nX1) {
                this.fftY.ifft(input, offset, this.nextY);
                ++x;
                offset += this.nextX;
            }
            offset = z * this.nextZ;
            y = 0;
            while (y < this.nY) {
                this.fftX.ifft(input, offset);
                ++y;
                offset += this.nextY;
            }
        }
    }

    public void setRecip(double[] recip) {
        int index = 0;
        int offset = 0;
        for (int y = 0; y < this.nY; ++y) {
            int x = 0;
            while (x < this.nX1) {
                int i = 0;
                int z = offset;
                while (i < this.nZ) {
                    this.recip[index++] = recip[z];
                    ++i;
                    z += this.nX1 * this.nY;
                }
                ++x;
                ++offset;
            }
        }
    }
}

