/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.Complex;
import org.apache.commons.math3.util.FastMath;

public class Real {
    private final Complex complexFFT;
    private final int n;
    private final int halfN;
    private final double cosTheta;
    private final double sinTheta;
    private final double[] work;

    public Real(int n) {
        this.n = n;
        this.halfN = n / 2;
        double theta = Math.PI / (double)this.halfN;
        this.cosTheta = FastMath.cos((double)theta);
        this.sinTheta = FastMath.sin((double)theta);
        this.complexFFT = new Complex(this.halfN);
        this.work = new double[n + 2];
    }

    public void fft(double[] data, int offset) {
        this.complexFFT.fft(data, offset, 2);
        this.unpack(data, offset);
    }

    public void ifft(double[] data, int offset) {
        this.pack(data, offset);
        this.complexFFT.ifft(data, offset, 2);
        int ii = offset;
        for (int i = 0; i < this.n; ++i) {
            int n = ii++;
            data[n] = data[n] * 2.0;
        }
    }

    public void inverse(double[] data, int offset) {
        this.ifft(data, offset);
        double norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            int index;
            int n = index = offset + i;
            data[n] = data[n] * norm;
        }
    }

    private double normalization() {
        return 1.0 / (double)this.n;
    }

    private void unpack(double[] data, int offset) {
        System.arraycopy(data, offset, this.work, 0, this.n);
        double wrs = this.cosTheta;
        double wis = -this.sinTheta;
        double d0 = this.work[0];
        double d1 = this.work[1];
        int on = offset + this.n;
        int o1 = offset + 1;
        data[offset] = d0 + d1;
        data[o1] = 0.0;
        data[on] = d0 - d1;
        data[on + 1] = 0.0;
        double wr = wrs;
        double wi = wis;
        for (int i = 1; i < this.halfN; ++i) {
            int i1 = 2 * i;
            double rk = this.work[i1];
            double ik = this.work[i1 + 1];
            int i2 = this.n - 2 * i;
            double rn = this.work[i2];
            double in = this.work[i2 + 1];
            double s1r = 0.5 * (rk + rn);
            double s1i = 0.5 * (ik - in);
            double s2r = 0.5 * (ik + in);
            double s2i = 0.5 * (rn - rk);
            double fr = s1r + wr * s2r - wi * s2i;
            double fi = s1i + wi * s2r + wr * s2i;
            data[i1 + offset] = fr;
            data[i1 + 1 + offset] = fi;
            double wrp = wr;
            wr = wr * wrs - wi * wis;
            wi = wrp * wis + wi * wrs;
        }
    }

    private void pack(double[] data, int offset) {
        System.arraycopy(data, offset, this.work, 0, this.n + 2);
        double wrs = this.cosTheta;
        double wis = this.sinTheta;
        double wr = 1.0;
        double wi = 0.0;
        for (int i = 0; i < this.halfN; ++i) {
            int i1 = 2 * i;
            double fkr = this.work[i1];
            double fki = this.work[i1 + 1];
            int i2 = this.n - 2 * i;
            double fnr = this.work[i2];
            double fni = -this.work[i2 + 1];
            double s1r = fkr + fnr;
            double s1i = fki + fni;
            double s2r = fkr - fnr;
            double s2i = fki - fni;
            double fr = s2r * wr - s2i * wi;
            double fi = s2r * wi + s2i * wr;
            data[i1 + offset] = 0.5 * (s1r - fi);
            data[i1 + 1 + offset] = 0.5 * (s1i + fr);
            double wrp = wr;
            wr = wr * wrs - wi * wis;
            wi = wrp * wis + wi * wrs;
        }
    }
}

