/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.fft.Complex;
import ffx.numerics.fft.DataLayout1D;
import ffx.numerics.fft.DataLayout2D;
import java.util.Objects;
import java.util.Random;

public class Complex2D {
    private final DataLayout2D layout;
    private final int externalIm;
    private final int nX;
    private final int nY;
    private final int nextX;
    private final int nextY;
    private final Complex fftX;
    private final Complex fftY;
    private boolean packFFTs;
    private boolean useSIMD;
    private int nFFTX;
    private int nFFTY;
    private final Complex fftXTile;
    private final Complex fftYTile;
    private final double[] tile;
    private final int ii;
    private final int im;
    private final int imX;
    private final int imY;
    private final int trNextX;
    private final int trNextY;

    public Complex2D(int nX, int nY) {
        this(nX, nY, DataLayout2D.INTERLEAVED, 1);
    }

    public Complex2D(int nX, int nY, DataLayout2D layout, int imOffset) {
        this.nX = nX;
        this.nY = nY;
        this.externalIm = imOffset;
        this.layout = layout;
        int dX = nY;
        String pX = System.getProperty("fft.tileX", Integer.toString(dX));
        try {
            this.nFFTX = Integer.parseInt(pX);
            if (this.nFFTX < 1 || this.nFFTX > nY) {
                this.nFFTX = dX;
            }
        }
        catch (Exception e) {
            this.nFFTX = dX;
        }
        int dY = nX;
        String pY = System.getProperty("fft.tileY", Integer.toString(dY));
        try {
            this.nFFTY = Integer.parseInt(pY);
            if (this.nFFTY < 1 || this.nFFTY > nX) {
                this.nFFTY = dY;
            }
        }
        catch (Exception e) {
            this.nFFTY = dY;
        }
        if (layout == DataLayout2D.INTERLEAVED) {
            this.im = 1;
            this.imX = 1;
            this.imY = 1;
            this.ii = 2;
            this.nextX = 2;
            this.nextY = 2 * nX;
            this.trNextY = 2;
            this.trNextX = 2 * nY;
        } else if (layout == DataLayout2D.BLOCKED_X) {
            this.im = nX;
            this.imX = this.nFFTX == nX ? nX : nX * this.nFFTX;
            this.imY = this.nFFTY == nY ? nX : nY * this.nFFTY;
            this.ii = 1;
            this.nextX = 1;
            this.nextY = 2 * nX;
            this.trNextY = 1;
            this.trNextX = 2 * nY;
        } else if (layout == DataLayout2D.BLOCKED_XY) {
            this.im = nX * nY;
            this.imX = nX * this.nFFTX;
            this.imY = nY * this.nFFTY;
            this.ii = 1;
            this.nextX = 1;
            this.nextY = nX;
            this.trNextY = 1;
            this.trNextX = nY;
        } else {
            throw new IllegalArgumentException(" Unsupported data layout: " + String.valueOf((Object)layout));
        }
        if (this.externalIm != this.im) {
            throw new IllegalArgumentException(" Unsupported im offset: " + imOffset);
        }
        this.useSIMD = true;
        String simd = System.getProperty("fft.simd", Boolean.toString(this.useSIMD));
        try {
            this.useSIMD = Boolean.parseBoolean(simd);
        }
        catch (Exception e) {
            this.useSIMD = false;
        }
        this.packFFTs = true;
        String pack = System.getProperty("fft.pack", Boolean.toString(this.packFFTs));
        try {
            this.packFFTs = Boolean.parseBoolean(pack);
        }
        catch (Exception e) {
            this.packFFTs = false;
        }
        DataLayout1D layout1D = layout == DataLayout2D.INTERLEAVED ? DataLayout1D.INTERLEAVED : DataLayout1D.BLOCKED;
        this.fftX = new Complex(nX, layout1D, this.im);
        this.fftX.setUseSIMD(this.useSIMD);
        this.fftY = new Complex(nY, layout1D, this.im);
        this.fftY.setUseSIMD(this.useSIMD);
        this.fftXTile = new Complex(nX, layout1D, this.imX, this.nFFTX);
        this.fftXTile.setUseSIMD(this.useSIMD);
        this.fftYTile = new Complex(nY, layout1D, this.imY, this.nFFTY);
        this.fftYTile.setUseSIMD(this.useSIMD);
        int arraySize = Math.max(nX * this.nFFTX, this.nFFTY * nY);
        this.tile = new double[2 * arraySize];
    }

    public DataLayout2D getLayout() {
        return this.layout;
    }

    public void setUseSIMD(boolean useSIMD) {
        this.useSIMD = useSIMD;
        this.fftX.setUseSIMD(useSIMD);
        this.fftY.setUseSIMD(useSIMD);
        this.fftXTile.setUseSIMD(useSIMD);
        this.fftYTile.setUseSIMD(useSIMD);
    }

    public void setPackFFTs(boolean packFFTs) {
        this.packFFTs = packFFTs;
    }

    public void fft(double[] input, int index) {
        if (!this.packFFTs) {
            int offset = index;
            int y = 0;
            while (y < this.nY) {
                this.fftX.fft(input, offset, this.nextX);
                ++y;
                offset += this.nextY;
            }
            offset = index;
            int x = 0;
            while (x < this.nX) {
                this.fftY.fft(input, offset, this.nextY);
                ++x;
                offset += this.nextX;
            }
        } else {
            if (this.nFFTY == this.nX) {
                this.fftYTile.fft(input, index, this.ii);
            } else {
                for (int x = 0; x < this.nX; x += this.nFFTY) {
                    this.getFFTYTile(input, index, this.tile, x, this.nFFTY);
                    this.fftYTile.fft(this.tile, 0, this.ii);
                    this.setFFTYTile(input, index, this.tile, x, this.nFFTY);
                }
            }
            if (this.nFFTX == this.nY) {
                this.transpose(input, index);
                this.fftXTile.fft(this.tile, 0, this.ii);
                this.unTranspose(input, index);
            } else {
                for (int y = 0; y < this.nY; y += this.nFFTX) {
                    this.getFFTXTile(input, index, this.tile, y, this.nFFTX);
                    this.fftXTile.fft(this.tile, 0, this.ii);
                    this.setFFTXTile(input, index, this.tile, y, this.nFFTX);
                }
            }
        }
    }

    public void ifft(double[] input, int index) {
        if (!this.packFFTs) {
            int offset = index;
            int y = 0;
            while (y < this.nY) {
                this.fftX.ifft(input, offset, this.nextX);
                ++y;
                offset += this.nextY;
            }
            offset = index;
            int x = 0;
            while (x < this.nX) {
                this.fftY.ifft(input, offset, this.nextY);
                ++x;
                offset += this.nextX;
            }
        } else {
            if (this.nFFTY == this.nX) {
                this.fftYTile.ifft(input, index, this.ii);
            } else {
                for (int x = 0; x < this.nX; x += this.nFFTY) {
                    this.getFFTYTile(input, index, this.tile, x, this.nFFTY);
                    this.fftYTile.ifft(this.tile, 0, this.ii);
                    this.setFFTYTile(input, index, this.tile, x, this.nFFTY);
                }
            }
            if (this.nFFTX == this.nY) {
                this.transpose(input, index);
                this.fftXTile.ifft(this.tile, 0, this.ii);
                this.unTranspose(input, index);
            } else {
                for (int y = 0; y < this.nY; y += this.nFFTX) {
                    this.getFFTXTile(input, index, this.tile, y, this.nFFTX);
                    this.fftXTile.ifft(this.tile, 0, this.ii);
                    this.setFFTXTile(input, index, this.tile, y, this.nFFTX);
                }
            }
        }
    }

    private void getFFTYTile(double[] input, int offset, double[] tile, int firstX, int tileSize) {
        int index = 0;
        int padX = firstX + tileSize;
        int lastX = Math.min(this.nX, padX);
        for (int y = 0; y < this.nY; ++y) {
            int x;
            int dy = offset + y * this.nextY;
            for (x = firstX; x < lastX; ++x) {
                int dx = x * this.nextX;
                double real = input[dx + dy];
                double imag = input[dx + dy + this.externalIm];
                tile[index] = real;
                tile[index + this.imY] = imag;
                index += this.ii;
            }
            for (x = lastX; x < padX; ++x) {
                index += this.ii;
            }
        }
    }

    private void setFFTYTile(double[] input, int offset, double[] tile, int firstX, int tileSize) {
        int index = 0;
        int padX = firstX + tileSize;
        int lastX = Math.min(this.nX, padX);
        for (int y = 0; y < this.nY; ++y) {
            int x;
            int dy = offset + y * this.nextY;
            for (x = firstX; x < lastX; ++x) {
                double real = tile[index];
                double imag = tile[index + this.imY];
                index += this.ii;
                int dx = x * this.nextX;
                input[dx + dy] = real;
                input[dx + dy + this.externalIm] = imag;
            }
            for (x = lastX; x < padX; ++x) {
                index += this.ii;
            }
        }
    }

    private void getFFTXTile(double[] input, int offset, double[] tile, int firstY, int tileSize) {
        int index = 0;
        int padY = firstY + tileSize;
        int lastY = Math.min(this.nY, padY);
        for (int x = 0; x < this.nX; ++x) {
            int y;
            int dx = offset + x * this.nextX;
            for (y = firstY; y < lastY; ++y) {
                int dy = y * this.nextY;
                double real = input[dx + dy];
                double imag = input[dx + dy + this.externalIm];
                tile[index] = real;
                tile[index + this.imX] = imag;
                index += this.ii;
            }
            for (y = lastY; y < padY; ++y) {
                index += this.ii;
            }
        }
    }

    private void setFFTXTile(double[] input, int offset, double[] tile, int firstY, int tileSize) {
        int index = 0;
        int padY = firstY + tileSize;
        int lastY = Math.min(this.nY, padY);
        for (int x = 0; x < this.nX; ++x) {
            int y;
            int dx = offset + x * this.nextX;
            for (y = firstY; y < lastY; ++y) {
                double real = tile[index];
                double imag = tile[index + this.imX];
                index += this.ii;
                int dy = y * this.nextY;
                input[dx + dy] = real;
                input[dx + dy + this.externalIm] = imag;
            }
            for (y = lastY; y < padY; ++y) {
                index += this.ii;
            }
        }
    }

    private void transpose(double[] input, int offset) {
        int index = 0;
        for (int x = 0; x < this.nX; ++x) {
            int dx = offset + x * this.nextX;
            int y = 0;
            while (y < this.nY - 3) {
                int i1 = dx + y * this.nextY;
                int i2 = i1 + this.nextY;
                int i3 = i2 + this.nextY;
                int i4 = i3 + this.nextY;
                double real1 = input[i1];
                double imag1 = input[i1 + this.externalIm];
                double real2 = input[i2];
                double imag2 = input[i2 + this.externalIm];
                double real3 = input[i3];
                double imag3 = input[i3 + this.externalIm];
                double real4 = input[i4];
                double imag4 = input[i4 + this.externalIm];
                int ii2 = this.ii + this.ii;
                int ii3 = ii2 + this.ii;
                this.tile[index] = real1;
                this.tile[index + this.im] = imag1;
                this.tile[index + this.ii] = real2;
                this.tile[index + this.ii + this.im] = imag2;
                this.tile[index + ii2] = real3;
                this.tile[index + ii2 + this.im] = imag3;
                this.tile[index + ii3] = real4;
                this.tile[index + ii3 + this.im] = imag4;
                y += 4;
                index += 4 * this.ii;
            }
            while (y < this.nY) {
                double real = input[dx + y * this.nextY];
                double imag = input[dx + y * this.nextY + this.externalIm];
                this.tile[index] = real;
                this.tile[index + this.im] = imag;
                ++y;
                index += this.ii;
            }
        }
    }

    private void unTranspose(double[] output, int offset) {
        int index = offset;
        for (int y = 0; y < this.nY; ++y) {
            int dy = y * this.trNextY;
            int x = 0;
            while (x < this.nX - 3) {
                int i1 = dy + x * this.trNextX;
                int i2 = i1 + this.trNextX;
                int i3 = i2 + this.trNextX;
                int i4 = i3 + this.trNextX;
                double real1 = this.tile[i1];
                double imag1 = this.tile[i1 + this.im];
                double real2 = this.tile[i2];
                double imag2 = this.tile[i2 + this.im];
                double real3 = this.tile[i3];
                double imag3 = this.tile[i3 + this.im];
                double real4 = this.tile[i4];
                double imag4 = this.tile[i4 + this.im];
                int ii2 = this.ii + this.ii;
                int ii3 = ii2 + this.ii;
                output[index] = real1;
                output[index + this.externalIm] = imag1;
                output[index + this.ii] = real2;
                output[index + this.ii + this.externalIm] = imag2;
                output[index + ii2] = real3;
                output[index + ii2 + this.externalIm] = imag3;
                output[index + ii3] = real4;
                output[index + ii3 + this.externalIm] = imag4;
                x += 4;
                index += 4 * this.ii;
            }
            while (x < this.nX) {
                double real = this.tile[dy + x * this.trNextX];
                double imag = this.tile[dy + x * this.trNextX + this.im];
                output[index] = real;
                output[index + this.externalIm] = imag;
                ++x;
                index += this.ii;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int dimNotFinal = 128;
        int reps = 5;
        boolean blocked = false;
        try {
            dimNotFinal = Integer.parseInt(args[0]);
            if (dimNotFinal < 1) {
                dimNotFinal = 128;
            }
            if ((reps = Integer.parseInt(args[1])) < 1) {
                reps = 5;
            }
            blocked = Boolean.parseBoolean(args[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int dim = dimNotFinal;
        System.out.printf("Initializing a %d cubed grid.\nThe best timing out of %d repetitions will be used.%n", dim, reps);
        Complex2D complex2D = blocked ? new Complex2D(dim, dim, DataLayout2D.BLOCKED_X, dim) : new Complex2D(dim, dim);
        ParallelTeam parallelTeam = new ParallelTeam();
        double[] data = Complex2D.initRandomData(dim, parallelTeam);
        double toSeconds = 1.0E-9;
        long forwardTime = Long.MAX_VALUE;
        long inverseTime = Long.MAX_VALUE;
        System.out.println(" Warm Up FFT");
        complex2D.fft(data, 0);
        System.out.println(" Warm Up IFFT");
        complex2D.ifft(data, 0);
        for (int i = 0; i < reps; ++i) {
            System.out.printf(" Iteration %d%n", i + 1);
            long time = System.nanoTime();
            complex2D.fft(data, 0);
            time = System.nanoTime() - time;
            System.out.printf("  FFT:   %9.6f (sec)%n", toSeconds * (double)time);
            if (time < forwardTime) {
                forwardTime = time;
            }
            time = System.nanoTime();
            complex2D.ifft(data, 0);
            time = System.nanoTime() - time;
            System.out.printf("  IFFT:  %9.6f (sec)%n", toSeconds * (double)time);
            if (time >= inverseTime) continue;
            inverseTime = time;
        }
        System.out.printf(" Best FFT Time:    %9.6f (sec)%n", toSeconds * (double)forwardTime);
        System.out.printf(" Best IFFT Time:   %9.6f (sec)%n", toSeconds * (double)inverseTime);
        parallelTeam.shutdown();
    }

    public static double[] initRandomData(final int dim, ParallelTeam parallelTeam) {
        int n = dim * dim;
        final double[] data = new double[2 * n];
        try {
            parallelTeam.execute(new ParallelRegion(){

                public void run() {
                    try {
                        this.execute(0, dim - 1, new IntegerForLoop(this){
                            {
                                Objects.requireNonNull(this$0);
                            }

                            public void run(int lb, int ub) {
                                Random randomNumberGenerator = new Random(1L);
                                int index = dim * lb * 2;
                                for (int i = lb; i <= ub; ++i) {
                                    for (int j = 0; j < dim; ++j) {
                                        double randomNumber;
                                        data[index] = randomNumber = randomNumberGenerator.nextDouble();
                                        index += 2;
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.exit(-1);
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(-1);
        }
        return data;
    }
}

